/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import thing.ComponentWalker;
import thinlet.Thinlet;

public class ThinletWorkarounds {
    static Object get(Object component, String key) {
        Object[] entry = (Object[])component;
        while (entry != null) {
            if (key.equals((String)entry[0])) {
                return entry[1];
            }
            entry = (Object[])entry[2];
        }
        return null;
    }

    public static Color getColor(Object component, String key) {
        return (Color)ThinletWorkarounds.get(component, key);
    }

    public static Font getFont(Thinlet thinlet, Object component, String key) {
        Font font = ThinletWorkarounds.getFont(component, key);
        return font == null ? thinlet.getFont() : font;
    }

    public static Font getFont(Object component, String key) {
        return (Font)ThinletWorkarounds.get(component, key);
    }

    public static AWTKeyStroke getKeystroke(Object component, String key) {
        Object value = ThinletWorkarounds.get(component, key);
        if (value != null) {
            long keystroke = (Long)value;
            int modifiers = (int)(keystroke >> 32);
            int keycode = (int)(keystroke & 0xFFFFL);
            return AWTKeyStroke.getAWTKeyStroke(keycode, modifiers);
        }
        return null;
    }

    public static Color string2color(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return null;
        }
        int color = 0;
        if (value.startsWith("#")) {
            color = Integer.parseInt(value.substring(1), 16);
        } else if (value.startsWith("0x")) {
            color = Integer.parseInt(value.substring(2), 16);
        } else {
            StringTokenizer st = new StringTokenizer(value, " \r\n\t,");
            color = 0xFF000000 | (Integer.parseInt(st.nextToken()) & 0xFF) << 16 | (Integer.parseInt(st.nextToken()) & 0xFF) << 8 | Integer.parseInt(st.nextToken()) & 0xFF;
        }
        return new Color(color);
    }

    public static Font string2font(Thinlet thinlet, String value) {
        Font font = thinlet.getFont();
        String name = null;
        boolean bold = false;
        boolean italic = false;
        int size = 0;
        StringTokenizer st = new StringTokenizer(value);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("bold".equalsIgnoreCase(token)) {
                bold = true;
                continue;
            }
            if ("italic".equalsIgnoreCase(token)) {
                italic = true;
                continue;
            }
            try {
                size = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                name = name == null ? token : name + " " + token;
            }
        }
        if (name == null) {
            name = font.getName();
        }
        if (size == 0) {
            size = font.getSize();
        }
        return new Font(name, (bold ? 1 : 0) | (italic ? 2 : 0), size);
    }

    public static Enumeration getPropertyKeys(Object component) {
        Object table = ThinletWorkarounds.get(component, ":bind");
        if (table != null) {
            return ((Hashtable)table).keys();
        }
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                throw new NoSuchElementException("empty enumeration");
            }
        };
    }

    public static Object[] getItems(Thinlet thinlet, Object component) {
        String classname = Thinlet.getClass((Object)component);
        if (classname.equals("tree")) {
            HashSet result = new HashSet();
            ThinletWorkarounds.getAllTreeItems(thinlet, component, result);
            return result.toArray(new Object[result.size()]);
        }
        return thinlet.getItems(component);
    }

    public static int getIndexOfItem(Thinlet thinlet, Object component, Object item) {
        Object[] items = thinlet.getItems(component);
        for (int i = 0; i < items.length; ++i) {
            if (item != items[i]) continue;
            return i;
        }
        return -1;
    }

    public static void setSelectedItem(Thinlet thinlet, Object component, Object item) {
        Object[] items = ThinletWorkarounds.getItems(thinlet, component);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                thinlet.setBoolean(items[i], "selected", items[i] == item);
            }
        }
    }

    public static int getTotalCount(Thinlet thinlet, Object component) {
        class CountVisitor
        implements ComponentWalker.Visitor {
            int count = 0;

            CountVisitor() {
            }

            @Override
            public boolean visit(Object component, int depth) {
                ++this.count;
                return true;
            }

            @Override
            public void leave(Object component, int depth) {
            }
        }
        CountVisitor visitor = new CountVisitor();
        new ComponentWalker().walk(thinlet, component, visitor);
        return visitor.count;
    }

    public static String toString(Object component) {
        if (component == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer("[");
        String classname = Thinlet.getClass((Object)component);
        if (classname == null) {
            buf.append("not a component: ").append(component.toString());
        } else {
            buf.append(classname);
            String name = (String)ThinletWorkarounds.get(component, "name");
            if (name != null) {
                buf.append(':').append(name);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    private static void getAllTreeItems(Thinlet thinlet, Object component, Set result) {
        Object[] items = thinlet.getItems(component);
        result.addAll(Arrays.asList(items));
        for (int i = 0; i < items.length; ++i) {
            String classname = Thinlet.getClass((Object)items[i]);
            if (!classname.equals("node")) continue;
            ThinletWorkarounds.getAllTreeItems(thinlet, items[i], result);
        }
    }
}

