/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.type.GeometryType;

public class GeometryTypeUtils {
    private static final int ORACLE_UNKNOWN_GEOMETRY = 0;
    private static final int ORACLE_POINT = 1;
    private static final int ORACLE_LINE_OR_CURVE = 2;
    private static final int ORACLE_POLYGON = 3;
    private static final int ORACLE_COLLECTION = 4;
    private static final int ORACLE_MULTIPOINT = 5;
    private static final int ORACLE_MULTILINE_OR_MULTICURVE = 6;
    private static final int ORACLE_MULTIPOLYGON = 7;
    private static final int ORACLE_SOLID = 8;
    private static final int ORACLE_MULTISOLID = 9;
    public static final int SFS_GEOMETRY = 0;
    public static final int SFS_POINT = 1;
    public static final int SFS_LINE = 2;
    public static final int SFS_POLYGON = 3;
    public static final int SFS_MULTIPOINT = 4;
    public static final int SFS_MULTILINE = 5;
    public static final int SFS_MULTIPOLYGON = 6;
    public static final int SFS_GEOMCOLLECTION = 7;
    public static final int SFS_CURVE = 13;
    public static final int SFS_SURFACE = 14;
    public static final int SFS_POLYHEDRALSURFACE = 15;
    public static final int SFS_2D_THOUSANDS = 0;
    public static final int SFS_3D_THOUSANDS = 1;
    public static final int SFS_2DM_THOUSANDS = 2;
    public static final int SFS_3DM_THOUSANDS = 3;
    private static Map<String, GeometryType> databaseGeometryTypes = null;

    private static GeometryType getGT(GeometryManager manager, int type, int subtype) {
        try {
            return manager.getGeometryType(type, subtype);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static GeometryType getGeometryTypeFromDatabaseTypeName(String typeName) {
        if (databaseGeometryTypes == null) {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            databaseGeometryTypes = new HashMap<String, GeometryType>();
            databaseGeometryTypes.put("POINT", GeometryTypeUtils.getGT(manager, 1, 0));
            databaseGeometryTypes.put("POINTZ", GeometryTypeUtils.getGT(manager, 1, 1));
            databaseGeometryTypes.put("POINTM", GeometryTypeUtils.getGT(manager, 1, 2));
            databaseGeometryTypes.put("POINTZM", GeometryTypeUtils.getGT(manager, 1, 3));
            databaseGeometryTypes.put("LINESTRING", GeometryTypeUtils.getGT(manager, 18, 0));
            databaseGeometryTypes.put("LINESTRINGZ", GeometryTypeUtils.getGT(manager, 18, 1));
            databaseGeometryTypes.put("LINESTRINGM", GeometryTypeUtils.getGT(manager, 18, 2));
            databaseGeometryTypes.put("LINESTRINGZM", GeometryTypeUtils.getGT(manager, 18, 3));
            databaseGeometryTypes.put("POLYGON", GeometryTypeUtils.getGT(manager, 19, 0));
            databaseGeometryTypes.put("POLYGONZ", GeometryTypeUtils.getGT(manager, 19, 1));
            databaseGeometryTypes.put("POLYGONM", GeometryTypeUtils.getGT(manager, 19, 2));
            databaseGeometryTypes.put("POLYGONZM", GeometryTypeUtils.getGT(manager, 19, 3));
            databaseGeometryTypes.put("MULTIPOINT", GeometryTypeUtils.getGT(manager, 7, 0));
            databaseGeometryTypes.put("MULTIPOINTZ", GeometryTypeUtils.getGT(manager, 7, 1));
            databaseGeometryTypes.put("MULTIPOINTM", GeometryTypeUtils.getGT(manager, 7, 2));
            databaseGeometryTypes.put("MULTIPOINTZM", GeometryTypeUtils.getGT(manager, 7, 3));
            databaseGeometryTypes.put("MULTILINESTRING", GeometryTypeUtils.getGT(manager, 21, 0));
            databaseGeometryTypes.put("MULTILINESTRINGZ", GeometryTypeUtils.getGT(manager, 21, 1));
            databaseGeometryTypes.put("MULTILINESTRINGM", GeometryTypeUtils.getGT(manager, 21, 2));
            databaseGeometryTypes.put("MULTILINESTRINGZM", GeometryTypeUtils.getGT(manager, 21, 3));
            databaseGeometryTypes.put("MULTIPOLYGON", GeometryTypeUtils.getGT(manager, 22, 0));
            databaseGeometryTypes.put("MULTIPOLYGONZ", GeometryTypeUtils.getGT(manager, 22, 1));
            databaseGeometryTypes.put("MULTIPOLYGONM", GeometryTypeUtils.getGT(manager, 22, 2));
            databaseGeometryTypes.put("MULTIPOLYGONZM", GeometryTypeUtils.getGT(manager, 22, 3));
            databaseGeometryTypes.put("GEOMETRY", GeometryTypeUtils.getGT(manager, 0, 0));
            databaseGeometryTypes.put("GEOMETRYZ", GeometryTypeUtils.getGT(manager, 0, 1));
            databaseGeometryTypes.put("GEOMETRYM", GeometryTypeUtils.getGT(manager, 0, 2));
            databaseGeometryTypes.put("GEOMETRYZM", GeometryTypeUtils.getGT(manager, 0, 3));
            databaseGeometryTypes.put(null, GeometryTypeUtils.getGT(manager, -1, 4));
            databaseGeometryTypes.put("", GeometryTypeUtils.getGT(manager, -1, 0));
            databaseGeometryTypes.put("Z", GeometryTypeUtils.getGT(manager, -1, 1));
            databaseGeometryTypes.put("M", GeometryTypeUtils.getGT(manager, -1, 2));
            databaseGeometryTypes.put("ZM", GeometryTypeUtils.getGT(manager, -1, 3));
        }
        return databaseGeometryTypes.get(typeName);
    }

    public static int getSubType(int numDimensions) {
        return GeometryTypeUtils.getSubType(numDimensions, 0);
    }

    public static int getSubType(int numDimensions, int mDimPos) {
        switch (numDimensions) {
            case 2: {
                return 0;
            }
            case 3: {
                if (mDimPos > 0) {
                    return 2;
                }
                return 1;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    public static int getDimensions(int subtype) {
        switch (subtype) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 2;
    }

    public static GeometryType getGeometryTypeFromDatabaseTypeNumber(int typeCode) {
        int gvsigType;
        int dimensions = typeCode / 1000;
        int typeCodeRemainder = typeCode - 1000 * dimensions;
        int mDimPos = typeCodeRemainder / 100;
        int geomType = typeCodeRemainder - 100 * mDimPos;
        switch (geomType) {
            case 1: {
                gvsigType = 1;
                break;
            }
            case 2: {
                gvsigType = 18;
                break;
            }
            case 3: {
                gvsigType = 19;
                break;
            }
            case 5: {
                gvsigType = 7;
                break;
            }
            case 6: {
                gvsigType = 21;
                break;
            }
            case 7: {
                gvsigType = 22;
                break;
            }
            default: {
                gvsigType = 0;
            }
        }
        int gvsigSubtype = GeometryTypeUtils.getSubType(dimensions, mDimPos);
        GeometryManager manager = GeometryLocator.getGeometryManager();
        return GeometryTypeUtils.getGT(manager, gvsigType, gvsigSubtype);
    }

    public static GeometryType getGeometryTypeFromOracleName(String geomType, int dimensions) {
        String geomTypeWKT = "POINT".equals(geomType = geomType.toUpperCase()) ? "POINT" : ("LINE".equals(geomType) || "CURVE".equals(geomType) ? "LINESTRING" : ("POLYGON".equals(geomType) || "SURFACE".equals(geomType) ? "POLYGON" : ("MULTIPOINT".equals(geomType) ? "MULTIPOINT" : ("MULTILINE".equals(geomType) || "MULTICURVE".equals(geomType) ? "MULTILINESTRING" : ("MULTIPOLYGON".equals(geomType) || "MULTISURFACE".equals(geomType) ? "MULTIPOLYGON" : "")))));
        if (dimensions == 3) {
            geomTypeWKT = geomTypeWKT + "Z";
        }
        if (dimensions == 4) {
            geomTypeWKT = geomTypeWKT + "ZM";
        }
        return GeometryTypeUtils.getGeometryTypeFromDatabaseTypeName(geomTypeWKT);
    }

    public static String toOracleGeometryTypeName(int gvsigType) {
        switch (gvsigType) {
            case 1: {
                return "POINT";
            }
            case 7: {
                return "MULTIPOINT";
            }
            case 2: 
            case 12: {
                return "CURVE";
            }
            case 18: {
                return "LINE";
            }
            case 21: {
                return "MULTILINE";
            }
            case 8: {
                return "MULTICURVE";
            }
            case 19: {
                return "POLYGON";
            }
            case 3: {
                return "SURFACE";
            }
            case 9: 
            case 22: {
                return "MULTISURFACE";
            }
        }
        return "DEFAULT";
    }

    public static int toSFSGeometryTypeCode(int type, int subtype) {
        int sfsType;
        switch (type) {
            case 1: {
                sfsType = 1;
                break;
            }
            case 7: {
                sfsType = 4;
                break;
            }
            case 2: 
            case 12: {
                sfsType = 13;
                break;
            }
            case 18: {
                sfsType = 2;
                break;
            }
            case 21: {
                sfsType = 5;
                break;
            }
            case 19: {
                sfsType = 3;
                break;
            }
            case 3: {
                sfsType = 14;
                break;
            }
            case 22: {
                sfsType = 6;
                break;
            }
            default: {
                sfsType = 0;
            }
        }
        switch (subtype) {
            case 1: {
                sfsType += 1000;
                break;
            }
            case 2: {
                sfsType += 2000;
                break;
            }
            case 3: {
                sfsType += 3000;
            }
        }
        return sfsType;
    }

    public static GeometryType getGeometryTypeFromSFSTypeCode(int sfsCode) {
        int gvsigSubtype;
        int gvsigType;
        int dimensionCode = sfsCode / 1000;
        int sfsBaseType = sfsCode - 1000 * dimensionCode;
        switch (sfsBaseType) {
            case 1: {
                gvsigType = 1;
                break;
            }
            case 2: {
                gvsigType = 18;
                break;
            }
            case 3: {
                gvsigType = 19;
                break;
            }
            case 4: {
                gvsigType = 7;
                break;
            }
            case 5: {
                gvsigType = 21;
                break;
            }
            case 6: {
                gvsigType = 22;
                break;
            }
            case 13: {
                gvsigType = 2;
                break;
            }
            case 14: {
                gvsigType = 3;
                break;
            }
            default: {
                gvsigType = 0;
            }
        }
        switch (dimensionCode) {
            case 0: {
                gvsigSubtype = 0;
                break;
            }
            case 1: {
                gvsigSubtype = 1;
                break;
            }
            case 2: {
                gvsigSubtype = 2;
                break;
            }
            case 3: {
                gvsigSubtype = 3;
                break;
            }
            default: {
                gvsigSubtype = 4;
            }
        }
        GeometryManager manager = GeometryLocator.getGeometryManager();
        return GeometryTypeUtils.getGT(manager, gvsigType, gvsigSubtype);
    }
}

