/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.primitive.Envelope;

public class OracleDimensionMetadata {
    private static final String[] DEFAULT_DIM_NAMES = new String[]{"x", "y", "z", "m"};
    private static final double XTOLERANCE = 1.0E-5;
    private static final double YTOLERANCE = 1.0E-5;
    private String name;
    private double lb;
    private double ub;
    private double tolerance;

    public OracleDimensionMetadata(String name, double lb, double ub, double tolerance) {
        this.name = name;
        this.lb = lb;
        this.ub = ub;
        this.tolerance = tolerance;
    }

    public String getName() {
        return this.name;
    }

    public double getLowerBound() {
        return this.lb;
    }

    public double getUpperBound() {
        return this.ub;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLowerBound(double lb) {
        this.lb = lb;
    }

    public void setUpperBound(double ub) {
        this.ub = ub;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public static List<OracleDimensionMetadata> getDefaultDimensions(Envelope layerEnvelope) {
        ArrayList<OracleDimensionMetadata> dimensions = new ArrayList<OracleDimensionMetadata>();
        if (layerEnvelope != null) {
            for (int i = 0; i < DEFAULT_DIM_NAMES.length && i < layerEnvelope.getDimension(); ++i) {
                dimensions.add(new OracleDimensionMetadata(DEFAULT_DIM_NAMES[i], layerEnvelope.getMinimum(i), layerEnvelope.getMaximum(i), 1.0E-5));
            }
        }
        return dimensions;
    }
}

