/*
 * Decompiled with CFR 0.152.
 */
package javax.units;

import javax.units.BaseUnit;
import javax.units.Converter;
import javax.units.DerivedUnit;
import javax.units.ProductUnit;
import javax.units.Unit;

public final class AlternateUnit
extends DerivedUnit {
    private final Unit _baseUnits;

    private AlternateUnit(String symbol, Unit baseUnits) {
        super(symbol);
        this._baseUnits = baseUnits;
    }

    static AlternateUnit getInstance(String symbol, Unit systemUnit) {
        AlternateUnit newUnit = new AlternateUnit(symbol, AlternateUnit.getBaseUnits(systemUnit));
        return (AlternateUnit)AlternateUnit.getInstance(newUnit);
    }

    private static Unit getBaseUnits(Unit systemUnit) {
        if (systemUnit instanceof BaseUnit) {
            return systemUnit;
        }
        if (systemUnit instanceof AlternateUnit) {
            return ((AlternateUnit)systemUnit)._baseUnits;
        }
        if (systemUnit instanceof ProductUnit) {
            ProductUnit product = (ProductUnit)systemUnit;
            Unit baseUnits = ONE;
            for (int i = 0; i < product.size(); ++i) {
                ProductUnit.Element e = product.get(i);
                Unit unit = AlternateUnit.getBaseUnits(e.getUnit());
                unit = unit.pow(e.getPow());
                unit = unit.root(e.getRoot());
                baseUnits = baseUnits.multiply(unit);
            }
            return baseUnits;
        }
        throw new UnsupportedOperationException("Unit: " + systemUnit + " is not a system unit");
    }

    public final String getSymbol() {
        return this._symbol;
    }

    public Unit getSystemUnit() {
        return this;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof AlternateUnit && ((AlternateUnit)that)._baseUnits == this._baseUnits && ((AlternateUnit)that)._symbol.equals(this._symbol);
    }

    int calculateHashCode() {
        return this._symbol.hashCode();
    }

    Unit getCtxDimension() {
        return this._baseUnits.getCtxDimension();
    }

    Converter getCtxToDimension() {
        return this._baseUnits.getCtxToDimension();
    }
}

