/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.cresques.cts.IProjection;
import org.gvsig.export.ExportManager;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportProcess;
import org.gvsig.export.impl.DefaultExportProcess;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportManager
implements ExportManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExportManager.class);
    private Map<String, ExportManager.ExportFilter> filters = null;
    private File homeFolder = null;
    private final History<ExportParameters> history = ToolsLocator.getBookmarksAndHistoryManager().getHistoryGroup("ExportManager");
    private final Bookmarks<ExportParameters> bookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup("ExportManager");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFilters() {
        File filtersFile;
        this.filters = new HashMap<String, ExportManager.ExportFilter>();
        if (this.homeFolder != null && (filtersFile = new File(this.homeFolder, "filters")).exists()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filtersFile);
                Properties properties = new Properties();
                properties.load(fis);
                for (Object name : properties.keySet()) {
                    String value = (String)properties.get(name);
                    DefaultExportFilter filter = new DefaultExportFilter((String)name, value);
                    this.filters.put(filter.getName(), filter);
                }
            }
            catch (IOException ex) {
                try {
                    LOG.warn("Can't load filters file '" + filtersFile.getAbsolutePath() + "'.", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFilters() {
        if (this.homeFolder != null) {
            Properties properties = new Properties();
            for (ExportManager.ExportFilter filter : this.filters.values()) {
                properties.setProperty(filter.getName(), filter.getExpression());
            }
            File filtersFile = new File(this.homeFolder, "filters");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(filtersFile);
                properties.store(fos, "");
            }
            catch (IOException ex) {
                try {
                    LOG.warn("Can't load filters file '" + filtersFile.getAbsolutePath() + "'.", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    public Map<String, ExportManager.ExportFilter> getFiltersAsMap() {
        if (this.filters == null) {
            this.loadFilters();
        }
        return this.filters;
    }

    public List<ExportManager.ExportFilter> getFilters() {
        ArrayList<ExportManager.ExportFilter> l = new ArrayList<ExportManager.ExportFilter>();
        l.addAll(this.getFiltersAsMap().values());
        return l;
    }

    public ExportManager.ExportFilter getFilter(String filterName) {
        return this.getFiltersAsMap().get(filterName);
    }

    public ExportManager.ExportFilter addFilter(String name, String expression) {
        DefaultExportFilter filter = new DefaultExportFilter(name, expression);
        this.filters.put(filter.getName(), filter);
        return filter;
    }

    public void setHomeFolder(File homeFolder) {
        this.homeFolder = homeFolder;
    }

    public ExportProcess createProcess() {
        DefaultExportProcess process = new DefaultExportProcess();
        return process;
    }

    public ExportProcess createProcess(FeatureStore store) {
        DefaultExportProcess process = new DefaultExportProcess();
        process.setSourceFeatureStore(store);
        return process;
    }

    public ExportProcess createProcess(FeatureStore store, IProjection contextProjection) {
        DefaultExportProcess process = new DefaultExportProcess();
        process.setSourceFeatureStore(store);
        process.setContextProjection(contextProjection);
        return process;
    }

    public History<ExportParameters> getHistory() {
        return this.history;
    }

    public Bookmarks<ExportParameters> getBookmarks() {
        return this.bookmarks;
    }

    private static class DefaultExportFilter
    implements ExportManager.ExportFilter {
        private final String name;
        private final String expression;

        public DefaultExportFilter(String name, String expression) {
            this.name = name;
            this.expression = expression;
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }
    }
}

