/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.impl.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cresques.cts.ICoordTrans;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.Filter;
import org.gvsig.export.impl.ExportGeometryUtils;
import org.gvsig.export.impl.service.DefaultExportAttributes;
import org.gvsig.export.impl.service.DefaultExportGeometryHelper;
import org.gvsig.export.spi.ExportGeometryHelper;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExportServiceManager
implements ExportServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExportServiceManager.class);
    private final Map<String, ExportServiceFactory> factories = new HashMap<String, ExportServiceFactory>();

    public ExportServiceFactory getServiceFactory(String name) {
        ExportServiceFactory factory = this.factories.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("Don't exists export factory '" + name + "'.");
        }
        return factory;
    }

    public ExportService createService(ExportParameters parameters) {
        return this.getServiceFactory(parameters.getServiceName()).createService(parameters);
    }

    public ExportParameters createServiceParameters(String name) {
        return this.getServiceFactory(name).createParameters();
    }

    public void register(ExportServiceFactory factory) {
        this.factories.put(factory.getName(), factory);
    }

    public List<ExportServiceFactory> getAllServiceFactories() {
        ArrayList<ExportServiceFactory> result = new ArrayList<ExportServiceFactory>();
        result.addAll(this.factories.values());
        return Collections.unmodifiableList(result);
    }

    public List<ExportServiceFactory> getServiceFactories(Filter<ExportServiceFactory> filter) {
        ArrayList<ExportServiceFactory> result = new ArrayList<ExportServiceFactory>();
        if (filter == null) {
            result.addAll(this.factories.values());
        } else {
            for (ExportServiceFactory factory : this.factories.values()) {
                if (!factory.isEnabled() || !filter.apply((Object)factory)) continue;
                result.add(factory);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public ExportServiceManager.FixGeometryStatus fixGeometry(ExportParametersGeometry parmeters, ICoordTrans coord_trans, Geometry geometry) {
        return ExportGeometryUtils.fixGeometry(parmeters, coord_trans, geometry);
    }

    public ExportGeometryHelper createGeometryHelper(ExportParametersGeometry parameters, FeatureType theTargetFeatureType, FeatureType theSourceFeatureType) {
        DefaultExportGeometryHelper helper = new DefaultExportGeometryHelper(parameters, theTargetFeatureType, theSourceFeatureType);
        return helper;
    }

    public ExportAttributes createExportAttributes() {
        DefaultExportAttributes exp = new DefaultExportAttributes();
        return exp;
    }
}

