/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.buffer.impl.histogram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramBand;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.swing.buffer.RasterSwingBufferLocator;
import org.gvsig.raster.swing.buffer.RasterSwingBufferManager;
import org.gvsig.raster.swing.buffer.SelectableBandsTableModel;
import org.gvsig.raster.swing.buffer.exceptions.RasterCreatingPanelException;
import org.gvsig.raster.swing.buffer.histogram.HistogramPanel;
import org.gvsig.raster.swing.buffer.impl.histogram.HistogramPanelView;
import org.gvsig.raster.swing.buffer.impl.histogram.PerhapsNotValidValueCellRenderer;
import org.gvsig.raster.swing.buffer.impl.histogram.StatisticsTableModel;
import org.gvsig.raster.swing.buffer.impl.histogram.graphic.GraphicContainer;
import org.gvsig.raster.swing.buffer.impl.histogram.graphic.GraphicEvent;
import org.gvsig.raster.swing.buffer.impl.histogram.graphic.GraphicListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.jfree.data.xy.XYSeries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistogramPanelController
extends HistogramPanelView
implements HistogramPanel {
    private static final long serialVersionUID = 3098738174477175358L;
    private static final Logger LOG = LoggerFactory.getLogger(HistogramPanelController.class);
    private static String[] sources = new String[]{"_full", "_displayed_data"};
    private static String[] types = new String[]{"_normal", "_accumulated", "_logarithmic"};
    private static Color[] defaultColors = new Color[]{Color.red, Color.green, Color.blue, Color.darkGray, Color.cyan, Color.magenta, Color.yellow, Color.black, Color.orange};
    private Statistics statistics;
    private SelectableBandsTableModel tableModel;
    private Statistics fullStatistics;
    private Statistics visibleStatistics;
    private boolean enabledVisibleStatistics;
    private GraphicContainer graphicContainer;
    private Color[] colors;
    boolean initialized = false;

    public HistogramPanelController() throws RasterCreatingPanelException {
        this.translate();
        this.initializeComponents();
    }

    public void set(Statistics statistics) throws RasterCreatingPanelException {
        this.fullStatistics = statistics;
        this.statistics = statistics;
        if (this.tableModel != null) {
            this.init();
        }
    }

    public void set(SelectableBandsTableModel tableModel) throws RasterCreatingPanelException {
        this.tableModel = tableModel;
        if (this.statistics != null) {
            this.init();
        }
    }

    public void setVisibleStatistics(Statistics visibleStatistics) {
        this.visibleStatistics = visibleStatistics;
        if (this.initialized) {
            this.updateComponents();
        }
    }

    public void setBandColors(Color[] colors) {
        this.colors = colors;
        if (this.initialized) {
            this.updateComponents();
        }
    }

    private void init() throws RasterCreatingPanelException {
        RasterSwingBufferManager swingManager = RasterSwingBufferLocator.getSwingManager();
        swingManager.makeASelectableBandsTable(this.tblBands, this.tableModel);
        ((SelectableBandsTableModel)this.tblBands.getModel()).addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                HistogramPanelController.this.updateComponents();
            }
        });
        this.updateComponents();
        this.initialized = true;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initializeComponents() {
        this.cmbSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanelController.this.updateComponents();
            }
        });
        this.cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanelController.this.updateComponents();
            }
        });
        this.btnAllBands.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanelController.this.doSelectAllBands();
            }
        });
        this.btnClearBands.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanelController.this.doUnselectAllBands();
            }
        });
        this.btnExportTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanelController.this.doExportTable();
            }
        });
        this.cmbSource.setSelectedIndex(0);
        this.cmbSource.setEditable(false);
        this.tblBands.setRowSelectionAllowed(true);
        this.tblBands.setColumnSelectionAllowed(false);
        this.tblBands.setSelectionMode(0);
        this.tblStatistics.setRowSelectionAllowed(false);
        this.tblBands.setColumnSelectionAllowed(false);
        this.chkRemoveTails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanelController.this.doRemoveTails();
            }
        });
        this.chkShowStatistics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPanelController.this.doShowStatistics();
            }
        });
        this.pnlHistogram.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.graphicContainer = this.getGraphicContainer();
        this.graphicContainer.addValueChangedListener(new GraphicListener(){

            @Override
            public void actionValueChanged(GraphicEvent e) {
                HistogramPanelController.this.updateComponents();
            }
        });
        this.pnlHistogram.add((Component)this.getGraphicContainer(), c);
    }

    public GraphicContainer getGraphicContainer() {
        if (this.graphicContainer == null) {
            this.graphicContainer = new GraphicContainer(true);
        }
        return this.graphicContainer;
    }

    protected void doShowStatistics() {
        boolean showStatistics = this.chkShowStatistics.isSelected();
        JScrollPane scrollPane = this.getScrollPane(this.tblStatistics);
        if (scrollPane != null) {
            scrollPane.setVisible(showStatistics);
        }
        this.tblStatistics.setVisible(showStatistics);
        this.tblStatistics.getTableHeader().setVisible(showStatistics);
        this.btnExportTable.setVisible(showStatistics);
        this.chkRemoveTails.setVisible(showStatistics);
    }

    private JScrollPane getScrollPane(JTable table) {
        Container container;
        JScrollPane scrollPane = null;
        Container parent = SwingUtilities.getUnwrappedParent(table);
        if (parent instanceof JViewport && (container = parent.getParent()) instanceof JScrollPane) {
            scrollPane = (JScrollPane)container;
        }
        return scrollPane;
    }

    protected void doRemoveTails() {
        this.updateComponents();
    }

    protected void doExportTable() {
    }

    protected void doUnselectAllBands() {
        ((SelectableBandsTableModel)this.tblBands.getModel()).unselectAllBands();
    }

    protected void doSelectAllBands() {
        ((SelectableBandsTableModel)this.tblBands.getModel()).selectAllBands();
    }

    private void translate() {
        int i;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblSource.setText(i18nManager.getTranslation(this.lblSource.getText()));
        this.lblSource.setToolTipText(i18nManager.getTranslation(this.lblSource.getToolTipText()));
        this.lblType.setText(i18nManager.getTranslation(this.lblType.getText()));
        this.lblType.setToolTipText(i18nManager.getTranslation(this.lblType.getToolTipText()));
        this.lblBands.setText(i18nManager.getTranslation(this.lblBands.getText()));
        this.lblBands.setToolTipText(i18nManager.getTranslation(this.lblBands.getToolTipText()));
        this.cmbSource.removeAllItems();
        for (i = 0; i < sources.length; ++i) {
            this.cmbSource.addItem(i18nManager.getTranslation(sources[i]));
        }
        this.cmbType.removeAllItems();
        for (i = 0; i < types.length; ++i) {
            this.cmbType.addItem(i18nManager.getTranslation(types[i]));
        }
        this.btnAllBands.setText(i18nManager.getTranslation(this.btnAllBands.getText()));
        this.btnAllBands.setToolTipText(i18nManager.getTranslation(this.btnAllBands.getToolTipText()));
        this.btnClearBands.setText(i18nManager.getTranslation(this.btnClearBands.getText()));
        this.btnClearBands.setToolTipText(i18nManager.getTranslation(this.btnClearBands.getToolTipText()));
        this.btnExportTable.setText(i18nManager.getTranslation(this.btnExportTable.getText()));
        this.btnExportTable.setToolTipText(i18nManager.getTranslation(this.btnExportTable.getToolTipText()));
        this.chkRemoveTails.setText(i18nManager.getTranslation(this.chkRemoveTails.getText()));
        this.chkRemoveTails.setToolTipText(i18nManager.getTranslation(this.chkRemoveTails.getToolTipText()));
        this.chkShowStatistics.setText(i18nManager.getTranslation(this.chkShowStatistics.getText()));
        this.chkShowStatistics.setToolTipText(i18nManager.getTranslation(this.chkShowStatistics.getToolTipText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    private void updateComponents() {
        if (this.fullStatistics == null || this.tableModel == null) {
            return;
        }
        if (this.enabledVisibleStatistics) {
            this.cmbSource.setEnabled(true);
        } else {
            this.cmbSource.setSelectedIndex(0);
            this.cmbSource.setEnabled(false);
        }
        this.statistics = this.cmbSource.getSelectedIndex() == 0 ? this.fullStatistics : this.visibleStatistics;
        this.updateStatisticsTable();
        this.updateHistogramGraphic();
    }

    private void updateStatisticsTable() {
        List selectedBands = ((SelectableBandsTableModel)this.tblBands.getModel()).getSelectedBands();
        StatisticsTableModel statisticsModel = new StatisticsTableModel(this.statistics, selectedBands);
        this.tblStatistics.setModel(statisticsModel);
        this.tblStatistics.setColumnModel(new DefaultTableColumnModel());
        TableColumnModel statisticsColumnModel = this.tblStatistics.getColumnModel();
        statisticsColumnModel.setColumnSelectionAllowed(false);
        for (int i = 0; i < statisticsModel.getColumnCount(); ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setIdentifier(statisticsModel.getColumnName(i));
            tableColumn.setHeaderValue(statisticsModel.getColumnName(i));
            if (i > 1) {
                tableColumn.setCellRenderer(new PerhapsNotValidValueCellRenderer());
            }
            statisticsColumnModel.addColumn(tableColumn);
        }
    }

    private void updateHistogramGraphic() {
        if (this.statistics == null) {
            this.getGraphicContainer().getPGraphic().cleanChart();
            return;
        }
        List selectedBands = ((SelectableBandsTableModel)this.tblBands.getModel()).getSelectedBands();
        Color[] bandsColor = new Color[selectedBands.size()];
        String[] bandNames = new String[selectedBands.size()];
        int index = 0;
        for (Integer selectedBand : selectedBands) {
            bandsColor[index] = this.colors == null || this.colors.length != this.tblBands.getModel().getRowCount() ? defaultColors[index % defaultColors.length] : this.colors[selectedBand];
            bandNames[index] = selectedBand.toString();
            this.getGraphicContainer().setBandColor(index, bandsColor[index]);
            ++index;
        }
        this.getGraphicContainer().getPGraphic().setViewType(this.cmbType.getSelectedIndex());
        HistogramBand[] histogramBands = this.statistics.getHistogram();
        XYSeries[] datos = new XYSeries[selectedBands.size()];
        for (int iBand = 0; iBand < selectedBands.size(); ++iBand) {
            int first = (int)this.getGraphicContainer().getX1();
            int end = (int)this.getGraphicContainer().getX2();
            HistogramBand histogramBand = histogramBands[(Integer)selectedBands.get(iBand)];
            int min = 0;
            int max = histogramBand.getNumClasses() - 1;
            first = min + first * (max - min) / 100;
            end = min + end * (max - min) / 100;
            if (this.chkRemoveTails.isSelected()) {
                if (first + 1 <= end) {
                    ++first;
                }
                if (end - 1 >= first) {
                    --end;
                }
            }
            datos[iBand] = new XYSeries((Comparable)((Object)bandNames[iBand]));
            for (int i = first; i < end; ++i) {
                datos[iBand].add(histogramBand.getIntervalMin(i), (double)histogramBand.getValueCount(i));
            }
        }
        this.getGraphicContainer().getPGraphic().setNewChart(datos);
    }

    public void setEnabledVisibleStatistics(boolean enabledVisibleStatistics) {
        this.enabledVisibleStatistics = enabledVisibleStatistics;
        if (this.initialized) {
            this.updateComponents();
        }
    }

    public boolean isEnabledVisibleStatistics() {
        return this.enabledVisibleStatistics;
    }

    public void addChangeItemSourceListener(ItemListener listener) {
        if (this.initialized) {
            this.cmbSource.addItemListener(listener);
        }
    }

    public void removeChangeItemSourceListener(ItemListener listener) {
        if (this.initialized) {
            this.cmbSource.addItemListener(listener);
        }
    }
}

