/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.remoteclient.RemoteClient;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.WFSProtocolHandler;
import org.gvsig.remoteclient.wfs.WFSProtocolHandlerFactory;
import org.gvsig.remoteclient.wfs.WFSRequestInformation;
import org.gvsig.remoteclient.wfs.WFSServiceInformation;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSClient
extends RemoteClient {
    private static Logger logger = LoggerFactory.getLogger(WFSClient.class);
    public static final int DEFAULT_MAXFEATURES = 10000;
    private WFSProtocolHandler handler;

    public WFSClient(String host, boolean ignoreCache) throws ConnectException, IOException {
        this.setHost(host);
        this.handler = WFSProtocolHandlerFactory.negotiate(host, ignoreCache);
        this.handler.setHost(host);
    }

    public WFSClient(String host, String version, boolean ignoreCache) throws IOException {
        this.setHost(host);
        if (version == null) {
            try {
                this.handler = WFSProtocolHandlerFactory.negotiate(host, ignoreCache);
            }
            catch (ConnectException conE) {
                logger.warn("Can'r negotiate version for the host '" + host + "'.", (Throwable)conE);
                throw conE;
            }
            catch (IOException ioE) {
                logger.warn("Can'r negotiate version for the host '" + host + "'.", (Throwable)ioE);
                throw ioE;
            }
            catch (Exception e) {
                logger.warn("Can'r negotiate version for the host '" + host + "'.", (Throwable)e);
            }
        } else {
            this.handler = WFSProtocolHandlerFactory.createVersionDriver(version);
        }
        if (this.handler == null) {
            logger.warn("Unsupported version '" + version + "' for host '" + host + "'.");
            throw new UnsupportedOperationException("Unsupported version");
        }
        this.handler.setHost(host);
    }

    public void getCapabilities(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        this.handler.getCapabilities(status, override, cancel);
    }

    public File describeFeatureType(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        return this.handler.describeFeatureType(status, override, cancel);
    }

    public File getFeature(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        String namespacePrefix;
        if (status.getNamespaceLocation() != null && status.getNamespacePrefix() == null && (namespacePrefix = this.getServiceInformation().getNamespacePrefix(status.getNamespaceLocation())) != null) {
            status.setNamespacePrefix(namespacePrefix);
        }
        return this.handler.getFeature(status, override, cancel);
    }

    public void transaction(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        this.handler.transaction(status, override, cancel);
    }

    public void lockFeature(WFSStatus status, boolean override, ICancellable cancel) throws WFSException {
        this.handler.lockFeature(status, override, cancel);
    }

    public boolean connect(boolean override, ICancellable cancel) {
        try {
            if (this.handler == null) {
                if (this.getHost().trim().length() > 0) {
                    this.handler = WFSProtocolHandlerFactory.negotiate(this.getHost(), override);
                    this.handler.setHost(this.getHost());
                } else {
                    return false;
                }
            }
            this.getCapabilities(null, override, cancel);
            return true;
        }
        catch (Exception e) {
            logger.warn("Can't connect to host '" + this.hostName + "'.", (Throwable)e);
            return false;
        }
    }

    public boolean connect(ICancellable cancel) {
        return this.connect(false, cancel);
    }

    public void close() {
    }

    public String getVersion() {
        return this.handler.getVersion();
    }

    public WFSServiceInformation getServiceInformation() {
        return (WFSServiceInformation)this.handler.getServiceInformation();
    }

    public Hashtable getFeatures() {
        return this.handler.getFeatures();
    }

    public WFSFeature getFeature(String nameSpace, String localName) {
        Iterator it = this.handler.getFeatures().keySet().iterator();
        String fullName = localName;
        String prefix = this.getServiceInformation().getNamespacePrefix(nameSpace);
        if (prefix != null) {
            fullName = prefix + ":" + localName;
        }
        while (it.hasNext()) {
            Object[] s;
            String featureName = (String)it.next();
            if (StringUtils.equals((CharSequence)localName, (CharSequence)featureName)) {
                return (WFSFeature)this.handler.getFeatures().get(featureName);
            }
            if (StringUtils.equals((CharSequence)fullName, (CharSequence)featureName)) {
                return (WFSFeature)this.handler.getFeatures().get(featureName);
            }
            if (!StringUtils.isBlank((CharSequence)prefix) || !StringUtils.contains((CharSequence)featureName, (int)58) || !ArrayUtils.isNotEmpty((Object[])(s = StringUtils.split((String)featureName, (char)':'))) || !StringUtils.equals((CharSequence)s[s.length - 1], (CharSequence)localName)) continue;
            return (WFSFeature)this.handler.getFeatures().get(featureName);
        }
        return null;
    }

    public String findNameSpace(String localName) {
        Object[] s;
        if (StringUtils.isBlank((CharSequence)localName)) {
            return null;
        }
        if (StringUtils.contains((CharSequence)localName, (int)58) && ArrayUtils.isNotEmpty((Object[])(s = StringUtils.split((String)localName, (char)':'))) && s.length > 1) {
            return s[0];
        }
        for (String featureName : this.handler.getFeatures().keySet()) {
            Object[] s2;
            if (!StringUtils.contains((CharSequence)featureName, (int)58) || !ArrayUtils.isNotEmpty((Object[])(s2 = StringUtils.split((String)featureName, (char)':'))) || !StringUtils.equals((CharSequence)s2[s2.length - 1], (CharSequence)localName)) continue;
            return s2[0];
        }
        return null;
    }

    public WFSRequestInformation getLastWfsRequestInformation() {
        return this.handler.getLastWfsRequestInformation();
    }

    public int getWFSRequestInformationCount() {
        return this.handler.getWfsRequestInformations().size();
    }

    public WFSRequestInformation getWFSRequestInformationAt(int index) {
        ArrayList wfsRequestInformations = this.handler.getWfsRequestInformations();
        if (index < wfsRequestInformations.size()) {
            return (WFSRequestInformation)wfsRequestInformations.get(index);
        }
        return null;
    }
}

