/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.wfs.gui.panels.AbstractWFSPanel;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;

public class WFSOptionsPanel
extends AbstractWFSPanel {
    private static final long serialVersionUID = -769956995699452173L;
    public static final int DEFAULT_TIMEOUT_MILLISECONDS = 20000;
    public static final int DEFAULT_MAXFEATURES = 10000;
    private JPanel credentialsPanel = null;
    private JLabel usernameLabel = null;
    private JTextField usernameText = null;
    private JLabel passwordLabel = null;
    private JPasswordField passwordText = null;
    private JPanel connectionParamsPanel = null;
    private JLabel timeoutLabel = null;
    private JSpinner maxFeaturesSpinner = null;
    private JLabel bufferLabel = null;
    private JComboBox timeoutCombo = null;
    private JPanel formatPanel = null;
    private JLabel srsLabel = null;
    private JLabel verLabel = null;
    private JComboBox ver_Combo = null;
    private JPanel versionPanel = null;
    private JComboBox srsCombo = null;
    private JPanel bufferPanel = null;
    private JPanel timeOutPanel = null;
    private JPanel northPanel = null;
    private JPanel axisOrderPanel;
    private JCheckBox axisOrderYXCheckBox;
    private JButton btnSrsToView;

    public WFSOptionsPanel() {
        this.initialize();
    }

    private JTextField getUsernameText() {
        if (this.usernameText == null) {
            this.usernameText = new JTextField();
            this.usernameText.setBounds(new Rectangle(100, 25, 200, 20));
            this.usernameText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    AbstractPanelGroup panelGroup = WFSOptionsPanel.this.getPanelGroup();
                    if (panelGroup == null) {
                        return;
                    }
                    ((WFSParamsPanel)panelGroup).setApplicable(true);
                }
            });
        }
        return this.usernameText;
    }

    private JPasswordField getPasswordText() {
        if (this.passwordText == null) {
            this.passwordText = new JPasswordField();
            this.passwordText.setBounds(new Rectangle(100, 50, 200, 20));
            this.passwordText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    AbstractPanelGroup panelGroup = WFSOptionsPanel.this.getPanelGroup();
                    if (panelGroup == null) {
                        return;
                    }
                    ((WFSParamsPanel)panelGroup).setApplicable(true);
                }
            });
        }
        return this.passwordText;
    }

    private JPanel getConnectionParamsPanel() {
        if (this.connectionParamsPanel == null) {
            this.bufferPanel = new JPanel();
            this.bufferLabel = new JLabel();
            this.bufferLabel.setText(PluginServices.getText(null, (String)"_max_features"));
            this.bufferLabel.setPreferredSize(new Dimension(190, 20));
            this.bufferPanel.setLayout(new FlowLayout(0));
            this.bufferPanel.add(this.bufferLabel);
            this.bufferPanel.add(this.getMaxFeatSpinner());
            this.timeOutPanel = new JPanel();
            this.timeoutLabel = new JLabel();
            this.timeoutLabel.setText(PluginServices.getText(null, (String)"_timeout"));
            this.timeoutLabel.setPreferredSize(new Dimension(190, 20));
            this.timeOutPanel.setLayout(new FlowLayout(0));
            this.timeOutPanel.add(this.timeoutLabel);
            this.timeOutPanel.add(this.getTimeoutCombo());
            this.connectionParamsPanel = new JPanel();
            this.connectionParamsPanel.setLayout(new GridBagLayout());
            this.connectionParamsPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"conection"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.connectionParamsPanel.add((Component)this.bufferPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.connectionParamsPanel.add((Component)this.timeOutPanel, gridBagConstraints);
        }
        return this.connectionParamsPanel;
    }

    private JSpinner getMaxFeatSpinner() {
        if (this.maxFeaturesSpinner == null) {
            SpinnerNumberModel model = new SpinnerNumberModel(10000, 1, 1000000, 1);
            this.maxFeaturesSpinner = new JSpinner(model);
        }
        return this.maxFeaturesSpinner;
    }

    private JComboBox getTimeoutCombo() {
        if (this.timeoutCombo == null) {
            this.timeoutCombo = new JComboBox();
            this.timeoutCombo.setEditable(false);
            this.timeoutCombo.addItem("5 sec");
            this.timeoutCombo.addItem("20 sec");
            this.timeoutCombo.addItem("2 min");
            this.timeoutCombo.addItem("10 min");
            this.timeoutCombo.setToolTipText(PluginServices.getText((Object)this.timeoutCombo, (String)"set_TimeOut_Explanation"));
        }
        return this.timeoutCombo;
    }

    public String getUserName() {
        return this.getUsernameText().getText();
    }

    public void setUserName(String userName) {
        this.getUsernameText().setText(userName);
    }

    public String getPassword() {
        return this.getPasswordText().getText();
    }

    public void setPassword(String password) {
        this.getPasswordText().setText(password);
    }

    public int getBuffer() {
        try {
            Object val = this.getMaxFeatSpinner().getValue();
            return Integer.parseInt(val.toString());
        }
        catch (Exception e) {
            return 10000;
        }
    }

    public void setBuffer(int buffer) {
        try {
            this.getMaxFeatSpinner().setValue(buffer);
        }
        catch (Exception exc) {
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"_Unable_to_show_max_featcount"), Messages.getText((String)"error"), 0);
        }
    }

    public int getTimeout() {
        String tou = this.getTimeoutCombo().getSelectedItem().toString();
        return this.toMilliseconds(tou);
    }

    public void setTimeOut(int timeOut) {
        int cnt = this.getTimeoutCombo().getItemCount();
        for (int i = 0; i < cnt; ++i) {
            String aux = this.getTimeoutCombo().getItemAt(i).toString();
            if (timeOut != this.toMilliseconds(aux)) continue;
            this.getTimeoutCombo().setSelectedIndex(i);
            return;
        }
        this.getTimeoutCombo().setSelectedIndex(1);
    }

    private int toMilliseconds(String txt) {
        try {
            String[] tt = txt.split(" ");
            int aux = Integer.parseInt(tt[0]);
            if (tt[1].compareToIgnoreCase("min") == 0) {
                aux *= 60;
            }
            return aux * 1000;
        }
        catch (Exception ex) {
            logger.info("Did not parse item. Timeout = 20000");
            return 20000;
        }
    }

    public String getSRS() {
        Object sel = this.getSrsCombo().getSelectedItem();
        if (sel == null) {
            return "";
        }
        return sel.toString();
    }

    public boolean getUseAxisOrderYX() {
        return this.axisOrderYXCheckBox.isSelected();
    }

    public void setSRS(String srs) {
        this.getSrsCombo().setSelectedItem(srs);
        this.refreshAxisOrder();
    }

    public void setVersion(String str_ver) {
        this.getVersionCombo().setSelectedItem(str_ver);
    }

    private JPanel getFormatPanel() {
        if (this.formatPanel == null) {
            this.formatPanel = new JPanel();
            this.formatPanel.setLayout(new FlowLayout(0));
            this.formatPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"srs"), 0, 0, null, null));
            this.formatPanel.add(this.getSRSLabel());
            this.formatPanel.add(this.getSrsCombo());
            this.formatPanel.add(this.getBtnSrsToView());
        }
        return this.formatPanel;
    }

    private JLabel getSRSLabel() {
        if (this.srsLabel == null) {
            this.srsLabel = new JLabel();
            this.srsLabel.setHorizontalTextPosition(10);
            this.srsLabel.setText(PluginServices.getText((Object)this, (String)"srs"));
            this.srsLabel.setPreferredSize(new Dimension(190, 20));
        }
        return this.srsLabel;
    }

    private JLabel getVersionLabel() {
        if (this.verLabel == null) {
            this.verLabel = new JLabel();
            this.verLabel.setHorizontalTextPosition(10);
            this.verLabel.setText(PluginServices.getText((Object)this, (String)"_Version"));
            this.verLabel.setPreferredSize(new Dimension(190, 20));
        }
        return this.verLabel;
    }

    private JComboBox getSrsCombo() {
        if (this.srsCombo == null) {
            this.srsCombo = new JComboBox();
            this.srsCombo.setEnabled(true);
            this.srsCombo.setEditable(false);
            this.srsCombo.setToolTipText(PluginServices.getText((Object)this.srsCombo, (String)"select_Feature_Reference_System"));
        }
        return this.srsCombo;
    }

    private JComboBox getVersionCombo() {
        if (this.ver_Combo == null) {
            this.ver_Combo = new JComboBox();
            this.ver_Combo.setEnabled(true);
            this.ver_Combo.setEditable(false);
            this.ver_Combo.addActionListener(ae -> this.refreshAxisOrder());
        }
        return this.ver_Combo;
    }

    @Override
    public void refresh(WFSSelectedFeature layer) {
        Vector srs = layer.getSrs();
        Iterator iter = srs.iterator();
        JComboBox bx = this.getSrsCombo();
        bx.removeAllItems();
        while (iter.hasNext()) {
            bx.addItem(iter.next());
        }
        this.refreshAxisOrder();
    }

    private void refreshAxisOrder() {
        try {
            String version = this.getVersion();
            if (version != null && version.compareToIgnoreCase("1.1.0") >= 0) {
                IProjection proj;
                String srs = this.getSRS();
                if (!StringUtils.isBlank((CharSequence)srs) && (proj = CRSFactory.getCRS((String)srs)) != null && !proj.isProjected()) {
                    this.axisOrderYXCheckBox.setSelected(true);
                }
            } else {
                this.axisOrderYXCheckBox.setSelected(false);
            }
        }
        catch (Exception ex) {
            logger.warn("Can't set axis order automatically", (Throwable)ex);
        }
    }

    public void refreshVersions(List vers) {
        Iterator iter = vers.iterator();
        JComboBox bx = this.getVersionCombo();
        bx.removeAllItems();
        while (iter.hasNext()) {
            bx.addItem(iter.next());
        }
        this.refreshAxisOrder();
    }

    private JPanel getAxisOrderPanel() {
        if (this.axisOrderPanel == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.axisOrderPanel = new JPanel();
            this.axisOrderPanel.setLayout(new FlowLayout(0));
            this.axisOrderPanel.setBorder(BorderFactory.createTitledBorder(null, i18nManager.getTranslation("_Axis_order"), 0, 0, null, null));
            this.axisOrderPanel.add(this.getAxisOrderYXCheckBox());
        }
        return this.axisOrderPanel;
    }

    public JCheckBox getAxisOrderYXCheckBox() {
        if (this.axisOrderYXCheckBox == null) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            this.axisOrderYXCheckBox = new JCheckBox();
            this.axisOrderYXCheckBox.setText(i18nManager.getTranslation("_Use_axis_order_YX"));
            this.axisOrderYXCheckBox.setBounds(new Rectangle(175, 50, 40, 16));
        }
        return this.axisOrderYXCheckBox;
    }

    @Override
    protected void initialize() {
        this.setLabel(PluginServices.getText((Object)this, (String)"options"));
        this.setLabelGroup(PluginServices.getText((Object)this, (String)"wfs"));
        this.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add(this.getVersionPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.getConnectionParamsPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.getFormatPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.getAxisOrderPanel(), gridBagConstraints);
        this.add(this.northPanel, "North");
    }

    private Component getVersionPanel() {
        if (this.versionPanel == null) {
            this.versionPanel = new JPanel();
            this.versionPanel.setLayout(new FlowLayout(0));
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.versionPanel.setBorder(BorderFactory.createTitledBorder(null, i18n.getTranslation("_WFS_protocol_version"), 0, 0, null, null));
            this.versionPanel.add(this.getVersionLabel());
            this.versionPanel.add(this.getVersionCombo());
        }
        return this.versionPanel;
    }

    public static String getAxisOrderPreferredCrs(List crs_list) {
        if (crs_list == null || crs_list.isEmpty()) {
            return "";
        }
        if (crs_list.size() == 1) {
            return crs_list.get(0).toString();
        }
        for (int i = 0; i < crs_list.size(); ++i) {
            IProjection ipro;
            String item = crs_list.get(i).toString();
            try {
                ipro = CRSFactory.getCRS((String)item);
            }
            catch (Exception ex) {
                ipro = null;
            }
            if (ipro == null || !ipro.isProjected()) continue;
            return item;
        }
        return crs_list.get(0).toString();
    }

    public String getVersion() {
        if (this.ver_Combo != null && this.ver_Combo.getSelectedItem() != null) {
            String v = this.ver_Combo.getSelectedItem().toString();
            return v;
        }
        return "-";
    }

    private JButton getBtnSrsToView() {
        if (this.btnSrsToView == null) {
            Image icon = IconThemeHelper.getImage((String)"addlayer-crstoview");
            this.btnSrsToView = new JButton();
            this.btnSrsToView.setIcon(new ImageIcon(icon));
            this.btnSrsToView.setEnabled(false);
            IWindow wi = PluginServices.getMDIManager().getActiveWindow();
            if (wi instanceof IView) {
                MapContext mapContext = ((IView)wi).getMapControl().getMapContext();
                this.btnSrsToView.setEnabled(!mapContext.hasLayers());
                this.btnSrsToView.addActionListener(e -> {
                    IProjection proj;
                    String srs;
                    if (!mapContext.hasLayers() && StringUtils.isNotBlank((CharSequence)(srs = this.getSRS())) && (proj = CRSFactory.getCRS((String)this.getSRS())) != null) {
                        mapContext.setProjection(proj);
                    }
                });
            }
        }
        return this.btnSrsToView;
    }
}

