/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.controls.MultiLineToolTip;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.remoteclient.wfs.WFSFeatureField;
import org.gvsig.wfs.gui.panels.AbstractWFSPanel;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.panels.fieldstree.FieldsTreeTable;
import org.gvsig.wfs.gui.panels.fieldstree.FieldsTreeTableModel;
import org.gvsig.wfs.gui.panels.fieldstree.TreeTableModelWithCheckBoxes;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;

public class WFSSelectFieldsPanel
extends AbstractWFSPanel {
    private static final long serialVersionUID = -1596729857889892588L;
    private JScrollPaneML fieldsScroll = null;
    private FieldsTreeTable fieldsTreeTable = null;
    private FieldsTreeTableModel model = null;
    private JPanel treeTablePanel = null;
    private boolean fieldsSelectedOfSameLayerHasChanged;
    private String namespace = null;

    public String getNamespace() {
        return this.namespace;
    }

    public WFSSelectFieldsPanel() {
        this.initialize();
    }

    private JScrollPane getFieldsScroll() {
        if (this.fieldsScroll == null) {
            this.fieldsScroll = new JScrollPaneML();
            this.fieldsScroll.setViewportView((Component)((Object)this.getFieldsTreeTable()));
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent((JComponent)this.fieldsScroll);
            this.fieldsScroll.setToolTipText(PluginServices.getText((Object)this.fieldsScroll, (String)"fields_Selection_Info"));
        }
        return this.fieldsScroll;
    }

    public FieldsTreeTable getFieldsTreeTable() {
        if (this.fieldsTreeTable == null) {
            this.model = new TreeTableModelWithCheckBoxes();
            this.fieldsTreeTable = new FieldsTreeTable(this.model, this);
            this.fieldsTreeTable.setToolTipText(PluginServices.getText((Object)((Object)this.fieldsTreeTable), (String)"fields_Selection_Info"));
            this.fieldsTreeTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().compareTo("tableCellEditor") == 0) {
                        WFSSelectFieldsPanel.this.fieldsSelectedOfSameLayerHasChanged = true;
                    } else if (evt.getPropertyName().compareTo("selectionModel") == 0) {
                        WFSSelectFieldsPanel.this.fieldsSelectedOfSameLayerHasChanged = false;
                    }
                }
            });
        }
        return this.fieldsTreeTable;
    }

    @Override
    public void refresh(WFSSelectedFeature feature) {
        this.setFields(feature);
    }

    private void setFields(WFSSelectedFeature selectedFeature) {
        WFSFeature feature = selectedFeature.getWFSFeature();
        this.model = new TreeTableModelWithCheckBoxes(feature);
        this.getFieldsTreeTable().setModel(this.model);
        if (feature.getNamespace() != null) {
            this.namespace = feature.getNamespace().getLocation();
        }
    }

    public void setSelectedFields(String selectedFields) {
        String[] fields = selectedFields.split(",");
        ArrayList<String> listFields = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            listFields.add(fields[i]);
        }
        this.getFieldsTreeTable().setSelectedFields(listFields);
    }

    public String getGeometryFieldName() {
        return this.getFieldsTreeTable().getGeometryField();
    }

    public WFSFeatureField[] getSelectedFields() {
        return this.fieldsTreeTable.getSelectedElements();
    }

    public String getSelectedFieldsAsString() {
        StringBuffer output = new StringBuffer();
        WFSFeatureField[] selectedFields = this.getSelectedFields();
        for (int i = 0; i < selectedFields.length - 1; ++i) {
            output.append(selectedFields[i].getName() + ",");
        }
        if (selectedFields.length > 0) {
            output.append(selectedFields[selectedFields.length - 1].getName());
        }
        return output.toString();
    }

    private JPanel getTreeTablePanel() {
        if (this.treeTablePanel == null) {
            this.treeTablePanel = new JPanel();
            this.treeTablePanel.setLayout(new GridBagLayout());
            this.treeTablePanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"select_fields"), 0, 0, null, null));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.treeTablePanel.add((Component)this.getFieldsScroll(), gridBagConstraints);
        }
        return this.treeTablePanel;
    }

    public boolean getFieldsSelectedOfSameLayerHasChanged() {
        return this.fieldsSelectedOfSameLayerHasChanged;
    }

    public void setApplicable(boolean applicable) {
        AbstractPanelGroup panelGroup = this.getPanelGroup();
        if (panelGroup == null) {
            return;
        }
        ((WFSParamsPanel)panelGroup).setApplicable(applicable);
    }

    public void resetFieldsSelectedOfSameLayerHasChanged() {
        this.fieldsSelectedOfSameLayerHasChanged = false;
    }

    @Override
    protected void initialize() {
        this.setLabel(PluginServices.getText((Object)this, (String)"fields_uppercase_first"));
        this.setLabelGroup(PluginServices.getText((Object)this, (String)"wfs"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.getTreeTablePanel(), gridBagConstraints);
        this.fieldsSelectedOfSameLayerHasChanged = false;
    }

    private class JScrollPaneML
    extends JScrollPane {
        private static final long serialVersionUID = -5589382813201358787L;

        public JScrollPaneML() {
        }

        public JScrollPaneML(Component view, int vsbPolicy, int hsbPolicy) {
            super(view, vsbPolicy, hsbPolicy);
        }

        public JScrollPaneML(Component view) {
            super(view);
        }

        public JScrollPaneML(int vsbPolicy, int hsbPolicy) {
            super(vsbPolicy, hsbPolicy);
        }

        @Override
        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent((JComponent)this);
            return tip;
        }
    }
}

