/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.fieldstree;

import java.util.Vector;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.swing.treeTable.AbstractTreeTableModel;
import org.gvsig.gui.beans.swing.treeTable.TreeTableModel;
import org.gvsig.remoteclient.wfs.WFSFeatureField;

public class FieldsTreeTableModel
extends AbstractTreeTableModel {
    private boolean showGeometry;
    private String[] cNames = new String[]{PluginServices.getText((Object)((Object)this), (String)"attributeName"), PluginServices.getText((Object)((Object)this), (String)"attributeType")};
    private Class[] cTypes = new Class[]{TreeTableModel.class, String.class};

    public FieldsTreeTableModel(Object root) {
        super(root);
        this.showGeometry = true;
    }

    public FieldsTreeTableModel(Object root, boolean show_Geometry) {
        super(root);
        this.showGeometry = show_Geometry;
    }

    public FieldsTreeTableModel() {
        super(null);
        this.showGeometry = true;
    }

    public boolean getShowGeometry() {
        return this.showGeometry;
    }

    public int getChildCount(Object node) {
        WFSFeatureField featureField = (WFSFeatureField)node;
        if (featureField.isComplex()) {
            return featureField.getFieldSize();
        }
        return 0;
    }

    public Object getChild(Object node, int i) {
        WFSFeatureField element = (WFSFeatureField)node;
        if (element.isComplex()) {
            WFSFeatureField child = null;
            int k = -1;
            if (!this.showGeometry) {
                for (int j = 0; j < element.getFieldSize(); ++j) {
                    child = element.getFieldAt(j);
                    if (!child.isGeometry()) {
                        ++k;
                    }
                    if (i == k) break;
                }
            }
            return child;
        }
        return null;
    }

    public boolean isLeaf(Object node) {
        if (node == null) {
            return true;
        }
        WFSFeatureField featureField = (WFSFeatureField)node;
        return !featureField.isComplex();
    }

    public int getColumnCount() {
        return this.cNames.length;
    }

    public String getColumnName(int column) {
        return this.cNames[column];
    }

    public Class getColumnClass(int column) {
        return this.cTypes[column];
    }

    public Object getValueAt(Object node, int column) {
        WFSFeatureField element = (WFSFeatureField)node;
        if (element == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return element.getName();
                }
                case 1: {
                    if (element.getDataType() == null) {
                        return "";
                    }
                    if (element.isGeometry()) {
                        return PluginServices.getText((Object)((Object)this), (String)element.getType());
                    }
                    return PluginServices.getText((Object)((Object)this), (String)element.getDataType().getName());
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public Vector<Object> getLeafsFromNodeBranch(Object node) {
        Vector<Object> leafs = new Vector<Object>();
        WFSFeatureField parent = (WFSFeatureField)node;
        if (this.isLeaf(node)) {
            leafs.add(parent.getName());
        } else {
            for (int i = 0; i < parent.getFieldSize(); ++i) {
                WFSFeatureField child = parent.getFieldAt(i);
                if (this.isLeaf(child) && !leafs.contains(node)) {
                    leafs.add(child);
                    continue;
                }
                leafs.addAll(this.getLeafsFromNodeBranch(child));
            }
        }
        return leafs;
    }
}

