/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels.fieldstree;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;

public class TetraStateCheckBox
extends JCheckBox {
    public static final int WHITE = 0;
    public static final int GREY = 1;
    private final TetraStateDecorator model = new TetraStateDecorator(this.getModel());

    public TetraStateCheckBox(String text, Icon icon, int color) {
        super(text, icon);
        this.setModel(this.model);
    }

    public TetraStateCheckBox(String text) {
        this(text, null, 0);
    }

    public TetraStateCheckBox() {
        this(null, null, 0);
    }

    public void setColor(int color) {
        this.model.setColor(color, this.isSelected());
    }

    public int getColor() {
        return this.model.getColor();
    }

    private class TetraStateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TetraStateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setColor(int color, boolean isSelected) {
            if (color == 0) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(isSelected);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(isSelected);
            }
        }

        private int getColor() {
            if (!this.isArmed()) {
                return 1;
            }
            return 0;
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setEnabled(boolean b) {
            TetraStateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        @Override
        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

