/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.toc;

import java.awt.BorderLayout;
import java.awt.Component;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.panelGroup.loaders.PanelGroupLoaderFromExtensionPoint;
import org.gvsig.app.project.documents.view.legend.gui.AbstractThemeManagerPage;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorer;
import org.gvsig.fmap.dal.store.wfs.WFSStoreProvider;
import org.gvsig.fmap.mapcontext.exceptions.CreateLayerException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.gui.beans.panelGroup.PanelGroupManager;
import org.gvsig.gui.beans.panelGroup.loaders.IPanelGroupLoader;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeatureManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSProperties
extends AbstractThemeManagerPage {
    private static final long serialVersionUID = -3666226507540534256L;
    private static final Logger LOG = LoggerFactory.getLogger(WFSProperties.class);
    private WFSParamsPanel panel = null;
    private FLyrVect layer = null;
    private final String wfs_properties_extensionpoint_name = "WFSPropertiesDialog";

    public WFSProperties() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
    }

    public void acceptAction() {
        this.applyAction();
    }

    public void applyAction() {
        if (this.panel != null) {
            try {
                ILegend legend = this.layer.getLegend();
                FLyrVect newLayer = (FLyrVect)this.panel.createLayer();
                newLayer.setIsLabeled(this.layer.isLabeled());
                newLayer.setLabelingStrategy(this.layer.getLabelingStrategy());
                if (newLayer != null) {
                    this.layer.getMapContext().getLayers().replaceLayer((FLayer)this.layer, (FLayer)newLayer);
                    this.layer = newLayer;
                    this.layer.setLegend((IVectorLegend)legend);
                }
            }
            catch (LoadLayerException e) {
                LOG.error("Error loading the new layer", (Throwable)e);
            }
            catch (CreateLayerException e) {
                LOG.error("Error creating the new layer", (Throwable)e);
            }
        }
    }

    public void cancelAction() {
    }

    public String getName() {
        return PluginServices.getText((Object)((Object)this), (String)"WFS");
    }

    public boolean isTabEnabledForLayer(FLayer layer) {
        if (!(layer instanceof FLyrVect)) {
            return false;
        }
        if (!layer.isAvailable()) {
            return false;
        }
        FeatureStore store = ((FLyrVect)layer).getFeatureStore();
        return WFSStoreProvider.NAME.equalsIgnoreCase(store.getProviderName());
    }

    public void setModel(FLayer layer) {
        this.layer = (FLyrVect)layer;
        if (!layer.isAvailable()) {
            return;
        }
        PanelGroupManager manager = PanelGroupManager.getManager();
        manager.registerPanelGroup(WFSParamsPanel.class);
        manager.setDefaultType(WFSParamsPanel.class);
        try {
            if (!(this.layer.getDataStore().getExplorer() instanceof WFSServerExplorer)) {
                return;
            }
            boolean firstExecution = this.panel == null;
            WFSServerExplorer serverExplorer = (WFSServerExplorer)this.layer.getDataStore().getExplorer();
            WFSSelectedFeatureManager selectedFeatureManager = WFSSelectedFeatureManager.getInstance(serverExplorer);
            this.panel = (WFSParamsPanel)manager.getPanelGroup(null);
            this.panel.loadPanels((IPanelGroupLoader)new PanelGroupLoaderFromExtensionPoint("WFSPropertiesDialog"));
            this.panel.setServerExplorer(serverExplorer);
            this.panel.setVisible(true);
            if (firstExecution) {
                this.add((Component)((Object)this.panel), "Center");
            }
            this.panel.refreshCapabilitiesInfo();
            this.panel.setDataStore(((FLyrVect)layer).getDataStore());
        }
        catch (Exception e) {
            LOG.error("Error loading the layer", (Throwable)e);
        }
    }
}

