/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.TableSorter;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.persistence.RecentTrsPersistence;
import org.gvsig.crs.persistence.TrData;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationEpsgPanel
extends JPanel {
    public static final Logger logger = LoggerFactory.getLogger(TransformationEpsgPanel.class);
    private static final long serialVersionUID = 1L;
    private IProjection firstProj;
    String[] transformations = new String[]{"9603", "9606", "9607", "9613", "9615", "9633"};
    private int transformation_code = -1;
    private String[] values;
    private String params = "+towgs84=";
    private JTable transformationTable;
    private JScrollPane jScrollPane = null;
    public boolean inverseTranformation = false;
    public EpsgConnection connect = new EpsgConnection();
    public int crs_target = -1;
    public DefaultTableModel dtm = null;
    private int crs_source_code;
    private String cadWKT = "";
    private ListSelectionModel lsm2 = null;
    public int selectedRowTable = -1;
    boolean tra = false;
    int real_target;
    String authority_target = "";
    private JTextArea info;
    public TableSorter sorter = null;

    public TransformationEpsgPanel(String aut_target) {
        int target;
        this.connect.setConnectionEPSG();
        String[] authority_target = aut_target.split(":");
        this.setAuthorityTarget(authority_target[0]);
        this.real_target = target = Integer.parseInt(authority_target[1]);
        String sentence = "SELECT source_geogcrs_code, coord_ref_sys_kind FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + target;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        try {
            result.next();
            String kind = result.getString("coord_ref_sys_kind");
            if (kind.equals("projected")) {
                target = result.getInt("source_geogcrs_code");
            }
        }
        catch (SQLException e1) {
            logger.info("Can't get values from resulset, sentence=" + sentence + ".", (Throwable)e1);
        }
        this.crs_target = target;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(1, 50));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"EPSG_transformation")), BorderFactory.createEmptyBorder(12, 2, 80, 2)), this.getBorder()));
        this.add((Component)this.getJScrollPane(), "Center");
    }

    private Component getInfo() {
        if (this.info == null) {
            this.info = new JTextArea();
            this.info.setLineWrap(true);
            this.info.setWrapStyleWord(true);
            this.info.setPreferredSize(new Dimension(400, 240));
            this.info.setEditable(false);
            this.info.append(this.getWKT());
        }
        this.info.setText(this.getWKT());
        return this.info;
    }

    public JTable getJTable() {
        if (this.transformationTable == null) {
            Object[] columnNames = new String[]{PluginServices.getText((Object)this, (String)"code_transformation"), PluginServices.getText((Object)this, (String)"name_transformation"), PluginServices.getText((Object)this, (String)"type_transformation"), PluginServices.getText((Object)this, (String)"source_crs"), PluginServices.getText((Object)this, (String)"target_crs"), PluginServices.getText((Object)this, (String)"description_area")};
            Object[][] data = new Object[][]{};
            this.dtm = new DefaultTableModel(data, columnNames){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public Class getColumnClass(int column) {
                    return this.getValueAt(0, column).getClass();
                }
            };
            this.sorter = new TableSorter((TableModel)this.dtm);
            this.transformationTable = new JTable((TableModel)this.sorter);
            this.sorter.setTableHeader(this.transformationTable.getTableHeader());
            this.transformationTable.setCellSelectionEnabled(false);
            this.transformationTable.setRowSelectionAllowed(true);
            this.transformationTable.setAutoResizeMode(0);
            this.transformationTable.setColumnSelectionAllowed(false);
            this.transformationTable.setSelectionMode(0);
            TableColumn column = null;
            for (int i = 0; i < columnNames.length; ++i) {
                column = this.transformationTable.getColumnModel().getColumn(i);
                if (i == 0 || i == 3 || i == 4) {
                    column.setPreferredWidth(40);
                    continue;
                }
                if (i == 2) {
                    column.setPreferredWidth(80);
                    continue;
                }
                column.setPreferredWidth(160);
            }
        }
        return this.transformationTable;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(525, 200));
            this.jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"transformations")), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.jScrollPane.getBorder()));
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private void callTransformation(int _crsCode) {
        int crsCode = _crsCode;
        String sentence = "SELECT source_geogcrs_code, coord_ref_sys_kind FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + crsCode;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        int source = 0;
        try {
            result.next();
            String kind = result.getString("coord_ref_sys_kind");
            if (kind.equals("projected")) {
                source = result.getInt("source_geogcrs_code");
            } else if (kind.equals("geographic 2D")) {
                source = crsCode;
            } else {
                logger.info("Unable to determine the reverse EPSG code (kind=" + kind + ",crsCode=" + crsCode + ").");
            }
        }
        catch (SQLException e1) {
            logger.info("Can't get values from resulset, sentence=" + sentence + ".", (Throwable)e1);
        }
        ResultSet result2 = null;
        ResultSet result3 = null;
        if (source != 0) {
            crsCode = source;
        }
        ArrayList<String> codecs = new ArrayList<String>();
        codecs.add(String.valueOf(crsCode));
        for (int j = 0; j < codecs.size(); ++j) {
            sentence = "SELECT coord_op_code, coord_op_name, coord_op_type, source_crs_code, target_crs_code, area_of_use_code, coord_op_method_code FROM epsg_coordoperation WHERE source_crs_code = " + codecs.get(j) + " AND target_crs_code = " + this.crs_target;
            result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            try {
                while (result.next()) {
                    Object[] data = new Object[6];
                    data[0] = String.valueOf(result.getInt("coord_op_code"));
                    data[1] = result.getString("coord_op_name");
                    data[2] = result.getString("coord_op_type");
                    data[3] = String.valueOf(result.getInt("source_crs_code"));
                    data[4] = String.valueOf(result.getInt("target_crs_code"));
                    int aouc = Integer.parseInt(result.getString("area_of_use_code"));
                    sentence = "SELECT area_of_use FROM epsg_area WHERE area_code = " + aouc;
                    result2 = Query.select((String)sentence, (Connection)this.connect.getConnection());
                    while (result2.next()) {
                        data[5] = result2.getString("area_of_use");
                    }
                    String coord_op_method = result.getString("coord_op_method_code");
                    sentence = "SELECT reverse_op FROM epsg_coordoperationmethod WHERE coord_op_method_code LIKE " + coord_op_method;
                    result3 = Query.select((String)sentence, (Connection)this.connect.getConnection());
                    while (result3.next()) {
                        if (result3.getInt("reverse_op") != 1) continue;
                        for (int i = 0; i < this.transformations.length; ++i) {
                            if (!coord_op_method.equals(this.transformations[i])) continue;
                            this.dtm.addRow(data);
                        }
                    }
                }
                continue;
            }
            catch (SQLException e1) {
                logger.info("Can't get values from resulset.", (Throwable)e1);
            }
        }
    }

    private ArrayList deleteItems(ArrayList codecs) {
        ArrayList<String> cod = new ArrayList<String>();
        boolean equal = false;
        for (int i = 0; i < codecs.size(); ++i) {
            String c = (String)codecs.get(i);
            for (int j = 0; j < cod.size(); ++j) {
                if (!cod.get(j).equals(c)) continue;
                equal = true;
            }
            if (!equal) {
                cod.add(c);
            }
            equal = false;
        }
        return cod;
    }

    private void callInverseTransformation(int _crsCode) {
        int crsCode = _crsCode;
        String sentence = "SELECT source_geogcrs_code, coord_ref_sys_kind FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + crsCode;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        int source = 0;
        try {
            result.next();
            String kind = result.getString("coord_ref_sys_kind");
            if (kind.equals("projected")) {
                source = result.getInt("source_geogcrs_code");
            } else if (kind.equals("geographic 2D")) {
                source = crsCode;
            } else {
                logger.info("Unable to determine the reverse EPSG code (kind=" + kind + ",crsCode=" + crsCode + ").");
            }
        }
        catch (SQLException e1) {
            logger.info("Can't get value 'source_geogcrs_code' from resulset, sentence=" + sentence + ".", (Throwable)e1);
        }
        ResultSet result2 = null;
        ResultSet result3 = null;
        if (source != 0) {
            crsCode = source;
        }
        ArrayList codecs = new ArrayList();
        codecs.add(String.valueOf(crsCode));
        codecs = this.deleteItems(codecs);
        for (int j = 0; j < codecs.size(); ++j) {
            sentence = "SELECT coord_op_code, coord_op_name, coord_op_type, source_crs_code, target_crs_code, area_of_use_code, coord_op_method_code FROM epsg_coordoperation WHERE source_crs_code = " + codecs.get(j) + " AND target_crs_code = " + this.crs_target;
            result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            try {
                while (result.next()) {
                    Object[] data = new Object[6];
                    data[0] = String.valueOf(result.getInt("coord_op_code"));
                    data[1] = result.getString("coord_op_name");
                    data[2] = result.getString("coord_op_type");
                    data[4] = String.valueOf(result.getInt("source_crs_code"));
                    data[3] = String.valueOf(result.getInt("target_crs_code"));
                    int aouc = Integer.parseInt(result.getString("area_of_use_code"));
                    sentence = "SELECT area_of_use FROM epsg_area WHERE area_code = " + aouc;
                    result2 = Query.select((String)sentence, (Connection)this.connect.getConnection());
                    while (result2.next()) {
                        data[5] = result2.getString("area_of_use");
                    }
                    String coord_op_method = result.getString("coord_op_method_code");
                    sentence = "SELECT reverse_op FROM epsg_coordoperationmethod WHERE coord_op_method_code LIKE " + coord_op_method;
                    result3 = Query.select((String)sentence, (Connection)this.connect.getConnection());
                    while (result3.next()) {
                        if (Integer.parseInt(result3.getString("reverse_op")) != 1) continue;
                        for (int i = 0; i < this.transformations.length; ++i) {
                            if (!coord_op_method.equals(this.transformations[i])) continue;
                            this.dtm.addRow(data);
                        }
                    }
                }
                continue;
            }
            catch (SQLException e1) {
                logger.info("Can't get values from resulset.", (Throwable)e1);
            }
        }
    }

    public void setValues(String[] val) {
        this.values = val;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setTrasformation_code(int t_cod) {
        this.transformation_code = t_cod;
    }

    public int getTransformation_code() {
        return this.transformation_code;
    }

    public ICrs getProjection() {
        this.params = this.params + this.values[0];
        for (int i = 1; i < this.values.length; ++i) {
            this.params = this.params + "," + this.values[i];
        }
        try {
            ICrs crs = new CrsFactory().getCRS("EPSG:" + this.crs_source_code, this.params, null);
            return crs;
        }
        catch (CrsException e) {
            logger.info("Can't create EPSG CRS with code " + this.crs_source_code + " and transformation params '" + this.params + "'.", (Throwable)e);
            return null;
        }
    }

    public void setProjection(IProjection proj) {
        this.firstProj = proj;
    }

    public void setWKT(String cad) {
        this.cadWKT = cad;
        this.getInfo();
    }

    public String getWKT() {
        return this.cadWKT;
    }

    public void setSource(String fuente, int code) {
        this.connect = new EpsgConnection();
        this.connect.setConnectionEPSG();
        this.inverseTranformation = false;
        this.crs_source_code = code;
        int numRow = this.dtm.getRowCount();
        while (numRow != 0) {
            this.dtm.removeRow(--numRow);
        }
        if (PluginServices.getText((Object)this, (String)fuente).equals(PluginServices.getText((Object)this, (String)"EPSG")) && PluginServices.getText((Object)this, (String)this.getAuthorityTarget()).equals(PluginServices.getText((Object)this, (String)"EPSG"))) {
            this.searchTransformationsForEpsgSource(code);
        }
    }

    private void searchTransformationsForEpsgSource(int src_code) {
        this.callTransformation(this.crs_source_code);
        int new_target = this.crs_target;
        int base_target = src_code;
        String sentence = "SELECT source_geogcrs_code, coord_ref_sys_kind FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + src_code;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        try {
            result.next();
            String kind = result.getString("coord_ref_sys_kind");
            if (kind.equals("projected")) {
                base_target = result.getInt("source_geogcrs_code");
            }
        }
        catch (SQLException e1) {
            logger.info("Can't get values 'coord_ref_sys_kind/source_geogcrs_code' from resulset, sentence=" + sentence + ".", (Throwable)e1);
        }
        this.crs_target = base_target;
        this.crs_source_code = new_target;
        this.callInverseTransformation(this.crs_source_code);
        this.crs_target = new_target;
        this.crs_source_code = src_code;
        int numr = this.dtm.getRowCount();
        if (numr > 0) {
            this.getJTable().setRowSelectionInterval(0, 0);
        }
    }

    public void setSourceCompuesta(String aut) {
        int code;
        this.connect = new EpsgConnection();
        this.connect.setConnectionEPSG();
        this.inverseTranformation = false;
        String[] authority = aut.split(":");
        this.crs_source_code = code = Integer.parseInt(authority[1]);
        int numRow = this.dtm.getRowCount();
        while (numRow != 0) {
            this.dtm.removeRow(--numRow);
        }
        if (PluginServices.getText((Object)this, (String)authority[0]).equals(PluginServices.getText((Object)this, (String)"EPSG"))) {
            this.callTransformationCompuesta(this.crs_source_code);
            int new_target = this.crs_target;
            int base_target = code;
            String sentence = "SELECT source_geogcrs_code, coord_ref_sys_kind FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + code;
            ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            try {
                result.next();
                String kind = result.getString("coord_ref_sys_kind");
                if (kind.equals("projected")) {
                    base_target = result.getInt("source_geogcrs_code");
                }
            }
            catch (SQLException e1) {
                logger.info("Can't get values 'coord_ref_sys_kind/source_geogcrs_code' from resulset, sentence=" + sentence + ".", (Throwable)e1);
            }
            this.crs_target = base_target;
            this.crs_source_code = new_target;
            this.callInverseTransformation(this.crs_source_code);
            this.crs_target = new_target;
            this.crs_source_code = code;
            int numr = this.dtm.getRowCount();
            if (numr > 0) {
                this.getJTable().setRowSelectionInterval(0, 0);
            }
        }
    }

    private void callTransformationCompuesta(int crsCode) {
        int numRow = this.dtm.getRowCount();
        while (numRow != 0) {
            this.dtm.removeRow(--numRow);
        }
        String sentence = "SELECT source_geogcrs_code FROM epsg_coordinatereferencesystem WHERE coord_ref_sys_code = " + crsCode;
        ResultSet result = Query.select((String)sentence, (Connection)this.connect.getConnection());
        int source = 0;
        try {
            result.next();
            source = result.getInt("source_geogcrs_code");
        }
        catch (SQLException e1) {
            logger.info("Can't get value 'source_geogcrs_code' from resulset, sentence=" + sentence + ".", (Throwable)e1);
        }
        ResultSet result2 = null;
        ResultSet result3 = null;
        if (source != 0) {
            crsCode = source;
        }
        ArrayList<String> codecs = new ArrayList<String>();
        codecs.add(String.valueOf(crsCode));
        for (int j = 0; j < codecs.size(); ++j) {
            sentence = "SELECT coord_op_code, coord_op_name, coord_op_type, source_crs_code, target_crs_code, area_of_use_code, coord_op_method_code FROM epsg_coordoperation WHERE source_crs_code = " + codecs.get(j) + " OR target_crs_code = " + codecs.get(j);
            result = Query.select((String)sentence, (Connection)this.connect.getConnection());
            try {
                while (result.next()) {
                    Object[] data = new Object[6];
                    data[0] = String.valueOf(result.getInt("coord_op_code"));
                    data[1] = result.getString("coord_op_name");
                    data[2] = result.getString("coord_op_type");
                    data[3] = String.valueOf(result.getInt("source_crs_code"));
                    data[4] = String.valueOf(result.getInt("target_crs_code"));
                    int aouc = Integer.parseInt(result.getString("area_of_use_code"));
                    sentence = "SELECT area_of_use FROM epsg_area WHERE area_code = " + aouc;
                    result2 = Query.select((String)sentence, (Connection)this.connect.getConnection());
                    while (result2.next()) {
                        data[5] = result2.getString("area_of_use");
                    }
                    String coord_op_method = result.getString("coord_op_method_code");
                    sentence = "SELECT reverse_op FROM epsg_coordoperationmethod WHERE coord_op_method_code LIKE " + coord_op_method;
                    result3 = Query.select((String)sentence, (Connection)this.connect.getConnection());
                    while (result3.next()) {
                        if (result3.getInt("reverse_op") != 1) continue;
                        for (int i = 0; i < this.transformations.length; ++i) {
                            if (!coord_op_method.equals(this.transformations[i])) continue;
                            this.dtm.addRow(data);
                        }
                    }
                }
                continue;
            }
            catch (SQLException e1) {
                logger.info("Can't get values resulset.", (Throwable)e1);
            }
        }
    }

    public int getSource() {
        return this.crs_source_code;
    }

    public int getTarget() {
        return this.real_target;
    }

    public void setAuthorityTarget(String aut_target) {
        this.authority_target = aut_target;
    }

    public String getAuthorityTarget() {
        return this.authority_target;
    }

    public void fillData(String details) {
        RecentTrsPersistence trPersistence = new RecentTrsPersistence();
        TrData[] crsTrDataArray = trPersistence.getArrayOfTrData();
        block0: for (int iRow = crsTrDataArray.length - 1; iRow >= 0; --iRow) {
            if (!details.equals(crsTrDataArray[iRow].getAuthority() + ":" + crsTrDataArray[iRow].getCode() + " <--> " + crsTrDataArray[iRow].getDetails()) || !crsTrDataArray[iRow].getAuthority().equals(PluginServices.getText((Object)this, (String)"EPSG"))) continue;
            String code = String.valueOf(crsTrDataArray[iRow].getCode());
            for (int i = 0; i < this.getJTable().getRowCount(); ++i) {
                if (!code.equals((String)this.getJTable().getValueAt(i, 0))) continue;
                this.getJTable().setRowSelectionInterval(i, i);
                break block0;
            }
            break;
        }
    }

    public void resetData() {
        if (this.dtm.getRowCount() > 0) {
            this.getJTable().setRowSelectionInterval(0, 0);
        }
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(ToolsLocator.getI18nManager().getTranslation("EPSG_transformation"));
        return m_viewinfo;
    }
}

