/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.gui.panels;

import au.com.objectix.jgridshift.GridShiftFile;
import au.com.objectix.jgridshift.SubGrid;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.crs.CrsWkt;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.JCrsExtension;
import org.gvsig.crs.gui.panels.FiltroNadgrids;
import org.gvsig.crs.gui.panels.TreePanel;
import org.gvsig.crs.persistence.RecentTrsPersistence;
import org.gvsig.crs.persistence.TrData;
import org.gvsig.utils.XMLEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationNadgridsPanel
extends JPanel
implements IWindow,
ActionListener {
    public static final Logger logger = LoggerFactory.getLogger(TransformationNadgridsPanel.class);
    private static final long serialVersionUID = 1L;
    private JPanel groupRadioButton = null;
    private JLabel jLabelChooser = null;
    private JRadioButton jRadioButtonSource = null;
    private JRadioButton jRadioButtonTarget = null;
    private IProjection firstProj;
    private String nadFile = null;
    String[] targetAuthority;
    String targetAbrev = "";
    String sourceAbrev = "";
    private String cadWKT = "";
    private File dataPath = null;
    private int codeEpsg;
    private JPanel jPanelOpen;
    private JPanel jPanelSelectNad;
    private JLabel jLabelOpenGsb;
    private JFileChooser openFileChooser;
    private JButton jButtonOpen;
    private TreePanel treePanel = null;
    private JComboBox jComboNadFile = null;
    private JLabel jLabelSelectNad = null;
    private JTextArea jTextAreaInfo;
    private PluginServices ps = PluginsLocator.getManager().getPlugin(JCrsExtension.class);
    private XMLEntity xml = null;
    boolean targetNad = false;
    boolean setRadioButtons = false;

    public TransformationNadgridsPanel(boolean optional) {
        this.dataPath = CrsFactory.getProjLibFolder();
        this.xml = this.ps.getPersistentXML();
        this.setRadioButtons = optional;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("+ " + PluginServices.getText((Object)this, (String)"nadgrids")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel pNorth = new JPanel();
        pNorth.setBorder(new EmptyBorder(1, 10, 1, 10));
        pNorth.setLayout(new GridLayout(4, 1));
        pNorth.add(this.getJPanelOpen());
        pNorth.add(this.getJPanelSelectNad());
        JPanel lbl = new JPanel(new FlowLayout(0, 0, 10));
        lbl.add(this.getJLabelChooser());
        if (this.setRadioButtons) {
            pNorth.add(lbl);
            pNorth.add(this.getGroupRadioButton());
        }
        this.add((Component)pNorth, "North");
        this.add((Component)this.getTreePanel(), "Center");
    }

    private JPanel getGroupRadioButton() {
        if (this.groupRadioButton == null) {
            this.groupRadioButton = new JPanel();
            this.groupRadioButton.setLayout(new GridLayout(1, 0));
            this.groupRadioButton.add(this.getJRadioButtonSource());
            this.groupRadioButton.add(this.getJRadioButtonTarget());
        }
        return this.groupRadioButton;
    }

    private JRadioButton getJRadioButtonSource() {
        if (this.jRadioButtonSource == null) {
            this.jRadioButtonSource = new JRadioButton();
            this.jRadioButtonSource.setSelected(true);
            this.jRadioButtonSource.addActionListener(this);
        }
        this.jRadioButtonSource.setText(PluginServices.getText((Object)this, (String)"aplicar_capa") + " " + "(" + this.getSourceAbrev() + ")");
        return this.jRadioButtonSource;
    }

    private JRadioButton getJRadioButtonTarget() {
        if (this.jRadioButtonTarget == null) {
            this.jRadioButtonTarget = new JRadioButton();
            this.jRadioButtonTarget.setSelected(false);
            this.jRadioButtonTarget.addActionListener(this);
        }
        this.jRadioButtonTarget.setText(PluginServices.getText((Object)this, (String)"aplicar_vista") + " " + "(" + this.getTargetAbrev() + ")");
        return this.jRadioButtonTarget;
    }

    private JLabel getJLabelChooser() {
        this.jLabelChooser = new JLabel();
        this.jLabelChooser.setText(PluginServices.getText((Object)this, (String)"seleccion_nadgrids") + ":");
        return this.jLabelChooser;
    }

    private JPanel getJPanelOpen() {
        if (this.jPanelOpen == null) {
            this.jPanelOpen = new JPanel();
            this.jPanelOpen.setLayout(new FlowLayout(0, 5, 5));
            this.jPanelOpen.add((Component)this.getJLabelOpenGsb(), null);
            this.jPanelOpen.add((Component)this.getJButtonOpen(), null);
        }
        return this.jPanelOpen;
    }

    private JLabel getJLabelOpenGsb() {
        if (this.jLabelOpenGsb == null) {
            this.jLabelOpenGsb = new JLabel();
            this.jLabelOpenGsb.setPreferredSize(new Dimension(130, 20));
            this.jLabelOpenGsb.setText(PluginServices.getText((Object)this, (String)"importarRejilla"));
        }
        return this.jLabelOpenGsb;
    }

    private JFileChooser getOpenFileChooser() {
        if (this.openFileChooser == null) {
            this.openFileChooser = new JFileChooser();
            this.openFileChooser.setEnabled(false);
            this.openFileChooser.addChoosableFileFilter(new FiltroNadgrids());
        }
        return this.openFileChooser;
    }

    private JButton getJButtonOpen() {
        if (this.jButtonOpen == null) {
            this.jButtonOpen = new JButton();
            this.jButtonOpen.setText("");
            this.jButtonOpen.setPreferredSize(new Dimension(20, 20));
            this.jButtonOpen.setText("...");
            this.jButtonOpen.addActionListener(this);
        }
        return this.jButtonOpen;
    }

    public ICrs getProjection() {
        String params = "+nadgrids=" + this.getNadFile();
        if (this.jRadioButtonSource.isSelected()) {
            try {
                this.setNad(false);
                ICrs crs = new CrsFactory().getCRS(this.getSourceAbrev(), params, null);
                return crs;
            }
            catch (CrsException e) {
                logger.info("Can't create CRS with '" + this.getSourceAbrev() + "' and transformation source params '" + params + "'.", (Throwable)e);
                return null;
            }
        }
        this.setNad(true);
        try {
            ICrs crs = new CrsFactory().getCRS(this.getSourceAbrev(), null, params);
            return crs;
        }
        catch (CrsException e) {
            logger.info("Can't create CRS with '" + this.getSourceAbrev() + "' and transformation target params '" + params + "'.", (Throwable)e);
            return null;
        }
    }

    public void setProjection(IProjection proj) {
        this.firstProj = proj;
    }

    public void setNad(boolean nadg) {
        this.targetNad = nadg;
    }

    public boolean getNad() {
        return this.targetNad;
    }

    public void setCode(int cod) {
        this.codeEpsg = cod;
    }

    public int getCode() {
        return this.codeEpsg;
    }

    public void setWKT(String cad) {
        this.cadWKT = cad;
        CrsWkt parser = new CrsWkt(cad);
    }

    public String getWKT() {
        return this.cadWKT;
    }

    public void setTargetAuthority(String[] authority) {
        this.targetAuthority = authority;
        this.setTargetAbrev(this.targetAuthority[0], this.targetAuthority[1]);
        this.getJRadioButtonTarget();
    }

    public String[] getTargetAuthority() {
        return this.targetAuthority;
    }

    public void setTargetAbrev(String fuente, String codigo) {
        this.targetAbrev = fuente + ":" + codigo;
    }

    public String getTargetAbrev() {
        return this.targetAbrev;
    }

    public void setSourceAbrev(String fuente, String codigo) {
        this.sourceAbrev = fuente + ":" + codigo;
        this.getJRadioButtonSource();
    }

    public String getSourceAbrev() {
        return this.sourceAbrev;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(8);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"nadgrids"));
        return m_viewinfo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getJRadioButtonSource()) {
            this.jRadioButtonSource.setSelected(true);
            this.jRadioButtonTarget.setSelected(false);
        }
        if (e.getSource() == this.getJRadioButtonTarget()) {
            this.jRadioButtonTarget.setSelected(true);
            this.jRadioButtonSource.setSelected(false);
        }
        if (e.getSource() == this.getJButtonOpen()) {
            this.jPanelOpen.add((Component)this.getOpenFileChooser(), null);
            int returnVal = this.openFileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File inFile = this.openFileChooser.getSelectedFile();
                String fileName = inFile.getName();
                RandomAccessFile raFile = null;
                try {
                    raFile = new RandomAccessFile(inFile.getAbsolutePath(), "r");
                }
                catch (FileNotFoundException ex) {
                    logger.info("Can't open nad file '" + inFile.getAbsolutePath() + "' for read.", (Throwable)ex);
                    this.getJComboNadFile().setSelectedIndex(0);
                    this.getTreePanel().setRoot(PluginServices.getText((Object)this, (String)"nadfile_not_found"));
                    this.setNadFile(null);
                    return;
                }
                GridShiftFile gsf = new GridShiftFile();
                try {
                    gsf.loadGridShiftFile(raFile);
                }
                catch (IOException ex) {
                    logger.info("Can't load nad file '" + inFile.getAbsolutePath() + "'.", (Throwable)ex);
                    this.getJComboNadFile().setSelectedIndex(0);
                    this.getTreePanel().setRoot(PluginServices.getText((Object)this, (String)"nadfile_bad_format"));
                    this.setNadFile(null);
                    return;
                }
                catch (Exception ex) {
                    logger.info("Can't load nad file '" + inFile.getAbsolutePath() + "'.", (Throwable)ex);
                    this.getJComboNadFile().setSelectedIndex(0);
                    this.getTreePanel().setRoot(PluginServices.getText((Object)this, (String)"nadfile_bad_format"));
                    this.setNadFile(null);
                    return;
                }
                File outFile = new File(this.dataPath, fileName);
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(inFile);
                    out = new FileOutputStream(outFile);
                }
                catch (FileNotFoundException ex) {
                    logger.info("Can't copy nad file from '" + inFile.getAbsolutePath() + "' to '" + outFile.getAbsolutePath() + "'.", (Throwable)ex);
                }
                byte[] buf = new byte[1024];
                try {
                    int len;
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    logger.info("Can't copy nad file from '" + inFile.getAbsolutePath() + "' to '" + outFile.getAbsolutePath() + "'.", (Throwable)ex);
                }
                boolean exists = false;
                for (int item = 0; item < this.getJComboNadFile().getItemCount() && !exists; ++item) {
                    if (!this.getJComboNadFile().getItemAt(item).equals(fileName)) continue;
                    exists = true;
                }
                if (!exists) {
                    this.getJComboNadFile().addItem(fileName);
                }
                this.getJComboNadFile().setSelectedItem(fileName);
                this.setNadFile(fileName);
            }
        }
    }

    public TreePanel getTreePanel() {
        if (this.treePanel == null) {
            this.treePanel = new TreePanel(PluginServices.getText((Object)this, (String)"grids_en") + ": " + this.nadFile);
            this.treePanel.getTree().expandRow(0);
            this.treePanel.setPanelSize(530, 150);
        }
        return this.treePanel;
    }

    public void initializeTree() {
        RandomAccessFile raFile = null;
        File lNadFile = null;
        try {
            lNadFile = new File(this.dataPath, this.nadFile);
            raFile = new RandomAccessFile(lNadFile, "r");
        }
        catch (FileNotFoundException e) {
            logger.info("Can't open nad file '" + lNadFile.getAbsolutePath() + "' for read.", (Throwable)e);
            this.getTreePanel().setRoot(PluginServices.getText((Object)this, (String)"nadfile_not_found"));
            this.setNadFile(null);
            return;
        }
        GridShiftFile gsf = new GridShiftFile();
        try {
            gsf.loadGridShiftFile(raFile);
        }
        catch (IOException e) {
            logger.info("Can't load nad file '" + lNadFile.getAbsolutePath() + "'.", (Throwable)e);
            this.getTreePanel().setRoot(PluginServices.getText((Object)this, (String)"nadfile_bad_format"));
            this.setNadFile(null);
            return;
        }
        catch (Exception e) {
            logger.info("Can't load nad file '" + lNadFile.getAbsolutePath() + "'.", (Throwable)e);
            this.getTreePanel().setRoot(PluginServices.getText((Object)this, (String)"nadfile_bad_format"));
            this.setNadFile(null);
            return;
        }
        SubGrid[] subGrid = gsf.getSubGridTree();
        for (int i = 0; i < subGrid.length; ++i) {
            this.getTreePanel().addClass(subGrid[i].getSubGridName(), i);
            this.getTreePanel().addEntry(PluginServices.getText((Object)this, (String)"long_min") + ": " + String.valueOf(subGrid[i].getMaxLon() / -3600.0) + "", subGrid[i].getSubGridName(), "");
            this.getTreePanel().addEntry(PluginServices.getText((Object)this, (String)"lat_min") + ": " + String.valueOf(subGrid[i].getMinLat() / 3600.0) + "?", subGrid[i].getSubGridName(), "");
            this.getTreePanel().addEntry(PluginServices.getText((Object)this, (String)"long_max") + ": " + String.valueOf(subGrid[i].getMinLon() / -3600.0 + "?"), subGrid[i].getSubGridName(), "");
            this.getTreePanel().addEntry(PluginServices.getText((Object)this, (String)"lat_max") + ": " + String.valueOf(subGrid[i].getMaxLat() / 3600.0 + ""), subGrid[i].getSubGridName(), "");
            this.getTreePanel().addEntry(PluginServices.getText((Object)this, (String)"node_count") + ": " + String.valueOf(subGrid[i].getNodeCount()), subGrid[i].getSubGridName(), "");
            this.getTreePanel().addEntry(PluginServices.getText((Object)this, (String)"detalles") + ": " + String.valueOf(subGrid[i].getDetails()), subGrid[i].getSubGridName(), "");
        }
        this.getTreePanel().getTree().expandRow(0);
        this.getTreePanel().getList().setText(PluginServices.getText((Object)this, (String)"advertencia_nad"));
    }

    public JComboBox getJComboNadFile() {
        if (this.jComboNadFile == null) {
            this.jComboNadFile = new JComboBox();
            this.jComboNadFile.setPreferredSize(new Dimension(200, 25));
            this.jComboNadFile.setEditable(false);
            this.jComboNadFile.addItem(PluginServices.getText((Object)this, (String)"seleccionar") + "...");
            String[] dataDir = this.dataPath.list();
            for (int i = 0; i < dataDir.length; ++i) {
                if (!dataDir[i].toLowerCase().endsWith(".gsb")) continue;
                this.jComboNadFile.addItem(dataDir[i]);
            }
            if (this.getNadFile() != null) {
                this.jComboNadFile.setSelectedItem(this.getNadFile());
            }
        }
        return this.jComboNadFile;
    }

    public JLabel getJLabelSelectNad() {
        if (this.jLabelSelectNad == null) {
            this.jLabelSelectNad = new JLabel(PluginServices.getText((Object)this, (String)"seleccionarRejilla") + ":  ");
            this.jLabelSelectNad.setPreferredSize(new Dimension(130, 25));
        }
        return this.jLabelSelectNad;
    }

    public JPanel getJPanelSelectNad() {
        if (this.jPanelSelectNad == null) {
            this.jPanelSelectNad = new JPanel();
            this.jPanelSelectNad.setLayout(new FlowLayout(0, 5, 5));
            this.jPanelSelectNad.add(this.getJLabelSelectNad());
            this.jPanelSelectNad.add(this.getJComboNadFile());
        }
        return this.jPanelSelectNad;
    }

    public void setNadFile(String nad) {
        this.nadFile = nad;
    }

    public String getNadFile() {
        return this.nadFile;
    }

    public void saveNadFileName(String name) {
        this.ps = PluginsLocator.getManager().getPlugin(JCrsExtension.class);
        this.xml = this.ps.getPersistentXML();
        for (int child = 0; child < this.xml.getChildrenCount(); ++child) {
            if (!this.xml.getChild(child).getPropertyName(0).equals("nadFile")) continue;
            this.xml.removeChild(child);
        }
        XMLEntity xmlEnt = new XMLEntity();
        xmlEnt.putProperty("nadFile", name);
        this.xml.addChild(xmlEnt);
        this.ps.setPersistentXML(this.xml);
    }

    private String restoreNadFileName() {
        for (int child = 0; child < this.xml.getChildrenCount(); ++child) {
            if (!this.xml.getChild(child).getPropertyName(0).equals("nadFile")) continue;
            String fileName = this.xml.getChild(child).getPropertyValue(0);
            String[] dataDir = this.dataPath.list();
            for (int i = 0; i < dataDir.length; ++i) {
                if (!dataDir[i].equals(fileName)) continue;
                return fileName;
            }
        }
        return null;
    }

    public void fillData(String details) {
        RecentTrsPersistence trPersistence = new RecentTrsPersistence();
        TrData[] crsTrDataArray = trPersistence.getArrayOfTrData();
        for (int iRow = crsTrDataArray.length - 1; iRow >= 0; --iRow) {
            if (!details.equals(crsTrDataArray[iRow].getAuthority() + ":" + crsTrDataArray[iRow].getCode() + " <--> " + crsTrDataArray[iRow].getDetails()) || !crsTrDataArray[iRow].getAuthority().equals(PluginServices.getText((Object)this, (String)"NADGR"))) continue;
            String[] data = crsTrDataArray[iRow].getDetails().split(" ");
            String fichero = data[0];
            String authority = data[1].substring(1, data[1].length() - 1);
            for (int i = 0; i < this.getJComboNadFile().getItemCount(); ++i) {
                if (!fichero.equals((String)this.getJComboNadFile().getItemAt(i))) continue;
                this.getJComboNadFile().setSelectedIndex(i);
                break;
            }
            if (authority.equals(this.getSourceAbrev())) {
                this.getJRadioButtonSource().setSelected(true);
                this.getJRadioButtonTarget().setSelected(false);
                break;
            }
            this.getJRadioButtonSource().setSelected(false);
            this.getJRadioButtonTarget().setSelected(true);
            break;
        }
    }

    public void resetData() {
        this.getJRadioButtonSource().setSelected(true);
        this.getJRadioButtonTarget().setSelected(false);
        this.getJComboNadFile().setSelectedIndex(0);
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

