/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.ogr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cresques.cts.IProjection;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Geometry;
import org.gdal.ogr.Layer;
import org.gdal.ogr.ogr;
import org.gdal.osr.SpatialReference;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureProviderIterator;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.gdal.prov.ogr.OGRConverter;
import org.gvsig.gdal.prov.ogr.OGRDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRDataStoreProvider;
import org.gvsig.gdal.prov.ogr.OGRUnsupportedFormatException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OGRFetureSetProvider
extends AbstractFeatureSetProvider
implements FeatureSetProvider,
ResourceConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OGRFetureSetProvider.class);
    private static final String regularExpresion = "\\s*ST_intersects[(]\\s*ST_GeomFromText[(]\\s*'([^']*)'\\s*,\\s*'([^']*)'\\s*[)],\\s*(?s).*";

    public OGRFetureSetProvider(AbstractFeatureStoreProvider store, FeatureQuery query, FeatureType featureType) {
        super(store, query, featureType);
        this.getStore().getResource().addConsumer((ResourceConsumer)this);
    }

    public boolean canFilter() {
        return false;
    }

    public boolean canOrder() {
        return true;
    }

    public boolean canIterateFromIndex() {
        return true;
    }

    public long getSize() throws DataException {
        return this.getStore().getFeatureCount();
    }

    public boolean isEmpty() throws DataException {
        return this.getSize() == 0L;
    }

    protected AbstractFeatureProviderIterator createIterator(long index) throws DataException {
        return this.createFastIterator(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractFeatureProviderIterator createFastIterator(long index) throws DataException {
        String sql = this.getOGRStoreProvider().compoundSelect(this.getFeatureType(), this.getQuery().getFilter(), this.getQuery().getOrder());
        DataSource dataSource = this.getOGRDataSource();
        LOG.debug("Running query {} over {}", new Object[]{sql, dataSource.getName()});
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            Layer layer = null;
            boolean ignoreSpatialFilter = (Boolean)this.getStore().getParameters().getDynValue("ignoreSpatialFilter");
            if (!ignoreSpatialFilter && this.getOGRStoreProvider().getLayer().TestCapability("FastSpatialFilter") && this.getQuery().hasFilter()) {
                String evaluatorSQL = this.getQuery().getFilter().getSQL();
                Pattern pattern = Pattern.compile(regularExpresion);
                Matcher matcher = pattern.matcher(evaluatorSQL);
                if (matcher.matches()) {
                    IProjection projectionProvider;
                    String wktGeometry = matcher.group(1);
                    String crsCode = matcher.group(2);
                    IProjection projection = CRSFactory.getCRS((String)crsCode);
                    SpatialReference srs = new SpatialReference(projection.export("wkt"));
                    Geometry ogrGeometry = ogr.CreateGeometryFromWkt((String)wktGeometry, (SpatialReference)srs);
                    if (this.getOGRStoreProvider().getDynValue("CRS") != null && !crsCode.equals((projectionProvider = (IProjection)this.getOGRStoreProvider().getDynValue("CRS")).getAbrev())) {
                        SpatialReference srsDst = new SpatialReference(projectionProvider.export("wkt"));
                        ogrGeometry.TransformTo(srsDst);
                    }
                    layer = dataSource.ExecuteSQL(sql, ogrGeometry);
                }
            } else {
                layer = dataSource.ExecuteSQL(sql);
            }
            if (layer == null) {
                LOG.warn("The result of query is null. SQL {} FeatureType {}", (Object)sql, (Object)this.getFeatureType());
                LOG.warn("Getting data without SQL filter");
                OGRDataStoreParameters ogrParameters = (OGRDataStoreParameters)this.getOGRStoreProvider().getParameters();
                layer = dataSource.ExecuteSQL("SELECT * FROM ".concat(ogrParameters.getLayerName()));
            }
            return new OGRFastIterator((FeatureStoreProvider)this.getStore(), layer, index);
        }
    }

    protected void doDispose() throws BaseException {
        this.getStore().getResource().removeConsumer((ResourceConsumer)this);
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public void resourceChanged(ResourceProvider resource) {
    }

    private OGRDataStoreProvider getOGRStoreProvider() {
        return (OGRDataStoreProvider)this.getStore();
    }

    private DataSource getOGRDataSource() {
        try {
            return ((OGRDataStoreProvider)this.getStore()).getDataSource();
        }
        catch (OGRUnsupportedFormatException ex) {
            throw new RuntimeException("Can't get data source", (Throwable)((Object)ex));
        }
    }

    class OGRFastIterator
    extends AbstractFeatureProviderIterator
    implements ResourceConsumer {
        private long index;
        private Layer layer;
        private OGRConverter converter;
        private FeatureProvider featureProvider;
        private Feature currentOgrFeature;
        private Feature nextOgrFeature;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OGRFastIterator(FeatureStoreProvider storeProvider, Layer layer, long index) throws OGRUnsupportedFormatException {
            DataSource dataSource;
            super(storeProvider);
            ToolsLocator.getDisposableManager().bind((Disposable)storeProvider);
            this.getResource().addConsumer((ResourceConsumer)this);
            DataSource dataSource2 = dataSource = OGRFetureSetProvider.this.getOGRDataSource();
            synchronized (dataSource2) {
                this.converter = new OGRConverter();
                this.index = index;
                this.layer = layer;
                this.layer.GetFeatureCount();
                this.layer.ResetReading();
                if (index != 0L) {
                    this.layer.SetNextByIndex((int)index);
                }
                this.currentOgrFeature = null;
                this.nextOgrFeature = this.layer.GetNextFeature();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            if (this.currentOgrFeature != null) {
                DataSource dataSource;
                DataSource dataSource2 = dataSource = OGRFetureSetProvider.this.getOGRDataSource();
                synchronized (dataSource2) {
                    this.layer.DeleteFeature(this.currentOgrFeature.GetFID());
                    this.currentOgrFeature = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object internalNext() {
            DataSource dataSource;
            DataSource dataSource2 = dataSource = OGRFetureSetProvider.this.getOGRDataSource();
            synchronized (dataSource2) {
                this.currentOgrFeature = this.nextOgrFeature;
                this.featureProvider = null;
                this.featureProvider = this.converter.convert(this.featureProvider, OGRFetureSetProvider.this.getFeatureType(), this.nextOgrFeature);
                this.nextOgrFeature = this.layer.GetNextFeature();
                return this.featureProvider;
            }
        }

        protected boolean internalHasNext() {
            return this.nextOgrFeature != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doDispose() throws BaseException {
            DataSource dataSource;
            DataSource dataSource2 = dataSource = OGRFetureSetProvider.this.getOGRDataSource();
            synchronized (dataSource2) {
                ToolsLocator.getDisposableManager().release((Disposable)OGRFetureSetProvider.this.getStore());
                dataSource.ReleaseResultSet(this.layer);
                this.getResource().removeConsumer((ResourceConsumer)this);
                this.converter = null;
                this.featureProvider = null;
                this.layer = null;
            }
        }

        public boolean closeResourceRequested(ResourceProvider resource) {
            this.featureProvider = null;
            return true;
        }

        public void resourceChanged(ResourceProvider resource) {
            throw new ConcurrentDataModificationException(OGRFetureSetProvider.this.getOGRStoreProvider().getName());
        }
    }
}

