/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gdal.prov.ogr;

import org.gdal.ogr.ogr;
import org.gvsig.fmap.dal.DALFileLibrary;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.resource.spi.ResourceManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.gdal.prov.ogr.BasicOGRDataStoreProviderFactory;
import org.gvsig.gdal.prov.ogr.OGRDataExplorer;
import org.gvsig.gdal.prov.ogr.OGRDataExplorerParameters;
import org.gvsig.gdal.prov.ogr.OGRDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRDataStoreProvider;
import org.gvsig.gdal.prov.ogr.OGRFilesystemServerProvider;
import org.gvsig.gdal.prov.ogr.OGRNewDataStoreParameters;
import org.gvsig.gdal.prov.ogr.OGRResource;
import org.gvsig.gdal.prov.ogr.OGRResourceParameters;
import org.gvsig.metadata.MetadataLibrary;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class OGRLibrary
extends AbstractLibrary {
    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(DALFileLibrary.class);
        this.require(MetadataLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
        ogr.RegisterAll();
    }

    protected void doPostInitialize() throws LibraryException {
        ResourceManagerProviderServices resman;
        FileHelper.registerParametersDefinition((String)"OGRDataStoreParameters", OGRDataStoreParameters.class, (String)"OGRDataStoreParameters.xml");
        FileHelper.registerParametersDefinition((String)"OGRNewDataStoreParameters", OGRNewDataStoreParameters.class, (String)"OGRNewDataStoreParameters.xml");
        FileHelper.registerParametersDefinition((String)"OGRDataExplorerParameters", OGRDataExplorerParameters.class, (String)"OGRExplorerParameters.xml");
        try {
            FileHelper.registerMetadataDefinition((String)"OGRDataStoreProvider", OGRDataStoreProvider.class, (String)"OGRMetadata.xml");
        }
        catch (MetadataException e) {
            throw new LibraryException(((Object)((Object)this)).getClass(), (ListBaseException)e);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (!dataman.getStoreProviders().contains("OGRDataStoreProvider")) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new BasicOGRDataStoreProviderFactory("OGRDataStoreProvider", "OGR provider to open vectorial resources"));
        }
        if (!dataman.getExplorerProviders().contains("OGRDataExplorer")) {
            dataman.registerExplorerProvider("OGRDataExplorer", OGRDataExplorer.class, OGRDataExplorerParameters.class);
        }
        DALFileLocator.getFilesystemServerExplorerManager().registerProvider("OGRDataStoreProvider", "OGR provider to open vectorial resources", OGRFilesystemServerProvider.class);
        DynObjectManager dynMan = ToolsLocator.getDynObjectManager();
        DynClass dynClass = dynMan.get("OGRDataStoreProvider");
        if (dynClass == null) {
            dynClass = dynMan.add("OGRDataStoreProvider");
        }
        if (!(resman = (ResourceManagerProviderServices)DALLocator.getResourceManager()).getResourceProviders().contains("OGRResource")) {
            resman.register("OGRResource", "Any resource that can be opened by OGR", OGRResource.class, OGRResourceParameters.class);
        }
        OGRResourceParameters.registerPersistenceDefinition();
        this.fixDataParameters();
    }

    private void fixDataParameters() {
    }
}

