/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.legend.impl.colortable.editor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.swing.legend.colortable.editor.ColorTableClassesTableModel;
import org.gvsig.raster.swing.legend.colortable.editor.ColorTableEditorPanel;
import org.gvsig.raster.swing.legend.impl.colortable.editor.ColorChooserEditor;
import org.gvsig.raster.swing.legend.impl.colortable.editor.ColorTableEditorPanelView;
import org.gvsig.raster.swing.legend.impl.colortable.editor.DefaultColorTableClassesTableModel;
import org.gvsig.raster.swing.legend.impl.colortable.editor.PerhapsNotValidValueCellRenderer;
import org.gvsig.raster.swing.legend.impl.colortable.editor.PreviewerColorTableClassCellRenderer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorTableEditorPanelController
extends ColorTableEditorPanelView
implements ColorTableEditorPanel {
    private static final long serialVersionUID = -3073969545920834926L;
    private static final Logger LOG = LoggerFactory.getLogger(ColorTableEditorPanelController.class);
    private ColorTable colorTable;
    private boolean isModified = false;
    private ColorTableClassesTableModel tableModel;

    public ColorTableEditorPanelController() {
        this.translate();
        this.initializeComponents();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initializeComponents() {
        IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        this.btnAdd.setIcon(iconTheme.get("add-color-table-class-icon"));
        this.btnRemove.setIcon(iconTheme.get("remove-color-table-class-icon"));
        this.btnRemoveAll.setIcon(iconTheme.get("remove-all-color-table-class-icon"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditorPanelController.this.doAddColorTableClass();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditorPanelController.this.doRemoveColorTableClass();
            }
        });
        this.btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorTableEditorPanelController.this.doRemoveAllColorTableClasses();
            }
        });
        this.tblColorTableClasses.setRowSelectionAllowed(true);
        this.tblColorTableClasses.setColumnSelectionAllowed(true);
        this.tblColorTableClasses.setSelectionMode(0);
        this.tblColorTableClasses.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ColorTableEditorPanelController.this.updateComponents();
            }
        });
        this.chkInterpolated.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ColorTableEditorPanelController.this.colorTable != null) {
                    ColorTableEditorPanelController.this.colorTable.setInterpolated(ColorTableEditorPanelController.this.chkInterpolated.isSelected());
                }
                ColorTableEditorPanelController.this.isModified = true;
            }
        });
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){
            int countChanges = 0;

            @Override
            public void removeUpdate(DocumentEvent e) {
                ColorTableEditorPanelController.this.doChangedColorTableName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ColorTableEditorPanelController.this.doChangedColorTableName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ColorTableEditorPanelController.this.doChangedColorTableName();
            }
        });
        this.updateComponents();
    }

    protected void doChangedColorTableName() {
        if (this.colorTable != null) {
            this.colorTable.setName(this.txtName.getText());
            this.isModified = true;
        }
    }

    protected void doRemoveColorTableClass() {
        ((ColorTableClassesTableModel)this.tblColorTableClasses.getModel()).removeColorTableClass(this.tblColorTableClasses.getSelectedRow());
        this.isModified = true;
    }

    protected void doRemoveAllColorTableClasses() {
        ((ColorTableClassesTableModel)this.tblColorTableClasses.getModel()).removeAllColorTableClasses();
        this.isModified = true;
    }

    protected void doAddColorTableClass() {
        ColorTableClass newclass = RasterLegendLocator.getRasterLegendManager().createColorTableClass();
        ColorTableClassesTableModel colorTableClassesTableModel = (ColorTableClassesTableModel)this.tblColorTableClasses.getModel();
        newclass.setColor(new Color(0, 0, 0, 255));
        colorTableClassesTableModel.addColorTableClass(newclass);
        this.isModified = true;
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.btnAdd.setText(i18nManager.getTranslation(this.btnAdd.getText()));
        this.btnRemove.setText(i18nManager.getTranslation(this.btnRemove.getText()));
        this.btnRemoveAll.setText(i18nManager.getTranslation(this.btnRemoveAll.getText()));
        this.btnAdd.setToolTipText(i18nManager.getTranslation(this.btnAdd.getToolTipText()));
        this.btnRemove.setToolTipText(i18nManager.getTranslation(this.btnRemove.getToolTipText()));
        this.btnRemoveAll.setToolTipText(i18nManager.getTranslation(this.btnRemoveAll.getToolTipText()));
        this.chkInterpolated.setText(i18nManager.getTranslation(this.chkInterpolated.getText()));
        this.lblName.setText(i18nManager.getTranslation(this.lblName.getText()));
    }

    public void setLocate(Locale locale) {
        Locale l = super.getLocale();
        if (!l.equals(locale)) {
            this.translate();
        }
        super.setLocale(locale);
    }

    public ColorTableClass getSelected() {
        int row = this.tblColorTableClasses.getSelectedRow();
        return ((ColorTableClassesTableModel)this.tblColorTableClasses.getModel()).getColorTableClass(row);
    }

    public void set(ColorTable colorTable) {
        this.colorTable = null;
        this.isModified = false;
        if (colorTable != null) {
            this.colorTable = colorTable;
        }
        this.init();
        this.updateComponents();
    }

    private void init() {
        if (this.colorTable != null) {
            this.txtName.setText(this.colorTable.getName());
            this.chkInterpolated.setSelected(this.colorTable.isInterpolated());
        } else {
            this.txtName.setText("");
            this.chkInterpolated.setSelected(false);
        }
        if (this.tableModel == null) {
            this.tableModel = new DefaultColorTableClassesTableModel(this.colorTable);
            this.tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ColorTableEditorPanelController.this.isModified = true;
                }
            });
        } else {
            this.tableModel.setColorTable(this.colorTable);
        }
        this.tblColorTableClasses.setModel((TableModel)this.tableModel);
        this.tblColorTableClasses.setRowHeight((int)new JFormattedTextField().getPreferredSize().getHeight());
        this.tblColorTableClasses.setColumnModel(new DefaultTableColumnModel());
        TableColumnModel columnModel = this.tblColorTableClasses.getColumnModel();
        columnModel.setColumnSelectionAllowed(false);
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            TableColumn tableColumn = new TableColumn(i);
            tableColumn.setIdentifier(this.tableModel.getColumnName(i));
            tableColumn.setHeaderValue(this.tableModel.getColumnName(i));
            if (i == 0) {
                tableColumn.setCellRenderer(new PreviewerColorTableClassCellRenderer());
                ColorChooserEditor editor = new ColorChooserEditor();
                tableColumn.setCellEditor(editor);
                editor.addCellEditorListener(new CellEditorListener(){

                    @Override
                    public void editingStopped(ChangeEvent e) {
                        ColorTableEditorPanelController.this.isModified = true;
                    }

                    @Override
                    public void editingCanceled(ChangeEvent e) {
                    }
                });
            } else if (i == 2) {
                tableColumn.setCellRenderer(new PerhapsNotValidValueCellRenderer());
            }
            columnModel.addColumn(tableColumn);
        }
    }

    private void updateComponents() {
        boolean selected = this.tblColorTableClasses.getSelectedRowCount() >= 1;
        this.btnRemove.setEnabled(selected);
        if (this.colorTable == null) {
            this.btnRemoveAll.setEnabled(false);
            this.btnAdd.setEnabled(false);
            this.chkInterpolated.setEnabled(false);
            this.lblName.setEnabled(false);
            this.txtName.setEnabled(false);
        } else {
            this.btnRemoveAll.setEnabled(this.colorTable.getClasses().size() > 0);
            this.btnAdd.setEnabled(true);
            this.chkInterpolated.setEnabled(true);
            this.lblName.setEnabled(true);
            this.txtName.setEnabled(true);
        }
    }

    public ColorTable getColorTable() {
        if (this.colorTable == null) {
            return null;
        }
        this.colorTable.setInterpolated(this.chkInterpolated.isSelected());
        this.colorTable.setName(this.txtName.getText());
        return this.colorTable;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void addTableModelListener(TableModelListener listener) {
        ((ColorTableClassesTableModel)this.tblColorTableClasses.getModel()).addTableModelListener(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(listener);
        }
    }

    public void addChkInterpolatedItemListener(ItemListener listener) {
        this.chkInterpolated.addItemListener(listener);
    }
}

