/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.legend.impl.colortable.selector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;

public class PreviewerColorTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 9027225839371919399L;
    private ColorTable colorTable;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof ColorTable) {
            this.colorTable = (ColorTable)value;
            Rectangle cellRect = table.getCellRect(row, column, false);
            BufferedImage image = new BufferedImage((int)cellRect.getWidth(), (int)cellRect.getHeight(), 6);
            this.paintImage(image, isSelected);
            ImageIcon icon = new ImageIcon(image, this.colorTable.getName());
            this.setIcon(icon);
        }
        return this;
    }

    private void paintImage(BufferedImage image, boolean isSelected) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        Rectangle area = new Rectangle(image.getWidth(), image.getHeight());
        int x1 = area.x;
        int x2 = area.x + area.width - 1;
        Color bgColor = new Color(224, 224, 224);
        int i = 0;
        while (i * 4 <= area.width) {
            int j = 0;
            while (j * 4 <= area.height) {
                if ((i + j) % 2 == 0) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(bgColor);
                }
                g.fillRect(area.x + 1 + i * 4, area.y + 1 + j * 4, 4, 4);
                ++j;
            }
            ++i;
        }
        if (this.colorTable.getClasses().size() >= 1) {
            double min = ((ColorTableClass)this.colorTable.getClasses().get(0)).getValue();
            double max = ((ColorTableClass)this.colorTable.getClasses().get(this.colorTable.getClasses().size() - 1)).getValue();
            for (int i2 = area.x; i2 < area.x + area.width; ++i2) {
                double pos = min + (max - min) * (double)(i2 - area.x) / (double)(area.width - 2);
                byte[] col3 = this.colorTable.getRGBA((Object)pos);
                g.setColor(new Color(col3[0] & 0xFF, col3[1] & 0xFF, col3[2] & 0xFF, col3[3] & 0xFF));
                g.drawLine(i2, area.y, i2, area.y + area.height);
            }
        } else {
            g.setColor(new Color(224, 224, 224));
            g.fillRect(x1, area.y, x2 - x1, area.height);
        }
        if (isSelected) {
            g.setColor(Color.black);
        } else {
            g.setColor(new Color(96, 96, 96));
        }
        g.drawRect(x1, area.y, x2 - x1, area.height - 1);
    }
}

