/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.basicformats.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.basicformats.STXFile;
import org.gvsig.basicformats.impl.AbstractFormatFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSTXFile
extends AbstractFormatFile
implements STXFile {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSTXFile.class);
    private File source = null;
    private List<STXFile.STXBand> bands = new ArrayList<STXFile.STXBand>();

    @Override
    public File getFile(File file) {
        File f = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + "." + "stx");
        return f;
    }

    @Override
    public File getFile() {
        return this.source;
    }

    @Override
    public void read(File file) throws IOException {
        File f = this.getFile(file);
        if (f.exists()) {
            try {
                this.bands = new ArrayList<STXFile.STXBand>();
                List lines = FileUtils.readLines((File)f);
                if (lines != null) {
                    this.source = f.getAbsoluteFile();
                    int lineno = 1;
                    for (String line : lines) {
                        try {
                            DefaultSTXBand band = new DefaultSTXBand(line.trim());
                            this.bands.add(band);
                        }
                        catch (IllegalArgumentException e) {
                            logger.warn("Can't parse line '" + line + "' (lineno=+" + lineno + ", file=" + f.getAbsoluteFile() + ").", (Throwable)e);
                        }
                    }
                }
                this.bands = Collections.unmodifiableList(this.bands);
            }
            catch (IOException e) {
                logger.warn("Couldn't read stx file (" + f.getAbsoluteFile() + ")", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public List<STXFile.STXBand> getBands() {
        return this.bands;
    }

    @Override
    public void clear() {
        this.bands = new ArrayList<STXFile.STXBand>();
    }

    @Override
    public void addBand(int band, double minimum, double maximum, double mean, double std_deviation, double linear_stretch_min, double linear_stretch_max) {
        DefaultSTXBand b = new DefaultSTXBand(band, minimum, maximum, mean, std_deviation, linear_stretch_min, linear_stretch_max);
        this.bands.add(b);
    }

    @Override
    public void write(File file) throws IOException {
        File f = this.getFile(file);
        ArrayList<String> lines = new ArrayList<String>();
        for (STXFile.STXBand band : this.bands) {
            lines.add(band.toString());
        }
        FileUtils.writeLines((File)f, lines);
        this.source = f;
    }

    public static class DefaultSTXBand
    implements STXFile.STXBand {
        private int band;
        private double minimum;
        private double maximum;
        private double mean;
        private double std_deviation;
        private double linear_stretch_min;
        private double linear_stretch_max;
        private boolean valid = false;

        public DefaultSTXBand() {
        }

        public DefaultSTXBand(int band, double minimum, double maximum, double mean, double std_deviation, double linear_stretch_min, double linear_stretch_max) {
            this();
            this.band = band;
            this.minimum = minimum;
            this.maximum = maximum;
            this.mean = mean;
            this.std_deviation = std_deviation;
            this.linear_stretch_min = linear_stretch_min;
            this.linear_stretch_max = linear_stretch_max;
        }

        public DefaultSTXBand(String line) {
            this();
            this.parse(line);
        }

        @Override
        public void parse(String line) {
            this.valid = false;
            String[] words = StringUtils.split((String)line.trim().toLowerCase());
            if (words.length < 7) {
                throw new IllegalArgumentException("At least 7 parameters are needed (" + line + ").");
            }
            this.band = Integer.parseInt(words[0]);
            this.minimum = Double.parseDouble(words[1]);
            this.maximum = Double.parseDouble(words[2]);
            this.mean = "#".equals(words[3]) ? Double.NaN : Double.parseDouble(words[3]);
            this.std_deviation = "#".equals(words[4]) ? Double.NaN : Double.parseDouble(words[4]);
            this.linear_stretch_min = "#".equals(words[5]) ? Double.NaN : Double.parseDouble(words[5]);
            this.linear_stretch_max = "#".equals(words[6]) ? Double.NaN : Double.parseDouble(words[6]);
            this.valid = true;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.band).append(" ");
            builder.append(this.minimum).append(" ");
            builder.append(this.maximum).append(" ");
            if (Double.isNaN(this.mean)) {
                builder.append("# ");
            } else {
                builder.append(this.mean).append(" ");
            }
            if (Double.isNaN(this.std_deviation)) {
                builder.append("# ");
            } else {
                builder.append(this.std_deviation).append(" ");
            }
            if (Double.isNaN(this.linear_stretch_min)) {
                builder.append("# ");
            } else {
                builder.append(this.linear_stretch_min).append(" ");
            }
            if (Double.isNaN(this.linear_stretch_max)) {
                builder.append("# ");
            } else {
                builder.append(this.linear_stretch_max).append(" ");
            }
            return builder.toString();
        }

        @Override
        public int getBand() {
            return this.band;
        }

        @Override
        public double getMinimum() {
            return this.minimum;
        }

        @Override
        public double getMaximum() {
            return this.maximum;
        }

        @Override
        public double getMean() {
            return this.mean;
        }

        @Override
        public double getStdDeviation() {
            return this.std_deviation;
        }

        @Override
        public double getLinearStretchMin() {
            return this.linear_stretch_min;
        }

        @Override
        public double getLinearStretchMax() {
            return this.linear_stretch_max;
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }
    }
}

