/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp;

import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;

public class SHPNewStoreParameters
extends SHPStoreParameters
implements NewFeatureStoreParameters {
    public static final String PARAMETERS_DEFINITION_NAME = "SHPNewStoreParameters";
    public static final String FEATURETYPE_PARAMTER_NAME = "FeatureType";
    protected static final String GEOMETRYTYPE_PARAMETER_NAME = "geometryType";

    public SHPNewStoreParameters() {
        super(PARAMETERS_DEFINITION_NAME);
    }

    public byte getCodePage() {
        return (Byte)this.getDynValue("codePage");
    }

    public void setCodePage(byte value) {
        this.setDynValue("codePage", value);
    }

    public int getGeometryType() {
        Integer type = (Integer)this.getDynValue(GEOMETRYTYPE_PARAMETER_NAME);
        if (type == null) {
            return 16;
        }
        return type;
    }

    public void setGeometryType(int type) {
        this.setDynValue(GEOMETRYTYPE_PARAMETER_NAME, type);
    }

    public EditableFeatureType getDefaultFeatureType() {
        FeatureType featureType = (FeatureType)this.getDynValue(FEATURETYPE_PARAMTER_NAME);
        if (featureType instanceof EditableFeatureType) {
            return (EditableFeatureType)featureType;
        }
        return featureType.getEditable();
    }

    public void setDefaultFeatureType(FeatureType featureType) {
        if (featureType instanceof EditableFeatureType) {
            ((EditableFeatureType)featureType).setHasOID(true);
        } else {
            EditableFeatureType editable = featureType.getEditable();
            editable.setHasOID(true);
            featureType = editable;
        }
        this.setDynValue(FEATURETYPE_PARAMTER_NAME, featureType);
    }

    @Override
    public void fixParameters() {
        FeatureAttributeDescriptor geometryAttribute;
        super.fixParameters();
        EditableFeatureType featureType = this.getDefaultFeatureType();
        if (featureType != null && (geometryAttribute = featureType.getAttributeDescriptor(featureType.getDefaultGeometryAttributeName())) != null) {
            if (this.getDynValue(GEOMETRYTYPE_PARAMETER_NAME) == null) {
                int geometryType = featureType.getAttributeDescriptor(geometryAttribute.getName()).getGeometryType();
                this.setGeometryType(geometryType);
            }
            if (this.getCRS() == null) {
                this.setCRS(geometryAttribute.getSRS());
            }
        }
    }
}

