/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.store.shp.utils.SHP;
import org.gvsig.fmap.dal.store.shp.utils.SHPShape;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPMultiLine
implements SHPShape {
    protected int m_type;
    protected int[] parts;
    protected Point[] points;
    protected double[] zs;
    private GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(SHPShape.class);

    public SHPMultiLine() {
        this.m_type = 3;
    }

    public SHPMultiLine(int type) {
        if (type == 3 || type == 23 || type != 13) {
            // empty if block
        }
        this.m_type = type;
    }

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Override
    public Geometry read(MappedByteBuffer buffer, int type) {
        int numParts = buffer.getInt();
        int numPoints = buffer.getInt();
        int[] partOffsets = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            partOffsets[i] = buffer.getInt();
        }
        Point[] points = new Point[numPoints];
        for (int t = 0; t < numPoints; ++t) {
            try {
                points[t] = (Point)this.geomManager.create(1, 0);
                points[t].setX(buffer.getDouble());
                points[t].setY(buffer.getDouble());
                continue;
            }
            catch (CreateGeometryException e) {
                logger.error("Error creating a point", (Throwable)e);
            }
        }
        Curve curve = null;
        try {
            curve = (Curve)this.geomManager.create(2, 0);
            curve.setGeneralPath(this.getGeneralPathX(points, partOffsets));
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating the curve", (Throwable)e);
        }
        return curve;
    }

    @Override
    public void write(ByteBuffer buffer, Geometry geometry) {
        Envelope env = geometry.getEnvelope();
        buffer.putDouble(env.getMinimum(0));
        buffer.putDouble(env.getMinimum(1));
        buffer.putDouble(env.getMaximum(0));
        buffer.putDouble(env.getMaximum(1));
        int numParts = this.parts.length;
        int npoints = this.points.length;
        buffer.putInt(numParts);
        buffer.putInt(npoints);
        for (int i = 0; i < numParts; ++i) {
            buffer.putInt(this.parts[i]);
        }
        for (int t = 0; t < npoints; ++t) {
            buffer.putDouble(this.points[t].getX());
            buffer.putDouble(this.points[t].getY());
        }
        if (this.m_type == 13) {
            double[] zExtreame = SHP.getZMinMax(this.zs);
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t = 0; t < npoints; ++t) {
                double z = this.zs[t];
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.m_type == 23) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (int t = 0; t < npoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }

    @Override
    public int getLength(Geometry fgeometry) {
        int length;
        int numlines = this.parts.length;
        int numpoints = this.points.length;
        if (this.m_type == 3) {
            length = 44 + 4 * numlines + numpoints * 16;
        } else if (this.m_type == 23) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 * numpoints + 16;
        } else if (this.m_type == 13) {
            length = 44 + 4 * numlines + numpoints * 16 + 8 * numpoints + 16;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.m_type);
        }
        return length;
    }

    protected GeneralPathX getGeneralPathX(Point[] po, int[] pa) {
        GeneralPathX gPX = new GeneralPathX(0, po.length);
        int j = 0;
        for (int i = 0; i < po.length; ++i) {
            if (i == pa[j]) {
                gPX.moveTo(po[i].getX(), po[i].getY());
                if (j >= pa.length - 1) continue;
                ++j;
                continue;
            }
            gPX.lineTo(po[i].getX(), po[i].getY());
        }
        return gPX;
    }

    @Override
    public void obtainsPoints(Geometry g) {
        int i;
        int i2;
        MultiPrimitive multiPrimitive;
        ArrayList arrayPoints = new ArrayList();
        ArrayList arrayParts = new ArrayList();
        ArrayList arrayZs = new ArrayList();
        boolean is3D = false;
        if (13 == this.m_type || 15 == this.m_type) {
            if (g.getGeometryType().isTypeOf(6)) {
                multiPrimitive = (MultiPrimitive)g;
                int countVertex = 0;
                for (i2 = 0; i2 < multiPrimitive.getPrimitivesNumber(); ++i2) {
                    OrientablePrimitive orientablePrimitive = (OrientablePrimitive)multiPrimitive.getPrimitiveAt(i2);
                    countVertex += orientablePrimitive.getNumVertices();
                }
                this.zs = new double[countVertex];
                int indexZS = 0;
                for (int nPrimitive = 0; nPrimitive < multiPrimitive.getPrimitivesNumber(); ++nPrimitive) {
                    OrientablePrimitive orientablePrimitive = (OrientablePrimitive)multiPrimitive.getPrimitiveAt(nPrimitive);
                    for (int nVertex = 0; nVertex < orientablePrimitive.getNumVertices(); ++nVertex) {
                        this.zs[indexZS] = orientablePrimitive.getCoordinateAt(nVertex, 2);
                    }
                }
            } else {
                OrientablePrimitive orientablePrimitive = (OrientablePrimitive)g;
                this.zs = new double[orientablePrimitive.getNumVertices()];
                for (i = 0; i < this.zs.length; ++i) {
                    this.zs[i] = orientablePrimitive.getCoordinateAt(i, 2);
                }
            }
            is3D = true;
        }
        if (g.getGeometryType().isTypeOf(6)) {
            multiPrimitive = (MultiPrimitive)g;
            int index = 0;
            for (i2 = 0; i2 < multiPrimitive.getPrimitivesNumber(); ++i2) {
                index = this.obtainsPoints(multiPrimitive.getPrimitiveAt(i2), arrayPoints, arrayParts, arrayZs, is3D, index);
            }
        } else {
            this.obtainsPoints((Primitive)g, arrayPoints, arrayParts, arrayZs, is3D, 0);
        }
        Integer[] integers = arrayParts.toArray(new Integer[0]);
        this.parts = new int[integers.length];
        for (i = 0; i < integers.length; ++i) {
            this.parts[i] = integers[i];
        }
        if (arrayPoints == null) {
            this.points = new Point[0];
            return;
        }
        this.points = arrayPoints.toArray(new Point[0]);
        if (is3D) {
            Double[] doubleZs = arrayZs.toArray(new Double[0]);
            this.zs = new double[doubleZs.length];
            for (i2 = 0; i2 < doubleZs.length; ++i2) {
                this.zs[i2] = doubleZs[i2];
            }
        }
    }

    private int obtainsPoints(Primitive primitive, List arrayPoints, List arrayParts, List arrayZs, boolean is3D, int index) {
        PathIterator theIterator = primitive.getPathIterator(null, this.geomManager.getFlatness());
        double[] theData = new double[6];
        Point2D pFirst = null;
        int pos = 0;
        boolean first = true;
        Double firstZ = null;
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    Point point;
                    if (first) {
                        first = false;
                    } else if (this.m_type == 5 || this.m_type == 15 || this.m_type == 25) {
                        try {
                            point = this.geomManager.createPoint(pFirst.getX(), pFirst.getY(), 0);
                            if (!arrayPoints.get(arrayPoints.size() - 1).equals(point)) {
                                arrayPoints.add(point);
                                if (is3D) {
                                    arrayZs.add(firstZ);
                                }
                            }
                        }
                        catch (CreateGeometryException e) {
                            logger.error("Error creating a point", (Throwable)e);
                        }
                    }
                    arrayParts.add(index);
                    pFirst = new Point2D.Double(theData[0], theData[1]);
                    try {
                        arrayPoints.add(this.geomManager.createPoint(theData[0], theData[1], 0));
                    }
                    catch (CreateGeometryException e1) {
                        logger.error("Error creating a point", (Throwable)e1);
                    }
                    if (!is3D) break;
                    Double z = 0.0;
                    if (pos < this.zs.length) {
                        z = this.zs[pos];
                    }
                    firstZ = z;
                    arrayZs.add(z);
                    ++pos;
                    break;
                }
                case 1: {
                    try {
                        arrayPoints.add(this.geomManager.createPoint(theData[0], theData[1], 0));
                    }
                    catch (CreateGeometryException e) {
                        logger.error("Error creating a point", (Throwable)e);
                    }
                    if (!is3D) break;
                    Double z = 0.0;
                    if (pos < this.zs.length) {
                        z = this.zs[pos];
                    }
                    arrayZs.add(z);
                    ++pos;
                    break;
                }
                case 2: {
                    System.out.println("Not supported here");
                    break;
                }
                case 3: {
                    System.out.println("Not supported here");
                    break;
                }
                case 4: {
                    Point point;
                    try {
                        point = this.geomManager.createPoint(pFirst.getX(), pFirst.getY(), 0);
                        if (arrayPoints.get(arrayPoints.size() - 1).equals(point)) break;
                        arrayPoints.add(point);
                        if (is3D) {
                            arrayZs.add(firstZ);
                        }
                        ++index;
                        break;
                    }
                    catch (CreateGeometryException e) {
                        logger.error("Error creating a point", (Throwable)e);
                    }
                }
            }
            if (theType != 4) {
                ++index;
            }
            theIterator.next();
        }
        return index;
    }
}

