/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.store.shp.utils.SHPShapeWriter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPMultiLine2DMWriter
implements SHPShapeWriter {
    private Geometry geometry;
    private int m_type = 23;
    private int[] parts;
    private Point[] points;
    private static final Logger logger = LoggerFactory.getLogger(SHPMultiLine2DMWriter.class);

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Override
    public void write(ByteBuffer buffer) throws WriteException {
        Point point;
        int t;
        Envelope env = this.geometry.getEnvelope();
        buffer.putDouble(env.getMinimum(0));
        buffer.putDouble(env.getMinimum(1));
        buffer.putDouble(env.getMaximum(0));
        buffer.putDouble(env.getMaximum(1));
        try {
            this.initialize(this.geometry);
        }
        catch (GeometryException e) {
            throw new WriteException("SHPMultiLine2DM write", (Throwable)e);
        }
        double Mmin = Double.POSITIVE_INFINITY;
        double Mmax = Double.NEGATIVE_INFINITY;
        int numParts = this.parts.length;
        int npoints = this.points.length;
        buffer.putInt(numParts);
        buffer.putInt(npoints);
        for (int i = 0; i < numParts; ++i) {
            buffer.putInt(this.parts[i]);
        }
        for (t = 0; t < npoints; ++t) {
            point = this.points[t];
            buffer.putDouble(point.getX());
            buffer.putDouble(point.getY());
            double m = point.getCoordinateAt(point.getDimension() - 1);
            if (m < Mmin) {
                Mmin = m;
            }
            if (!(m > Mmax)) continue;
            Mmax = m;
        }
        buffer.putDouble(Mmin);
        buffer.putDouble(Mmax);
        for (t = 0; t < npoints; ++t) {
            point = this.points[t];
            buffer.putDouble(this.points[t].getCoordinateAt(point.getDimension() - 1));
        }
    }

    @Override
    public void initialize(Geometry g) throws GeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        this.geometry = g;
        ArrayList<Point> arrayPoints = new ArrayList<Point>();
        ArrayList<Integer> arrayParts = new ArrayList<Integer>();
        if (this.geometry instanceof Line) {
            Line line = (Line)this.geometry;
            arrayParts.add(0);
            for (int i = 0; i < line.getNumVertices(); ++i) {
                arrayPoints.add(line.getVertex(i));
            }
        } else {
            int i;
            MultiLine multiLine = null;
            if (g instanceof MultiLine) {
                multiLine = (MultiLine)this.geometry;
            } else if (g instanceof MultiCurve) {
                multiLine = geomManager.createMultiLine(2);
                MultiCurve multiCurve = (MultiCurve)g;
                for (i = 0; i < multiCurve.getPrimitivesNumber(); ++i) {
                    Curve curve = (Curve)multiCurve.getPrimitiveAt(i);
                    if (curve instanceof Line) {
                        multiLine.addPrimitive((Primitive)curve);
                        continue;
                    }
                    MultiLine lines = curve.toLines();
                    for (int j = 0; j < lines.getPrimitivesNumber(); ++j) {
                        multiLine.addPrimitive(lines.getPrimitiveAt(j));
                    }
                }
            } else {
                multiLine = g.toLines();
            }
            int index = 0;
            arrayParts.add(index);
            for (i = 0; i < multiLine.getPrimitivesNumber(); ++i) {
                Line line = (Line)multiLine.getPrimitiveAt(i);
                for (int j = 0; j < line.getNumVertices(); ++j) {
                    arrayPoints.add(line.getVertex(j));
                }
                if (i >= multiLine.getPrimitivesNumber() - 1) continue;
                arrayParts.add(index += line.getNumVertices());
            }
        }
        this.points = arrayPoints.toArray(new Point[0]);
        this.parts = new int[arrayParts.size()];
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i] = (Integer)arrayParts.get(i);
        }
    }

    @Override
    public int getLength() {
        int numlines = this.parts.length;
        int numpoints = this.points.length;
        int length = 44 + 4 * numlines + numpoints * 16 + 16 + numpoints * 8;
        return length;
    }
}

