/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.store.shp.utils.SHPShapeWriter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPPolygon2DMWriter
implements SHPShapeWriter {
    private Geometry geometry;
    private int m_type = 25;
    private int[] parts;
    private Point[] points;
    private static final Logger logger = LoggerFactory.getLogger(SHPPolygon2DMWriter.class);

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Override
    public synchronized void write(ByteBuffer buffer) throws WriteException {
        Point point;
        int t;
        Envelope env = this.geometry.getEnvelope();
        buffer.putDouble(env.getMinimum(0));
        buffer.putDouble(env.getMinimum(1));
        buffer.putDouble(env.getMaximum(0));
        buffer.putDouble(env.getMaximum(1));
        try {
            this.initialize(this.geometry);
        }
        catch (BaseException e) {
            throw new WriteException("SHPPolygon2DWriter", (Throwable)e);
        }
        double Mmin = Double.POSITIVE_INFINITY;
        double Mmax = Double.NEGATIVE_INFINITY;
        int numParts = this.parts.length;
        int npoints = this.points.length;
        buffer.putInt(numParts);
        buffer.putInt(npoints);
        for (int i = 0; i < numParts; ++i) {
            buffer.putInt(this.parts[i]);
        }
        for (t = 0; t < npoints; ++t) {
            point = this.points[t];
            buffer.putDouble(point.getX());
            buffer.putDouble(point.getY());
            double m = point.getCoordinateAt(point.getDimension() - 1);
            if (m < Mmin) {
                Mmin = m;
            }
            if (!(m > Mmax)) continue;
            Mmax = m;
        }
        buffer.putDouble(Mmin);
        buffer.putDouble(Mmax);
        for (t = 0; t < npoints; ++t) {
            point = this.points[t];
            buffer.putDouble(point.getCoordinateAt(point.getDimension() - 1));
        }
    }

    @Override
    public void initialize(Geometry g) throws GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        int i;
        int index;
        this.geometry = g;
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        ArrayList<Point> arrayPoints = new ArrayList<Point>();
        ArrayList<Integer> arrayParts = new ArrayList<Integer>();
        if (this.geometry instanceof Polygon) {
            Polygon polygon = (Polygon)this.geometry;
            polygon.ensureOrientation(false);
            index = 0;
            arrayParts.add(index);
            for (i = 0; i < polygon.getNumVertices(); ++i) {
                arrayPoints.add(polygon.getVertex(i));
            }
            if (polygon.getNumInteriorRings() != 0) {
                arrayParts.add(index += polygon.getNumVertices());
            }
            for (int r = 0; r < polygon.getNumInteriorRings(); ++r) {
                Ring ring = polygon.getInteriorRing(r);
                ring.ensureOrientation(true);
                for (int i2 = 0; i2 < ring.getNumVertices(); ++i2) {
                    arrayPoints.add(ring.getVertex(i2));
                }
                if (r >= polygon.getNumInteriorRings() - 1) continue;
                arrayParts.add(index += ring.getNumVertices());
            }
        } else {
            MultiPolygon multiPolygon = null;
            if (this.geometry instanceof MultiPolygon) {
                multiPolygon = (MultiPolygon)this.geometry;
            } else if (this.geometry instanceof MultiSurface) {
                multiPolygon = geomManager.createMultiPolygon(2);
                MultiSurface multiSurface = (MultiSurface)this.geometry;
                for (i = 0; i < multiSurface.getPrimitivesNumber(); ++i) {
                    Surface surface = (Surface)multiSurface.getPrimitiveAt(i);
                    if (surface instanceof Polygon) {
                        Polygon polygon = (Polygon)surface;
                        if (polygon.isEmpty()) continue;
                        polygon.ensureOrientation(false);
                        multiPolygon.addPrimitive((Primitive)surface);
                        continue;
                    }
                    MultiPolygon polygons = surface.toPolygons();
                    for (int j = 0; j < polygons.getPrimitivesNumber(); ++j) {
                        Primitive polygon = polygons.getPrimitiveAt(j);
                        if (polygon.isEmpty()) continue;
                        polygon.ensureOrientation(false);
                        multiPolygon.addPrimitive(polygon);
                    }
                }
            } else {
                multiPolygon = this.geometry.toPolygons();
            }
            arrayParts.add(0);
            index = 0;
            for (i = 0; i < multiPolygon.getPrimitivesNumber(); ++i) {
                Polygon polygon = (Polygon)multiPolygon.getPrimitiveAt(i);
                if (polygon.isEmpty()) continue;
                polygon.ensureOrientation(false);
                for (int j = 0; j < polygon.getNumVertices(); ++j) {
                    arrayPoints.add(polygon.getVertex(j));
                }
                if (polygon.getNumInteriorRings() != 0 || i < multiPolygon.getPrimitivesNumber() - 1) {
                    arrayParts.add(index += polygon.getNumVertices());
                }
                for (int r = 0; r < polygon.getNumInteriorRings(); ++r) {
                    Ring ring = polygon.getInteriorRing(r);
                    if (ring.isEmpty()) continue;
                    ring.ensureOrientation(true);
                    for (int j = 0; j < ring.getNumVertices(); ++j) {
                        arrayPoints.add(ring.getVertex(j));
                    }
                    if (i >= multiPolygon.getPrimitivesNumber() - 1 && r >= polygon.getNumInteriorRings() - 1) continue;
                    arrayParts.add(index += ring.getNumVertices());
                }
            }
        }
        this.points = arrayPoints.toArray(new Point[0]);
        this.parts = new int[arrayParts.size()];
        for (int i3 = 0; i3 < this.parts.length; ++i3) {
            this.parts[i3] = (Integer)arrayParts.get(i3);
        }
    }

    @Override
    public synchronized int getLength() {
        int numlines = this.parts.length;
        int numpoints = this.points.length;
        int length = 44 + 4 * numlines + numpoints * 16 + 16 + numpoints * 8;
        return length;
    }
}

