/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.Cloneable;
import gishur.x.AffineTransformation;
import gishur.x.XPoint;
import java.io.Serializable;

public abstract class XObject
implements Cloneable,
Serializable {
    public XObject scale_XObject(XPoint xPoint, double d, double d2) {
        return this.transform_XObject(d, 0.0, -d * xPoint.x() + xPoint.x(), 0.0, d2, -d2 * xPoint.y() + xPoint.y());
    }

    public XObject rotate_XObject(XPoint xPoint, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return this.transform_XObject(d2, -d3, -xPoint.x() * d2 + xPoint.y() * d3 + xPoint.x(), d3, d2, -xPoint.x() * d3 - xPoint.y() * d2 + xPoint.y());
    }

    public XObject translate_XObject(double d, double d2) {
        return this.transform_XObject(1.0, 0.0, d, 0.0, 1.0, d2);
    }

    public XObject translate_XObject(XPoint xPoint) {
        return this.transform_XObject(1.0, 0.0, xPoint.x(), 0.0, 1.0, xPoint.y());
    }

    public String toString() {
        return this.getClass().getName() + "[]";
    }

    public boolean mutable() {
        return true;
    }

    public void restoreMutability() {
    }

    public XObject copy() {
        return (XObject)this.clone();
    }

    public XObject getMutable() {
        return this;
    }

    public abstract XObject transform_XObject(double var1, double var3, double var5, double var7, double var9, double var11);

    public XObject inverseTransform_XObject(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d * d5 - d2 * d4;
        if (Math.abs(d7) <= Double.MIN_VALUE) {
            throw new InternalError("Determinant is " + d7);
        }
        return this.transform_XObject(d5 / d7, -d2 / d7, (d2 * d6 - d5 * d3) / d7, -d4 / d7, d / d7, (d4 * d3 - d * d6) / d7);
    }

    public XObject transform_XObject(AffineTransformation affineTransformation) {
        double[] dArray = affineTransformation.matrix();
        return this.transform_XObject(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

