/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.dataaccess;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.Optimizer;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.expressionevaluator.TableAttributeHandler;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureQueryOrder;
import org.gvsig.fmap.dal.impl.expressionevaluator.DefaultFeatureExpressionEvaluator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;

public class InsertIntoTableFunction
extends AbstractFunction
implements Optimizer.FunctionOptimizer {
    private static final int COLUMNS = 1;
    private static final int TABLE = 2;
    private static final int WHERE = 3;
    private static final int ORDER = 4;
    private static final int ORDER_MODE = 5;
    private static final int LIMIT = 6;

    public InsertIntoTableFunction() {
        super("Data access", "INSERT_INTO_TABLE", Range.is((Comparable)Integer.valueOf(7)), "Inserts in the indicated table the records obtained from the specified SELECT statement.\nReturn the number of inserted records.\nThis statement must always end with a semicolon.\nSee the SELECT statement for more information on this.", "INSERT INTO {{table_name}} SELECT * FROM table WHERE boolean_expression ORDER BY order_column LIMIT limit;", new String[]{"table_name - Name of the table in which to insert the records.", "column_names/asterisk - Names of the columns table to retrieve.", "table_name - Name of the table", "filter - boolean expression to apply as filter", "order_column - the order used to retrieve the features. It is a list of column names separated by a comma. The column name can optionally be followed by ASC or DESC to indicate whether the order should be ascending or descending.", "limit - Maximum number of features to return"}, "Number", false);
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException();
    }

    private Code.Callable getTupleOrNull(Codes args, int argn) {
        Code code = (Code)args.get(argn);
        if (code.code() == 0) {
            if (((Code.Constant)code).value() != null) {
                throw new ExpressionRuntimeException("Tupple or null expected in argument " + argn + " of function '" + "SELECT" + "'.");
            }
            return null;
        }
        if (code.code() != 2) {
            throw new ExpressionRuntimeException("Tupple or null expected in argument " + argn + " of function '" + "SELECT" + "'.");
        }
        Code.Callable caller = (Code.Callable)code;
        if (!StringUtils.equalsIgnoreCase((CharSequence)"TUPLE", (CharSequence)caller.name())) {
            throw new ExpressionRuntimeException("Tupple or null expected in argument " + argn + " of function '" + "SELECT" + "'.");
        }
        return caller;
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        FeatureStore targetStore = null;
        FeatureStore sourceStore = null;
        try {
            FeatureSet features;
            DataStore store;
            String targetTableName = Objects.toString(this.getObject(interpreter, args, 0), null);
            if (targetTableName == null) {
                throw new ExpressionRuntimeException("Target table name can't be null.");
            }
            DataManager dataManager = DALLocator.getDataManager();
            targetStore = (FeatureStore)dataManager.getStoresRepository().getStore(targetTableName);
            if (targetStore == null) {
                throw new ExpressionRuntimeException("Can't locate target table '" + targetTableName + "'.");
            }
            Code.Identifier storeName = (Code.Identifier)args.get(2);
            Code.Callable columns = this.getTupleOrNull(args, 1);
            Code where = (Code)args.get(3);
            Number limit = (Number)this.getObject(interpreter, args, 6);
            Code.Callable order = this.getTupleOrNull(args, 4);
            Code.Callable order_mode = this.getTupleOrNull(args, 5);
            DefaultFeatureQueryOrder queryOrder = null;
            if (order != null || order_mode != null) {
                for (int n = 0; n < order.parameters().size(); ++n) {
                    String member = (String)interpreter.run((Code)order.parameters().get(n));
                    Boolean mode = (Boolean)interpreter.run((Code)order_mode.parameters().get(n));
                    if (queryOrder == null) {
                        queryOrder = new DefaultFeatureQueryOrder();
                    }
                    queryOrder.add(member, mode);
                }
            }
            if ((store = this.getStore(storeName.name())) == null) {
                throw new ExpressionRuntimeException("Cant locate the store '" + storeName + "' in function '" + "SELECT" + "'.");
            }
            if (!(store instanceof FeatureStore)) {
                throw new ExpressionRuntimeException("The store'" + storeName + "' is not valid for function '" + "SELECT" + "', a FeatureStore is required.");
            }
            sourceStore = (FeatureStore)store;
            if (where == null && queryOrder == null && limit == null) {
                features = sourceStore.getFeatureSet();
            } else {
                FeatureQuery query = sourceStore.createFeatureQuery();
                if (where != null) {
                    this.removeOuterTablesReferences(interpreter, where);
                    DefaultFeatureExpressionEvaluator filter = new DefaultFeatureExpressionEvaluator(sourceStore.getName(), where.toString());
                    filter.toSymbolTable().addSymbolTable(interpreter.getSymbolTable());
                    query.addFilter((Evaluator)filter);
                }
                if (queryOrder != null) {
                    query.getOrder().copyFrom(queryOrder);
                }
                if (limit != null) {
                    query.setLimit(limit.longValue());
                }
                query.retrievesAllAttributes();
                features = sourceStore.getFeatureSet(query);
            }
            long count = 0L;
            targetStore.edit(2);
            for (Feature feature : features) {
                EditableFeature f = targetStore.createNewFeature();
                f.copyFrom(feature);
                targetStore.insert(f);
                ++count;
            }
            targetStore.finishEditing();
            return count;
        }
        catch (ExpressionRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (targetStore != null && targetStore.isAppending()) {
                targetStore.cancelEditing();
            }
            DisposeUtils.disposeQuietly(targetStore);
            DisposeUtils.disposeQuietly(sourceStore);
            throw new ExpressionRuntimeException("Problems calling 'SELECT' function", (Throwable)ex);
        }
    }

    protected DataStore getStore(String storeName) {
        DataManager dataManager = DALLocator.getDataManager();
        DataStore store = dataManager.getStoresRepository().getStore(storeName);
        return store;
    }

    private void removeOuterTablesReferences(Interpreter interpreter, Code where) {
        try {
            SymbolTable symbolTable = interpreter.getSymbolTable();
            TableAttributeHandler table = (TableAttributeHandler)symbolTable.value("$TABLE");
            ArrayList replaces = new ArrayList();
            CodeBuilder codeBuilder = ExpressionUtils.createCodeBuilder();
            where.accept(o -> {
                Code.Callable caller;
                Code code = (Code)o;
                if (code != null && code.code() == 2 && StringUtils.equalsIgnoreCase((CharSequence)(caller = (Code.Callable)code).name(), (CharSequence)"GETATTR")) {
                    String columnName;
                    Object tt;
                    Codes args = caller.parameters();
                    Code arg0 = (Code)args.get(0);
                    Code arg1 = (Code)args.get(1);
                    if (arg0 instanceof Code.Identifier && arg1 instanceof Code.Identifier && (tt = symbolTable.value(((Code.Identifier)arg0).name())) instanceof TableAttributeHandler && StringUtils.equalsIgnoreCase((CharSequence)((TableAttributeHandler)tt).getName(), (CharSequence)table.getName()) && (columnName = Objects.toString(((Code.Identifier)arg1).name(), null)) != null) {
                        Object value = table.get((Object)columnName);
                        replaces.add(new ImmutablePair((Object)caller, (Object)codeBuilder.constant(value)));
                    }
                }
            });
            for (Pair replace : replaces) {
                if (replace == null) continue;
                where.replace((Code)replace.getLeft(), (Code)replace.getRight());
            }
        }
        catch (BaseException ex) {
            throw new ExpressionRuntimeException("Can't remove references to outer tables.", (Throwable)ex);
        }
    }

    public Code optimize(Optimizer optimizer, Code.Callable caller) {
        return caller;
    }
}

