/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.complements.relatedfeatures;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.complements.relatedfeatures.RelatedFeaturesImpl;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.complement.AbstractComplementFactory;
import org.gvsig.tools.complement.Complement;
import org.gvsig.tools.complement.ComplementFactory;
import org.gvsig.tools.complement.ComplementsManager;
import org.gvsig.tools.dynobject.AbstractDynMethod;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.Tagged;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynMethodException;

public class RelatedFeaturesFactory
extends AbstractComplementFactory<Tagged> {
    public RelatedFeaturesFactory() {
        super("DAL.RelatedFeatures");
    }

    public Complement<Tagged> createComplement(Tagged object) {
        return new RelatedFeaturesImpl((ComplementFactory<Tagged>)this, object);
    }

    public static void selfRegister() {
        ComplementsManager complementsManager = ToolsLocator.getComplementsManager();
        complementsManager.registerComplement((ComplementFactory)new RelatedFeaturesFactory());
        DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
        dynObjectManager.registerTag("DAL.RelatedFeatures.Columns", "Part of a table of related features definition, stores the name of the fields to be shown in the table separated by two points.");
        dynObjectManager.registerTag("DAL.RelatedFeatures.Table", "Part of a table of related features definition, store the table name of features.", (DynMethod)new RelatedTableTagValues());
        dynObjectManager.registerTag("DAL.RelatedFeatures.Unique.Field.Name", "Part of a table of related features definition, store the name of the field that is a unique key in the features table.", (DynMethod)new RelatedUniqueFieldNameTagValues());
    }

    private static class RelatedUniqueFieldNameTagValues
    extends AbstractDynMethod {
        public RelatedUniqueFieldNameTagValues() {
            super("RelatedUniqueFieldNameTagValues");
        }

        public Object invoke(DynObject self, Object[] args) throws DynMethodException {
            if (ArrayUtils.isEmpty((Object[])args)) {
                return null;
            }
            if (!(args[0] instanceof Tags)) {
                return null;
            }
            Tags tags = (Tags)args[0];
            String tableName = tags.getString("DAL.RelatedFeatures.Table", null);
            if (StringUtils.isBlank((CharSequence)tableName)) {
                return null;
            }
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            FeatureType ft = repository.getFeatureType(tableName);
            if (ft == null) {
                return null;
            }
            ArrayList<String> attrNames = new ArrayList<String>();
            for (FeatureAttributeDescriptor attr : ft) {
                attrNames.add(attr.getName());
            }
            Collections.sort(attrNames);
            DynObjectValueItem[] values = new DynObjectValueItem[attrNames.size()];
            for (int i = 0; i < attrNames.size(); ++i) {
                values[i] = new DynObjectValueItem(attrNames.get(i), (String)attrNames.get(i));
            }
            return values;
        }
    }

    private static class RelatedTableTagValues
    extends AbstractDynMethod {
        public RelatedTableTagValues() {
            super("RelatedTableTagValues");
        }

        public Object invoke(DynObject self, Object[] args) throws DynMethodException {
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            ArrayList<String> tableNames = new ArrayList<String>();
            for (String tableName : repository.keySet()) {
                tableNames.add(tableName);
            }
            Collections.sort(tableNames);
            DynObjectValueItem[] values = new DynObjectValueItem[tableNames.size()];
            for (int i = 0; i < tableNames.size(); ++i) {
                values[i] = new DynObjectValueItem(tableNames.get(i), (String)tableNames.get(i));
            }
            return values;
        }
    }
}

