/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.complements.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.complements.Search;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.complement.AbstractComplement;
import org.gvsig.tools.complement.ComplementFactory;
import org.gvsig.tools.util.ChainedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchImpl
extends AbstractComplement<FeatureType>
implements Search {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SearchImpl.class);

    public SearchImpl(ComplementFactory<FeatureType> factory, FeatureType object) {
        super(factory, (Object)object);
    }

    public List<String> getResultColumnNames() {
        List<String> columnNames;
        FeatureType featureType = (FeatureType)this.getObject();
        String columns = featureType.getTags().getString("DAL.Preferred.Columns", null);
        if (StringUtils.isBlank((CharSequence)columns)) {
            List attributes = featureType.getFilteredAttributes(FeatureType.BASIC_TYPES_FILTER, 12);
            attributes.sort(Search.STR_INT_LONG_LABEL_ORDER);
            columnNames = new ArrayList<String>();
            for (FeatureAttributeDescriptor attr : attributes) {
                columnNames.add(attr.getName());
            }
        } else {
            columnNames = Arrays.asList(this.split(columns, ":/;,|-"));
        }
        return columnNames;
    }

    private String[] split(String value, String separators) {
        int firstSeparatorPosition = 1000000;
        Character sep = null;
        for (char ch : separators.toCharArray()) {
            int pos = value.indexOf(ch);
            if (pos <= 0 || pos >= firstSeparatorPosition) continue;
            sep = Character.valueOf(ch);
            firstSeparatorPosition = pos;
        }
        if (sep == null) {
            return new String[]{value};
        }
        return value.split("[" + sep + "]");
    }

    public List<Search.OrderedAttribute> getOrderedAttributes(Predicate<FeatureAttributeDescriptor> filter, Comparator<FeatureAttributeDescriptor> comparator, int max) {
        return this.getOrderedAttributes(filter, comparator, max, null);
    }

    public List<Search.OrderedAttribute> getOrderedAttributes(Predicate<FeatureAttributeDescriptor> filter, final Comparator<FeatureAttributeDescriptor> comparator, int max, List<FeatureAttributeDescriptor> extra) {
        FeatureType tthis = (FeatureType)this.getObject();
        ArrayList<Search.OrderedAttribute> mostUsed = new ArrayList<Search.OrderedAttribute>();
        ArrayList<Search.OrderedAttribute> favorites = new ArrayList<Search.OrderedAttribute>();
        ArrayList<Search.OrderedAttribute> normal = new ArrayList<Search.OrderedAttribute>();
        for (FeatureAttributeDescriptor attribute : tthis.getRecentUseds()) {
            mostUsed.add(new AnOrderedAttribute(attribute, 1));
        }
        for (FeatureAttributeDescriptor attribute : this.getFavorites()) {
            if (SearchImpl.contains(mostUsed, attribute.getName()) || !filter.test(attribute)) continue;
            favorites.add(new AnOrderedAttribute(attribute, 2));
        }
        for (FeatureAttributeDescriptor attribute : tthis.getAllAttributeDescriptors()) {
            if (SearchImpl.contains(mostUsed, attribute.getName()) || SearchImpl.contains(favorites, attribute.getName()) || !filter.test(attribute)) continue;
            normal.add(new AnOrderedAttribute(attribute, 0));
        }
        if (extra != null) {
            for (FeatureAttributeDescriptor attribute : extra) {
                if (SearchImpl.contains(mostUsed, attribute.getName()) || SearchImpl.contains(favorites, attribute.getName()) || SearchImpl.contains(normal, attribute.getName()) || !filter.test(attribute)) continue;
                normal.add(new AnOrderedAttribute(attribute, 3));
            }
        }
        Comparator<Search.OrderedAttribute> comparatorAdapter = new Comparator<Search.OrderedAttribute>(){

            @Override
            public int compare(Search.OrderedAttribute o1, Search.OrderedAttribute o2) {
                return comparator.compare(o1.getDescriptor(), o2.getDescriptor());
            }
        };
        mostUsed.sort(comparatorAdapter);
        favorites.sort(comparatorAdapter);
        normal.sort(comparatorAdapter);
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        ChainedIterator it = new ChainedIterator(new Iterator[]{mostUsed.iterator(), favorites.iterator(), normal.iterator()});
        ArrayList<Search.OrderedAttribute> r = new ArrayList<Search.OrderedAttribute>();
        for (int n = 0; n < max && it.hasNext(); ++n) {
            r.add((Search.OrderedAttribute)it.next());
        }
        return r;
    }

    private static boolean contains(List<Search.OrderedAttribute> attributes, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        for (Search.OrderedAttribute attribute : attributes) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)attribute.getDescriptor().getName())) continue;
            return true;
        }
        return false;
    }

    public int getPriority(FeatureAttributeDescriptor attribute) {
        if (attribute == null || attribute.getTags() == null) {
            return 0;
        }
        int p = attribute.getTags().getInt("DAL.Search.Attribute.Priority", 0);
        return p;
    }

    public List<FeatureAttributeDescriptor> getFavorites() {
        FeatureType featureType = (FeatureType)this.getObject();
        ArrayList<FeatureAttributeDescriptor> attrs = new ArrayList<FeatureAttributeDescriptor>();
        for (FeatureAttributeDescriptor attribute : featureType) {
            if (this.getPriority(attribute) <= 0) continue;
            attrs.add(attribute);
        }
        if (attrs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        attrs.sort(new Comparator<FeatureAttributeDescriptor>(){

            @Override
            public int compare(FeatureAttributeDescriptor o1, FeatureAttributeDescriptor o2) {
                return Integer.compare(SearchImpl.this.getPriority(o1), SearchImpl.this.getPriority(o2));
            }
        });
        return attrs;
    }

    private static class AnOrderedAttribute
    implements Search.OrderedAttribute {
        private final FeatureAttributeDescriptor descriptor;
        private final int type;

        public AnOrderedAttribute(FeatureAttributeDescriptor descriptor, int type) {
            this.descriptor = descriptor;
            this.type = type;
        }

        public FeatureAttributeDescriptor getDescriptor() {
            return this.descriptor;
        }

        public int getType() {
            return this.type;
        }
    }
}

