/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.Interval;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditableFeature
extends DefaultFeature
implements EditableFeature {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEditableFeature.class);
    private DefaultFeature source;
    private boolean modified;

    protected DefaultEditableFeature(DefaultFeature feature) {
        super(feature);
        this.source = feature;
        this.modified = false;
    }

    protected DefaultEditableFeature(DefaultEditableFeature feature) {
        super(feature);
        this.source = (DefaultFeature)feature.getSource();
        this.modified = feature.modified;
    }

    public DefaultEditableFeature(DefaultFeatureStore store, FeatureProvider data) {
        super(store, data);
        this.source = null;
        this.modified = false;
    }

    public Feature getSource() {
        return this.source;
    }

    public boolean isUpdatable() {
        return super.isInserted();
    }

    public void setUpdatable(boolean updatable) {
        super.setInserted(updatable);
    }

    @Override
    public EditableFeature getEditable() {
        return this;
    }

    @Override
    public Feature getCopy() {
        return new DefaultEditableFeature(this);
    }

    public Feature getNotEditableCopy() {
        return new DefaultFeature(this);
    }

    public void setDefaultGeometry(Geometry geometry) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(this.getType().getDefaultGeometryAttributeIndex());
        this.modified = true;
        this.set(attribute, (Object)geometry);
    }

    public void __setitem__(String name, Object value) {
        this.set(name, value);
    }

    public void set(String name, Object value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, value);
    }

    public void set(int index, Object value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, value);
    }

    public void setArray(String name, Object[] value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setArray(int index, Object[] value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setBoolean(String name, boolean value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setBoolean(int index, boolean value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setByte(String name, byte value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setByte(int index, byte value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setDate(String name, java.util.Date value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setDate(int index, java.util.Date value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setDouble(String name, double value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setDouble(int index, double value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setDecimal(String name, BigDecimal value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setDecimal(int index, BigDecimal value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setFeature(String name, Feature value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setFeature(int index, Feature value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setFloat(String name, float value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)Float.valueOf(value));
    }

    public void setFloat(int index, float value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)Float.valueOf(value));
    }

    public void setGeometry(String name, Geometry value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setGeometry(int index, Geometry value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setInt(String name, int value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setInt(int index, int value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setLong(String name, long value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setLong(int index, long value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setString(String name, String value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setString(int index, String value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void copyFrom(JsonObject values) {
        this.copyFrom(values, null);
    }

    private String getJSonKey(JsonObject json, String key) {
        if (json.containsKey((Object)key)) {
            return key;
        }
        for (String jkey : json.keySet()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)jkey, (CharSequence)key)) continue;
            return jkey;
        }
        return key;
    }

    private JsonValue getJSonValue0(JsonObject json, String key) {
        String jkey = this.getJSonKey(json, key);
        JsonValue v = (JsonValue)json.get((Object)jkey);
        return v;
    }

    private JsonValue getJSonValue(JsonObject json, String key) {
        JsonValue v = (JsonValue)json.get((Object)key);
        if (v != null) {
            return v;
        }
        if (key != null) {
            for (Map.Entry entry : json.entrySet()) {
                if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
                return (JsonValue)entry.getValue();
            }
        }
        return null;
    }

    public void copyFrom(JsonObject values, Predicate<FeatureAttributeDescriptor> filter) {
        if (values == null) {
            throw new IllegalArgumentException("'values' argument can't be null");
        }
        boolean geometryCopied = false;
        for (FeatureAttributeDescriptor attr : this.getType()) {
            Object value;
            String attrname;
            JsonValue jsonValue;
            if (!this.canSetValue(attr, filter) || (jsonValue = this.getJSonValue(values, attrname = attr.getName())) == null) continue;
            try {
                block6 : switch (jsonValue.getValueType()) {
                    case STRING: {
                        String s = ((JsonString)jsonValue).getString();
                        switch (attr.getType()) {
                            case 66: {
                                value = GeometryUtils.createFrom((String)s);
                                geometryCopied = true;
                                break block6;
                            }
                            case 11: {
                                Comparable<ChronoLocalDateTime<?>> date;
                                TemporalAccessor x;
                                try {
                                    x = DateTimeFormatter.ISO_DATE_TIME.parse(s);
                                    date = LocalDateTime.from(x);
                                    value = Timestamp.valueOf(date);
                                }
                                catch (Exception ex) {
                                    value = s;
                                }
                                break block6;
                            }
                            case 9: {
                                Comparable<ChronoLocalDateTime<?>> date;
                                TemporalAccessor x;
                                try {
                                    x = DateTimeFormatter.ISO_DATE.parse(s);
                                    date = LocalDate.from(x);
                                    value = Date.valueOf((LocalDate)date);
                                }
                                catch (Exception ex) {
                                    value = s;
                                }
                                break block6;
                            }
                            case 10: {
                                Comparable<ChronoLocalDateTime<?>> date;
                                TemporalAccessor x;
                                try {
                                    x = DateTimeFormatter.ISO_TIME.parse(s);
                                    date = LocalTime.from(x);
                                    value = Time.valueOf((LocalTime)date);
                                }
                                catch (Exception ex) {
                                    value = s;
                                }
                                break block6;
                            }
                            case 12: {
                                value = DataTypeUtils.coerce((int)12, (Object)s, null);
                                break block6;
                            }
                        }
                        value = s;
                        break;
                    }
                    case NUMBER: {
                        JsonNumber n = (JsonNumber)jsonValue;
                        switch (attr.getType()) {
                            case 19: {
                                value = n.bigDecimalValue();
                                break block6;
                            }
                            case 2: {
                                value = n.bigDecimalValue();
                                break block6;
                            }
                            case 6: 
                            case 7: {
                                value = n.doubleValue();
                                break block6;
                            }
                            case 4: {
                                value = n.intValue();
                                break block6;
                            }
                            case 5: {
                                value = n.longValue();
                                break block6;
                            }
                        }
                        value = n.toString();
                        break;
                    }
                    case TRUE: {
                        value = true;
                        break;
                    }
                    case FALSE: {
                        value = false;
                        break;
                    }
                    case NULL: {
                        value = null;
                        break;
                    }
                    default: {
                        value = values.getString(attrname);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                continue;
            }
            if (value == null && !attr.allowNull()) continue;
            try {
                this.set(attr.getIndex(), value);
            }
            catch (Throwable th) {
                LOG.trace("Can't assign value " + Objects.toString(value, null) + " to " + attr.getName());
            }
        }
        FeatureAttributeDescriptor attr = this.getType().getDefaultGeometryAttribute();
        if (attr != null && !geometryCopied && (filter == null || filter.test(attr))) {
            GeometryType geomType = this.getType().getDefaultGeometryAttribute().getGeomType();
            Set keys = values.keySet();
            for (String key : keys) {
                try {
                    String wkt = values.getString(key);
                    Geometry geometry = GeometryUtils.createFrom((String)wkt);
                    if (!GeometryUtils.isSubtype((int)geomType.getType(), (int)geometry.getType()) && !GeometryUtils.canAggregate((int)geomType.getType(), (int)geometry.getType())) continue;
                    this.setDefaultGeometry(geometry);
                    break;
                }
                catch (Throwable tr) {
                    LOG.trace("Can't get geometry from field {}.", new Object[]{key});
                }
            }
        }
    }

    public void copyFrom(Feature source) {
        this.copyFrom(source, null, null);
    }

    public void copyFrom(Feature source, Predicate<FeatureAttributeDescriptor> copy) {
        this.copyFrom(source, copy, null);
    }

    public void copyFrom(Feature source, Predicate<FeatureAttributeDescriptor> copy, Invocable onerror) {
        if (source == null) {
            throw new IllegalArgumentException("'source' argument can't be null");
        }
        FeatureType sourceType = source.getType();
        for (FeatureAttributeDescriptor attrTarget : this.getType()) {
            Object value;
            String attrname;
            FeatureAttributeDescriptor attrSource;
            if (!this.canSetValue(attrTarget, copy) || (attrSource = sourceType.getAttributeDescriptorFromAll(attrname = attrTarget.getName())) == null) continue;
            if (attrSource.hasDataProfile()) {
                value = source.getFromProfile(attrname);
                if (value == null) {
                    value = source.get(attrname);
                }
            } else {
                value = source.get(attrname);
            }
            if (value == null && !attrTarget.allowNull()) {
                if (onerror == null) continue;
                onerror.call(new Object[]{"Can't assign null to field '" + attrname + "'.", null});
                continue;
            }
            try {
                this.set(attrTarget.getIndex(), value);
            }
            catch (Throwable th) {
                if (onerror == null) {
                    LOG.trace("The exception thrown is: ", th);
                    continue;
                }
                String s = null;
                try {
                    s = StringUtils.replace((String)BaseException.getMessageStack((Throwable)th, (int)0), (String)"\n", (String)" ");
                }
                catch (Throwable th2) {
                    LOG.trace("The exception thrown is: ", th);
                }
                onerror.call(new Object[]{s, th});
            }
        }
    }

    public void setInstant(String name, Instant value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setInstant(int index, Instant value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setInterval(String name, Interval value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(name);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + name + "' does not exits in the feature.");
        }
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    public void setInterval(int index, Interval value) {
        FeatureAttributeDescriptor attribute = this.getType().getAttributeDescriptor(index);
        this.modified = true;
        this.set(attribute, (Object)value);
    }

    @Override
    public Object getExtraValue(String name) {
        FeatureExtraColumns columns = this.getType().getExtraColumns();
        int index = columns.getIndexOf(name);
        if (index >= 0) {
            EditableFeatureAttributeDescriptor attrdesc = columns.get(index);
            Object value = attrdesc.getFeatureAttributeEmulator().get((Feature)this);
            return value;
        }
        Object value = this.data.getExtraValue(name);
        return value;
    }

    @Override
    public void validate(int check) throws DataException {
        ((DefaultFeatureType)this.data.getType()).validateFeature(this, check);
    }

    public boolean isModified() {
        return this.modified;
    }

    public Feature getOriginal() {
        FeatureStore store = this.getStore();
        if (store == null) {
            return null;
        }
        Feature original = store.getOriginalFeature((Feature)this);
        return original;
    }
}

