/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureReferenceIterator;
import org.gvsig.fmap.dal.feature.FeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureSelectionHelper;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.FeatureSelectionHelper;
import org.gvsig.fmap.dal.feature.impl.undo.FeatureCommandsStack;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.WeakReferencingObservable;
import org.gvsig.tools.observer.impl.DelegateWeakReferencingObservable;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureReferenceSelection
extends AbstractDisposable
implements FeatureReferenceSelection {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultFeatureReferenceSelection.class);
    public static final String DYNCLASS_PERSISTENT_NAME = "DefaultFeatureReferenceSelection";
    private Boolean available = null;
    protected SelectionData selectionData = null;
    private FeatureStore featureStore;
    private FeatureSelectionHelper helper;
    private DelegateWeakReferencingObservable delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)this);

    public DefaultFeatureReferenceSelection(DefaultFeatureStore featureStore) throws DataException {
        this.featureStore = featureStore;
        this.helper = new DefaultFeatureSelectionHelper(featureStore);
    }

    public DefaultFeatureReferenceSelection(FeatureStore featureStore, FeatureSelectionHelper helper) throws DataException {
        this.featureStore = featureStore;
        this.helper = helper;
    }

    public DefaultFeatureReferenceSelection() {
    }

    public boolean select(FeatureReference reference) {
        return this.select(reference, true);
    }

    public boolean select(FeatureReference reference, boolean undoable) {
        boolean change;
        if (reference == null) {
            throw new IllegalArgumentException("reference");
        }
        if (this.isSelected(reference)) {
            return false;
        }
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().select(this, reference);
        }
        if (change = this.getData().isReversed() ? this.getData().remove(reference) : this.getData().add(reference)) {
            this.notifyObservers("after_SelectionChange_DataStore");
        }
        return change;
    }

    public boolean deselect(FeatureReference reference) {
        return this.deselect(reference, true);
    }

    public boolean deselect(FeatureReference reference, boolean undoable) {
        boolean change;
        if (!this.isSelected(reference)) {
            return false;
        }
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().deselect(this, reference);
        }
        if (change = this.getData().isReversed() ? this.getData().add(reference) : this.getData().remove(reference)) {
            this.notifyObservers("after_SelectionChange_DataStore");
        }
        return change;
    }

    public void selectAll() throws DataException {
        this.selectAll(true);
    }

    public void selectAll(boolean undoable) throws DataException {
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().startComplex("_selectionSelectAll");
            this.getCommands().selectAll(this);
        }
        if (!this.getData().isReversed()) {
            this.getData().setReversed(true);
        }
        this.clearFeatureReferences();
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().endComplex();
        }
        this.notifyObservers("after_SelectionChange_DataStore");
    }

    public void deselectAll() throws DataException {
        this.deselectAll(false);
    }

    public void deselectAll(boolean undoable) throws DataException {
        if (this.selectionData == null) {
            return;
        }
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().startComplex("_selectionDeselectAll");
            this.getCommands().deselectAll(this);
        }
        if (this.getData().isReversed()) {
            this.getData().setReversed(false);
        }
        this.clearFeatureReferences();
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().endComplex();
        }
        this.notifyObservers("after_SelectionChange_DataStore");
    }

    public boolean isSelected(FeatureReference reference) {
        if (this.selectionData == null) {
            return false;
        }
        if (this.getData().isReversed()) {
            return !this.getData().contains(reference);
        }
        return this.getData().contains(reference);
    }

    public void reverse() {
        this.reverse(true);
    }

    public void reverse(boolean undoable) {
        if (undoable && this.getFeatureStore().isEditing()) {
            this.getCommands().selectionReverse(this);
        }
        this.getData().setReversed(!this.getData().isReversed());
        this.notifyObservers("after_SelectionChange_DataStore");
    }

    public boolean isEmpty() {
        if (this.selectionData == null) {
            return true;
        }
        return this.getSelectedCount() == 0L;
    }

    public long getSelectedCount() {
        if (this.selectionData == null) {
            return 0L;
        }
        if (this.getData().isReversed()) {
            return this.getData().getTotalSize() - (long)this.getData().getSize() + this.helper.getFeatureStoreDeltaSize();
        }
        return this.getData().getSize();
    }

    public FeatureReferenceIterator referenceIterator() {
        final Iterator<FeatureReference> it = this.getData().getSelected().iterator();
        return new FeatureReferenceIterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public FeatureReference next() {
                return (FeatureReference)it.next();
            }
        };
    }

    public Iterable<FeatureReference> referenceIterable() {
        return new Iterable<FeatureReference>(){

            @Override
            public Iterator<FeatureReference> iterator() {
                return DefaultFeatureReferenceSelection.this.referenceIterator();
            }
        };
    }

    protected void doDispose() throws BaseException {
        this.deselectAll(false);
        this.delegateObservable.deleteObservers();
        this.delegateObservable = null;
        this.featureStore = null;
        this.helper = null;
        this.selectionData = null;
        this.available = null;
    }

    public boolean isFromStore(DataStore store) {
        return this.featureStore.equals(store);
    }

    public void accept(Visitor visitor) throws BaseException {
        if (this.selectionData == null) {
            return;
        }
        Iterator<FeatureReference> iter = this.getData().getSelected().iterator();
        while (iter.hasNext()) {
            visitor.visit((Object)iter.next());
        }
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification storeNotif;
        if (notification instanceof FeatureStoreNotification && "after_Delete_Feature".equalsIgnoreCase((storeNotif = (FeatureStoreNotification)notification).getType())) {
            this.getData().remove(storeNotif.getFeature().getReference());
        }
    }

    public SelectionData getData() {
        if (this.selectionData == null) {
            this.selectionData = new SelectionData();
            try {
                this.selectionData.setTotalSize(this.featureStore.getFeatureCount());
            }
            catch (DataException ex) {
                throw new RuntimeException("Can't initialize SelectionData, don't get the feature count.", ex);
            }
        }
        return this.selectionData;
    }

    public void setData(SelectionData selectionData) {
        this.selectionData = selectionData;
        this.notifyObservers("after_SelectionChange_DataStore");
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("featureStore", (Object)this.featureStore, true);
            builder.append("SelectedCount", this.getSelectedCount());
            builder.append("isReversed", this.isReversed());
            builder.append("countObservers", this.delegateObservable.countObservers());
            builder.append("featureIdsContained", this.selectionData == null ? Integer.valueOf(0) : this.selectionData.getSelected());
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected boolean isReversed() {
        if (this.selectionData == null) {
            return false;
        }
        return this.getData().isReversed();
    }

    protected void clearFeatureReferences() {
        if (this.selectionData == null) {
            return;
        }
        this.getData().clear();
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    protected FeatureCommandsStack getCommands() {
        return this.helper.getFeatureStoreCommandsStack();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("store", (Persistent)this.featureStore);
        state.set("reversed", this.getData().isReversed());
        state.set("totalSize", this.getData().getTotalSize());
        state.set("selected", this.getData().getSelected().iterator());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        SelectionData data = new SelectionData();
        this.featureStore = (FeatureStore)state.get("store");
        this.helper = new DefaultFeatureSelectionHelper((DefaultFeatureStore)this.featureStore);
        data.setReversed(state.getBoolean("reversed"));
        data.setTotalSize(state.getLong("totalSize"));
        Iterator it = state.getIterator("selected");
        while (it.hasNext()) {
            FeatureReference ref = (FeatureReference)it.next();
            data.add(ref);
        }
        this.addObserver((DefaultFeatureStore)this.featureStore);
    }

    public static void registerPersistent() {
        DynStruct definition = ToolsLocator.getPersistenceManager().addDefinition(DefaultFeatureReferenceSelection.class, DYNCLASS_PERSISTENT_NAME, "DefaultFeatureReferenceSelection Persistent definition", null, null);
        definition.addDynFieldObject("store").setClassOfValue(FeatureStore.class).setMandatory(true);
        definition.addDynFieldBoolean("reversed").setMandatory(true);
        definition.addDynFieldLong("totalSize").setMandatory(true);
        definition.addDynFieldList("selected").setClassOfItems(FeatureReference.class).setMandatory(true);
    }

    public void addObserver(Observer observer) {
        this.delegateObservable.addObserver(observer);
    }

    public void beginComplexNotification() {
        this.delegateObservable.beginComplexNotification();
    }

    public void deleteObserver(Observer observer) {
        this.delegateObservable.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.delegateObservable.deleteObservers();
    }

    public void disableNotifications() {
        this.delegateObservable.disableNotifications();
    }

    public void enableNotifications() {
        this.delegateObservable.enableNotifications();
    }

    public void endComplexNotification() {
        this.delegateObservable.notifyObservers((Object)"after_SelectionChange_DataStore");
        this.delegateObservable.endComplexNotification();
    }

    public boolean inComplex() {
        return this.delegateObservable.inComplex();
    }

    public boolean isEnabledNotifications() {
        return this.delegateObservable.isEnabledNotifications();
    }

    public void notifyObservers() {
        if (!this.delegateObservable.inComplex()) {
            this.delegateObservable.notifyObservers();
        }
    }

    public void notifyObservers(Object arg) {
        if (!this.delegateObservable.inComplex()) {
            this.delegateObservable.notifyObservers(arg);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            DefaultFeatureReferenceSelection clone = new DefaultFeatureReferenceSelection(this.featureStore, this.helper);
            clone.delegateObservable = new DelegateWeakReferencingObservable((WeakReferencingObservable)clone);
            clone.selectionData = (SelectionData)this.getData().clone();
            return clone;
        }
        catch (Exception ex) {
            CloneNotSupportedException ex2 = new CloneNotSupportedException();
            ex2.initCause(ex);
            throw ex2;
        }
    }

    public boolean isAvailable() {
        if (this.available == null) {
            try {
                FeatureType type = this.featureStore.getDefaultFeatureType();
                this.available = type.supportReferences();
            }
            catch (DataException ex) {
                this.available = false;
            }
        }
        return this.available;
    }

    public static class SelectionData
    implements Cloneable {
        private Set<FeatureReference> selected = new HashSet<FeatureReference>();
        private boolean reversed = false;
        private long totalSize;

        public Set<FeatureReference> getSelected() {
            return this.selected;
        }

        public void setSelected(Set<FeatureReference> selected) {
            this.selected = selected;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean reversed) {
            this.reversed = reversed;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(long totalSize) {
            this.totalSize = totalSize;
        }

        public boolean add(FeatureReference reference) {
            return this.selected.add(reference);
        }

        public boolean remove(FeatureReference reference) {
            return this.selected.remove(reference);
        }

        public void clear() {
            this.selected.clear();
        }

        public boolean contains(FeatureReference reference) {
            return this.selected.contains(reference);
        }

        public int getSize() {
            return this.selected.size();
        }

        public Object clone() throws CloneNotSupportedException {
            SelectionData clone = (SelectionData)super.clone();
            clone.selected = new HashSet<FeatureReference>(this.selected);
            return clone;
        }
    }
}

