/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import java.util.Base64;
import java.util.Iterator;
import javax.json.JsonObject;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureReferenceSelection;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceCounter;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceOID;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferencePK;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferencePersistenceFactory;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferenceUID;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.json.Json;

public class FeatureReferenceFactory {
    private FeatureReferenceFactory() {
    }

    public static FeatureReference createFromFeature(Feature feature) {
        FeatureProvider fdata = ((DefaultFeature)feature).getData();
        FeatureStore store = feature.getStore();
        return FeatureReferenceFactory.createFromFeatureProvider(store, fdata);
    }

    public static FeatureReference createFromOID(FeatureStore store, Object oid) {
        if (FeatureReferenceCounter.canUse(oid)) {
            FeatureReferenceCounter ref = new FeatureReferenceCounter(store, oid);
            return ref;
        }
        FeatureReferenceOID ref = new FeatureReferenceOID(store, oid);
        return ref;
    }

    public static FeatureReference createFromCode(FeatureStore store, String code) {
        String type;
        String json = new String(Base64.getDecoder().decode(code.getBytes()));
        JsonObject x = Json.createObject((String)json);
        switch (type = x.getString("type", null)) {
            case "oid": {
                return new FeatureReferenceOID(store, x);
            }
            case "counter": {
                return new FeatureReferenceCounter(store, x);
            }
            case "uid": {
                return new FeatureReferenceUID(store, x);
            }
            case "pk": {
                return new FeatureReferencePK(store, x);
            }
        }
        throw new IllegalArgumentException("Unsupported feature reference type" + type);
    }

    public static FeatureReference createReferencePKFromFeature(Feature feature) {
        FeatureProvider fdata = ((DefaultFeature)feature).getData();
        FeatureStore store = feature.getStore();
        return new FeatureReferencePK(store, fdata);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FeatureReference createFromFeatureProvider(FeatureStore store, FeatureProvider fdata) {
        void var2_6;
        Object var2_2 = null;
        boolean isNewFeature = fdata.isNew();
        if (isNewFeature) {
            FeatureReferenceCounter featureReferenceCounter = new FeatureReferenceCounter(store);
            return var2_6;
        } else if (fdata.getType().hasOID()) {
            if (fdata.getOID() == null) throw new RuntimeException("Missing OID");
            FeatureReferenceOID featureReferenceOID = new FeatureReferenceOID(store, fdata.getOID());
            return var2_6;
        } else {
            FeatureReferencePK featureReferencePK = new FeatureReferencePK(store, fdata);
        }
        return var2_6;
    }

    public static FeatureReferenceSelection createSelection(FeatureStore store, Iterator pks) {
        try {
            DefaultFeatureReferenceSelection selection = new DefaultFeatureReferenceSelection((DefaultFeatureStore)store);
            while (pks.hasNext()) {
                Object pkvalue = pks.next();
                FeatureReferencePK fr = new FeatureReferencePK(store, pkvalue);
                selection.select((FeatureReference)fr);
            }
            return selection;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create selection for '" + store.getFullName() + "' from  pks", ex);
        }
    }

    public static void registerPersistent() {
        FeatureReferencePersistenceFactory.selfRegister();
    }
}

