/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featurereference;

import java.util.Collections;
import java.util.Iterator;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DataServerExplorer_v2;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.impl.featurereference.FeatureReferencePK;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.util.ChainedIterator;

public class FeatureReferenceIteratorToFeatureIterator
implements DisposableIterator<Feature> {
    private Iterator<FeatureReference> references;
    private Iterator<Feature> it;
    private final FeatureStore store;
    private int maxRecomendedSQLLength;
    private int count = 0;
    private int maxcount;

    public FeatureReferenceIteratorToFeatureIterator(FeatureStore store, Iterator<FeatureReference> references) {
        this.store = store;
        this.references = references;
        this.it = null;
        try {
            SQLBuilder sqlbuilder = ((DataServerExplorer_v2)this.store.getExplorer()).createSQLBuilder();
            this.maxRecomendedSQLLength = sqlbuilder.getMaxRecomendedSQLLength() - 200;
        }
        catch (Exception ex) {
            this.maxRecomendedSQLLength = 1848;
        }
        this.maxcount = this.maxRecomendedSQLLength / 50;
    }

    public boolean hasNext() {
        if (this.it != null && this.it.hasNext()) {
            return true;
        }
        this.it = this.getNextPage();
        return this.it.hasNext();
    }

    public Feature next() {
        if (this.it != null) {
            return this.it.next();
        }
        this.it = this.getNextPage();
        return this.it.next();
    }

    private Iterator<Feature> getNextPage() {
        try {
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            int count = 0;
            while (this.references.hasNext()) {
                String filter;
                FeatureReferenceProviderServices reference = (FeatureReferenceProviderServices)this.references.next();
                ++this.count;
                if (reference == null) continue;
                if (reference instanceof FeatureReferencePK) {
                    builder.or(this.getReferenceFilter(reference));
                    if (this.references.hasNext() && ++count <= this.maxcount || (filter = builder.build()) == null) continue;
                    FeatureSet set = this.store.getFeatureSet(filter);
                    if (set instanceof DefaultFeatureSet) {
                        ((DefaultFeatureSet)set).setIgnoreConcurrentChanges(true);
                    }
                    return set.fastIterator();
                }
                filter = builder.build();
                Feature feature = reference.getFeature();
                if (filter != null) {
                    FeatureSet set = this.store.getFeatureSet(filter);
                    if (feature == null) {
                        return set.fastIterator();
                    }
                    return new ChainedIterator(new Iterator[]{set.fastIterator(), Collections.singleton(feature).iterator()});
                }
                if (feature == null) continue;
                return Collections.singleton(feature).iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't get next page of iterator", ex);
        }
    }

    private ExpressionBuilder.Value getReferenceFilter(FeatureReferenceProviderServices reference) {
        String[] primaryKeys;
        ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
        for (String name : primaryKeys = reference.getKeyNames()) {
            Object value = reference.getKeyValue(name);
            if (value == null) {
                builder.and((ExpressionBuilder.Value)builder.is_null((ExpressionBuilder.Value)builder.column(name)));
                continue;
            }
            builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(name), (ExpressionBuilder.Value)builder.constant(value)));
        }
        return builder.value();
    }

    public void dispose() {
    }
}

