/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.featureset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeature;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultFeatureSet;
import org.gvsig.fmap.dal.feature.impl.featureset.DefaultIterator;
import org.gvsig.fmap.dal.feature.impl.featureset.FeatureProviderComparator;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.exception.BaseException;

public class FastOrderedIterator
extends DefaultIterator {
    DefaultFeature myFeature;
    protected Feature lastFeature = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FastOrderedIterator(DefaultFeatureSet featureSet, Iterator iterator, long index) {
        super(featureSet);
        try {
            this.initializeFeature();
            if (featureSet.orderedData == null) {
                ArrayList<FeatureProvider> data = new ArrayList<FeatureProvider>();
                while (iterator.hasNext()) {
                    Object item = iterator.next();
                    if (item instanceof DefaultFeature) {
                        data.add(((DefaultFeature)item).getData().getCopy());
                        continue;
                    }
                    data.add(((FeatureProvider)item).getCopy());
                }
                Collections.sort(data, new FeatureProviderComparator(featureSet.store, featureSet.query.getOrder()));
                featureSet.orderedData = data;
            }
            if (index < Integer.MAX_VALUE) {
                this.iterator = featureSet.orderedData.listIterator((int)index);
            } else {
                this.iterator = featureSet.orderedData.iterator();
                this.skypto(index);
            }
        }
        finally {
            if (iterator instanceof DisposableIterator) {
                ((DisposableIterator)iterator).dispose();
            }
        }
    }

    public FastOrderedIterator(DefaultFeatureSet featureSet, long index) {
        super(featureSet);
        this.initializeFeature();
        if (index < Integer.MAX_VALUE) {
            this.iterator = featureSet.orderedData.listIterator((int)index);
        } else {
            this.iterator = featureSet.orderedData.iterator();
            this.skypto(index);
        }
    }

    @Override
    protected DefaultFeature createFeature(FeatureProvider fData) {
        fData.setNew(false);
        this.myFeature.setData(fData);
        return this.myFeature;
    }

    protected void initializeFeature() {
        this.myFeature = new DefaultFeature(this.fset.store);
    }

    @Override
    public Object next() {
        this.lastFeature = null;
        this.lastFeature = (Feature)super.next();
        return this.lastFeature;
    }

    @Override
    public void remove() {
        if (!this.fset.store.isEditing()) {
            throw new UnsupportedOperationException();
        }
        if (this.lastFeature == null) {
            throw new IllegalStateException();
        }
        try {
            this.fset.store.delete(this.lastFeature);
        }
        catch (DataException e) {
            throw new RuntimeException(e);
        }
        this.iterator.remove();
        this.initializeFeature();
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.myFeature = null;
        this.lastFeature = null;
    }
}

