/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.impl.undo.command;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.impl.DefaultFeatureStore;
import org.gvsig.fmap.dal.feature.impl.undo.command.AbstractFeatureCommand;
import org.gvsig.tools.undo.UndoException;
import org.gvsig.tools.undo.UndoRedoInfo;

public class FeatureUpdateCommand
extends AbstractFeatureCommand {
    private final Feature oldFeature;

    public FeatureUpdateCommand(DefaultFeatureStore featureStore, EditableFeature feature, Feature oldFeature, String description) {
        super(featureStore, (Feature)feature, description);
        this.oldFeature = oldFeature;
    }

    public EditableFeature getFeature() {
        return (EditableFeature)this.feature;
    }

    public void undo() throws UndoException {
        try {
            this.featureStore.doUpdate(this.oldFeature.getEditable(), this.getFeature().getNotEditableCopy());
        }
        catch (DataException e) {
            throw new UndoException((UndoRedoInfo)this, (Throwable)e);
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void execute() throws DataException {
        this.featureStore.doUpdate(this.getFeature(), this.oldFeature);
    }

    public Feature getOldFeature() {
        return this.oldFeature;
    }
}

