/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.raster.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.raster.BandAttributeDescriptor;
import org.gvsig.fmap.dal.raster.BandDescriptor;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.dal.raster.spi.BandDescriptorServices;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProviderServices;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultBandDescriptor
extends AbstractDisposable
implements BandDescriptorServices {
    private static final String PERSISTENCE_NAME = "BandDescriptor";
    private static final String PERSISTENCE_DESCRIPTION = "";
    private static final String BAND_FIELD_NAME = "band";
    private static final String BAND_ATTRIBUTE_DESCRIPTORS_FIELD_NAME = "bandAttributeDescriptors";
    private List<BandAttributeDescriptor> bandAttributeDescriptors;
    private int band;
    private RasterStore store;
    private NoData noData;
    private int dataType;
    private String name;
    private String description;

    public DefaultBandDescriptor(RasterStore store, int band, List<BandAttributeDescriptor> attributeDescriptors) {
        this.band = band;
        this.bandAttributeDescriptors = attributeDescriptors;
        this.noData = null;
        this.store = store;
        this.name = String.valueOf(this.band);
        this.description = PERSISTENCE_DESCRIPTION;
    }

    public int getBand() {
        return this.band;
    }

    public BandAttributeDescriptor get(int index) {
        if (index >= 0 && index < this.bandAttributeDescriptors.size()) {
            return this.bandAttributeDescriptors.get(index);
        }
        return null;
    }

    public BandAttributeDescriptor get(String name) {
        for (BandAttributeDescriptor bandAttributeDescriptor : this.bandAttributeDescriptors) {
            if (!bandAttributeDescriptor.getName().equals(name)) continue;
            return bandAttributeDescriptor;
        }
        return null;
    }

    public int size() {
        return this.bandAttributeDescriptors.size();
    }

    public Iterator<BandAttributeDescriptor> iterator() {
        return this.bandAttributeDescriptors.iterator();
    }

    public static void registerPersitenceDefinition() {
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        DynStruct definition = persistenceManager.getDefinition(PERSISTENCE_NAME);
        if (definition == null) {
            definition = persistenceManager.addDefinition(BandDescriptor.class, PERSISTENCE_NAME, PERSISTENCE_DESCRIPTION, null, null);
            definition.addDynFieldInt(BAND_FIELD_NAME);
            definition.addDynFieldList(BAND_ATTRIBUTE_DESCRIPTORS_FIELD_NAME).setClassOfItems(BandAttributeDescriptor.class);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(BAND_FIELD_NAME, this.getBand());
        state.set(BAND_ATTRIBUTE_DESCRIPTORS_FIELD_NAME, this.bandAttributeDescriptors);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.band = state.getInt(BAND_FIELD_NAME);
        this.bandAttributeDescriptors = new ArrayList<BandAttributeDescriptor>(state.getList(BAND_ATTRIBUTE_DESCRIPTORS_FIELD_NAME));
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultBandDescriptor newBandDescriptor = (DefaultBandDescriptor)((Object)super.clone());
        newBandDescriptor.bandAttributeDescriptors = new ArrayList<BandAttributeDescriptor>();
        for (BandAttributeDescriptor bandAttributeDescriptor : this.bandAttributeDescriptors) {
            newBandDescriptor.bandAttributeDescriptors.add((BandAttributeDescriptor)bandAttributeDescriptor.clone());
        }
        return newBandDescriptor;
    }

    public RasterStore getStore() {
        return this.store;
    }

    public NoData getNoData() {
        return this.noData;
    }

    public void setNoData(NoData noData) {
        this.noData = noData;
    }

    protected void doDispose() throws BaseException {
        this.store = null;
        this.bandAttributeDescriptors = null;
        this.noData = null;
    }

    public BandAttributeDescriptor add(BandAttributeDescriptor bandAttributeDescriptor) {
        this.bandAttributeDescriptors.add(bandAttributeDescriptor);
        return bandAttributeDescriptor;
    }

    public BandAttributeDescriptor add(String name, Object value) {
        BandAttributeDescriptor x = ((RasterStoreProviderServices)this.store).createBandAttributeDescriptor(this.band, name, value, null, null, null);
        return x;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

