/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dispose;

import java.util.Collection;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableInfo;
import org.gvsig.tools.dispose.DisposableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisposeUtils {
    private static final Logger logger = LoggerFactory.getLogger(DisposeUtils.class);

    public static void dispose(Disposable disposable) {
        if (disposable != null) {
            disposable.dispose();
        }
    }

    public static void dispose(Object obj) {
        if (obj instanceof Disposable) {
            ((Disposable)obj).dispose();
        }
    }

    public static void disposeQuietly(Disposable disposable) {
        if (disposable != null) {
            try {
                disposable.dispose();
            }
            catch (Throwable th) {
                logger.warn("Can't dispose", th);
            }
        }
    }

    public static void disposeQuietly(Object obj) {
        if (obj instanceof Disposable) {
            try {
                ((Disposable)obj).dispose();
            }
            catch (Throwable th) {
                logger.warn("Can't dispose", th);
            }
        }
    }

    public static void bind(Disposable disposable) {
        if (disposable == null) {
            return;
        }
        DisposableManager manager = ToolsLocator.getDisposableManager();
        if (manager == null) {
            logger.warn("Can't retrieve the disposable manager,");
            return;
        }
        manager.bind(disposable);
    }

    public static void bind(Collection list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        DisposableManager manager = ToolsLocator.getDisposableManager();
        if (manager == null) {
            logger.warn("Can't retrieve the disposable manager,");
            return;
        }
        for (Object object : list) {
            if (!(object instanceof Disposable)) continue;
            manager.bind((Disposable)object);
        }
    }

    public static void bind(Object obj) {
        if (obj instanceof Disposable) {
            DisposableManager manager = ToolsLocator.getDisposableManager();
            if (manager == null) {
                logger.warn("Can't retrieve the disposable manager,");
                return;
            }
            manager.bind((Disposable)obj);
        }
    }

    public static boolean release(Disposable disposable) {
        return ToolsLocator.getDisposableManager().release(disposable);
    }

    public static DisposableInfo getDisposableInfo(Disposable disposable) {
        return ToolsLocator.getDisposableManager().getDisposableInfo(disposable);
    }

    public static DisposableInfo getDisposableInfo(int code) {
        DisposableManager manager = ToolsLocator.getDisposableManager();
        for (DisposableInfo disposableInfo : manager.getBoundDisposables()) {
            Disposable d;
            if (disposableInfo == null || (d = disposableInfo.getDisposable()) == null) continue;
            int dcode = -1;
            try {
                dcode = d.hashCode();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (code != dcode) continue;
            return disposableInfo;
        }
        return null;
    }

    public static int getReferences(Disposable disposable) {
        DisposableInfo info = ToolsLocator.getDisposableManager().getDisposableInfo(disposable);
        if (info == null) {
            return 0;
        }
        return info.getReferencesCount();
    }

    public static boolean isNullOrDisposed(Disposable disposable) {
        if (disposable == null) {
            return true;
        }
        DisposableInfo info = ToolsLocator.getDisposableManager().getDisposableInfo(disposable);
        return info == null;
    }
}

