/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.packageutils.impl;

import java.text.MessageFormat;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.Version;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseRuntimeException;
import org.gvsig.tools.packageutils.Dependency;
import org.gvsig.tools.packageutils.StringWithAlias;

public class DefaultDependency
implements Dependency {
    protected String type;
    protected String code;
    protected String op;
    protected Version version;

    public DefaultDependency() {
        this.clear();
    }

    public DefaultDependency(PackageInfo packageInfo) {
        this();
        this.fromPackageInfo(packageInfo);
    }

    public void fromPackageInfo(PackageInfo packageInfo) {
        this.clear();
        this.code = packageInfo.getCode();
        this.type = "required";
        this.op = ">=";
        this.version = packageInfo.getVersion();
    }

    public void clear() {
        this.type = "required";
        this.code = "unknow";
        this.op = "=";
        this.version = ToolsLocator.getPackageManager().createVersion();
    }

    @Override
    public org.gvsig.installer.lib.api.Dependency parse(String dependency) {
        if (dependency == null) {
            this.clear();
            return this;
        }
        if ((dependency = dependency.trim()).equals("")) {
            this.clear();
            return this;
        }
        String s = dependency;
        s = s.replace('\n', ' ');
        s = s.replace('\t', ' ');
        s = s.replace('\r', ' ');
        s = s.replace(':', ' ');
        while (s.indexOf("  ") != -1) {
            s = s.replaceAll("  ", " ");
        }
        String[] x = s.split(" ");
        if (x.length != 4) {
            throw new InvalidDependencyFormatException(dependency);
        }
        this.type = x[0];
        this.code = x[1];
        this.op = x[2];
        this.version.parse(x[3]);
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getOp() {
        return this.op;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean match(String type, String code, Version version) {
        if (!this.type.equalsIgnoreCase(type)) {
            return false;
        }
        if (!this.code.equalsIgnoreCase(code)) {
            return false;
        }
        return version.check(this.op, this.version);
    }

    @Override
    public boolean match(String type, StringWithAlias code, Version version) {
        if (!this.type.equalsIgnoreCase(type)) {
            return false;
        }
        if (!code.equalsIgnoreCase(this.code)) {
            return false;
        }
        return version.check(this.op, this.version);
    }

    public String toString() {
        return MessageFormat.format("{0}: {1} {2} {3}", this.type, this.code, this.op, this.version.toString());
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultDependency x = (DefaultDependency)super.clone();
        x.version = (Version)this.version.clone();
        return x;
    }

    public boolean equals(Object obj) {
        Dependency other;
        try {
            other = (Dependency)obj;
        }
        catch (Exception ex) {
            return false;
        }
        if (!this.code.equalsIgnoreCase(other.getCode())) {
            return false;
        }
        if (!this.type.equalsIgnoreCase(other.getType())) {
            return false;
        }
        if (!this.op.equalsIgnoreCase(other.getOp())) {
            return false;
        }
        return this.version.equals(other.getVersion());
    }

    public int hashCode() {
        return this.version.hashCode() + this.code.hashCode() + this.type.hashCode() + this.op.hashCode();
    }

    private class InvalidDependencyFormatException
    extends BaseRuntimeException {
        private static final long serialVersionUID = 2856837862117653856L;
        private static final String message = "Error parsing dependecy '%(dependency)s'";
        private static final String KEY = "_Error_parsing_dependecy_XdependecyX";

        public InvalidDependencyFormatException(String dependency) {
            super(message, null, KEY, 2856837862117653856L);
            this.setValue("dependency", dependency);
        }
    }
}

