/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTools {
    private static Logger logger = LoggerFactory.getLogger(FileTools.class);

    public static File relativizeFile(File rootFolder, File file) {
        if (rootFolder == null) {
            return file;
        }
        if (file == null) {
            return null;
        }
        boolean isDir = false;
        isDir = rootFolder.isDirectory();
        String basePath = rootFolder.getAbsolutePath();
        if (basePath == null) {
            logger.warn("Can't get absolute path, no relativize file '" + rootFolder.toString() + "'.");
            return file;
        }
        String targetPath = FilenameUtils.normalize((String)file.getPath());
        if (targetPath == null) {
            logger.warn("Can't normalize path, no relativize file '" + file.getAbsolutePath() + "'.");
            return file;
        }
        String pathSeparator = File.separator;
        String pathSeparatorQuoted = FileTools.Pattern_quote(pathSeparator);
        String[] base = basePath.split(pathSeparatorQuoted, -1);
        String[] target = targetPath.split(pathSeparatorQuoted, 0);
        String common = "";
        int commonIndex = 0;
        for (int i = 0; i < target.length && i < base.length && target[i].equals(base[i]); ++i) {
            common = common + target[i] + pathSeparator;
            ++commonIndex;
        }
        if (commonIndex == 0) {
            return file;
        }
        String relative = "";
        if (base.length == commonIndex) {
            relative = "." + pathSeparator;
        } else {
            int numDirsUp = base.length - commonIndex - (isDir ? 0 : 1);
            for (int i = 1; i <= numDirsUp; ++i) {
                relative = relative + ".." + pathSeparator;
            }
        }
        if (targetPath.length() > common.length()) {
            relative = relative + targetPath.substring(common.length());
        }
        return new File(relative);
    }

    public static File derelativizeFile(File rootFolder, File file) {
        if (rootFolder == null || file == null) {
            return file;
        }
        if (file.isAbsolute()) {
            return file;
        }
        File f = new File(rootFolder, file.getPath()).getAbsoluteFile();
        String targetPath = FilenameUtils.normalize((String)f.getPath());
        return new File(targetPath);
    }

    public static boolean isInDifferentDrive(File rootFolder, File file) {
        if (rootFolder == null) {
            return false;
        }
        if (file == null) {
            return false;
        }
        String basePath = rootFolder.getAbsolutePath();
        String targetPath = file.getPath();
        String pathSeparator = File.separator;
        String[] base = basePath.split(FileTools.Pattern_quote(pathSeparator), -1);
        String[] target = targetPath.split(FileTools.Pattern_quote(pathSeparator), 0);
        return !target[0].equals(base[0]);
    }

    private static String Pattern_quote(String str) {
        int eInd = str.indexOf("\\E");
        if (eInd < 0) {
            return "\\Q" + str + "\\E";
        }
        StringBuffer sb = new StringBuffer(str.length() + 16);
        sb.append("\\Q");
        int pos = 0;
        do {
            sb.append(str.substring(pos, eInd)).append("\\E\\\\E\\Q");
        } while ((eInd = str.indexOf("\\E", pos = eInd + 2)) >= 0);
        sb.append(str.substring(pos, str.length())).append("\\E");
        return sb.toString();
    }
}

