/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.fmap.dal.spi.DataTransactionServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCDriverClassNotFoundException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.AbstractConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.ConnectionProvider;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCHelperBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolver;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolverDumb;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.sqlite.dal.SQLiteConnectionParameters;
import org.gvsig.sqlite.dal.SQLiteExplorer;
import org.gvsig.sqlite.dal.SQLiteExplorerParameters;
import org.gvsig.sqlite.dal.SQLiteJDBCConnection;
import org.gvsig.sqlite.dal.SQLiteNewStoreParameters;
import org.gvsig.sqlite.dal.SQLiteSQLBuilder;
import org.gvsig.sqlite.dal.SQLiteStoreParameters;
import org.gvsig.sqlite.dal.SQLiteUtils;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.gvsig.sqlite.dal.operations.SQLiteOperationsFactory;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteConnection;
import org.sqlite.SQLiteOpenMode;

public class SQLiteHelper
extends JDBCHelperBase {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SQLiteHelper.class);
    private ConnectionProvider connectionProvider = null;
    private GeopackageGeometryParser geometryParser = null;

    public SQLiteHelper(JDBCConnectionParameters connectionParameters, ConnectionProvider connectionProvider) {
        super(connectionParameters);
        this.srssolver = new SRSSolverDumb((JDBCHelper)this);
        this.connectionProvider = connectionProvider;
    }

    public SQLiteHelper(JDBCConnectionParameters connectionParameters) {
        super(connectionParameters);
        this.srssolver = null;
    }

    public synchronized JDBCConnection getConnection() throws AccessResourceException {
        try {
            SQLiteConnectionParameters connectionParameters = this.getConnectionParameters();
            JDBCConnection conn = (JDBCConnection)DataTransactionServices.getConnection((DataTransactionServices)this.getTransaction(), (String)this.getConnectionProviderKey(connectionParameters));
            if (conn != null) {
                return conn;
            }
            if (this.connectionProvider == null) {
                if (connectionParameters == null) {
                    return null;
                }
                this.connectionProvider = new ConnectionProviderImpl(connectionParameters);
            }
            JDBCConnection connection = SQLiteJDBCConnection.create(this);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[" + JDBCUtils.getConnId((Connection)connection.get()) + "] getConnection " + this.connectionProvider.getStatus() + " " + this.connectionProvider.toString());
            }
            return connection;
        }
        catch (SQLException ex) {
            throw new AccessResourceException("SQLite", (Throwable)ex);
        }
    }

    public ConnectionProvider getConnectionProvider() {
        if (this.connectionProvider == null) {
            SQLiteConnectionParameters connectionParameters = this.getConnectionParameters();
            if (connectionParameters == null) {
                return null;
            }
            this.connectionProvider = new ConnectionProviderImpl(connectionParameters);
        }
        return this.connectionProvider;
    }

    public SQLiteConnectionParameters getConnectionParameters() {
        return (SQLiteConnectionParameters)super.getConnectionParameters();
    }

    public String getConnectionURL() {
        return SQLiteUtils.getConnectionURL(this.getConnectionParameters());
    }

    protected String getResourceType() {
        return "SQLite";
    }

    public String getProviderName() {
        return "SQLite";
    }

    public JDBCSQLBuilderBase createSQLBuilder() {
        return new SQLiteSQLBuilder(this);
    }

    public OperationsFactory getOperations() {
        if (this.operationsFactory == null) {
            this.operationsFactory = new SQLiteOperationsFactory((JDBCHelper)this);
        }
        return this.operationsFactory;
    }

    public GeometryExpressionBuilderHelper.GeometrySupportType getGeometrySupportType() {
        return GeometryExpressionBuilderHelper.GeometrySupportType.NATIVE;
    }

    public boolean hasSpatialFunctions() {
        return true;
    }

    public boolean canWriteGeometry(int geometryType, int geometrySubtype) {
        return true;
    }

    public String getQuoteForIdentifiers() {
        return "\"";
    }

    public boolean allowAutomaticValues() {
        return true;
    }

    public boolean supportOffsetInSelect() {
        return true;
    }

    public String getQuoteForStrings() {
        return "'";
    }

    public String getSourceId(JDBCStoreParameters parameters) {
        return parameters.getDBName() + "." + parameters.getSchema() + "." + parameters.getTable();
    }

    public JDBCNewStoreParameters createNewStoreParameters() {
        return new SQLiteNewStoreParameters();
    }

    public JDBCStoreParameters createOpenStoreParameters() {
        return new SQLiteStoreParameters();
    }

    public JDBCServerExplorerParameters createServerExplorerParameters() {
        return new SQLiteExplorerParameters();
    }

    public Geometry forceGeometryType(GeometryType geomtype, Geometry geom) throws CreateGeometryException {
        if (geom == null) {
            return null;
        }
        switch (geomtype.getType()) {
            case 22: {
                if (geom.getType() != 19) break;
                MultiPolygon x = this.getGeometryManager().createMultiPolygon(geomtype.getSubType());
                x.addPrimitive((Primitive)geom);
                geom = x;
                break;
            }
            case 21: {
                if (geom.getType() != 18) break;
                MultiLine x = this.getGeometryManager().createMultiLine(geomtype.getSubType());
                x.addPrimitive((Primitive)geom);
                geom = x;
                break;
            }
            case 7: {
                if (geom.getType() != 1) break;
                MultiLine x = this.getGeometryManager().createMultiLine(geomtype.getSubType());
                x.addPrimitive((Primitive)geom);
                geom = x;
                break;
            }
            case 19: {
                MultiPolygon x;
                if (geom.getType() != 22 || (x = (MultiPolygon)geom).getPrimitivesNumber() != 1) break;
                geom = x.getPrimitiveAt(0);
                break;
            }
            case 18: {
                MultiLine x;
                if (geom.getType() != 21 || (x = (MultiLine)geom).getPrimitivesNumber() != 1) break;
                geom = x.getPrimitiveAt(0);
                break;
            }
            case 1: {
                MultiPoint x;
                if (geom.getType() != 7 || (x = (MultiPoint)geom).getPrimitivesNumber() != 1) break;
                geom = x.getPrimitiveAt(0);
            }
        }
        return geom;
    }

    public SRSSolver getSRSSolver() {
        if (this.srssolver == null) {
            JDBCConnection conn = null;
            try {
                conn = this.getConnection();
                this.srssolver = GeopackageUtils.createSRSSolver((SQLiteConnection)conn.get());
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't get SRSSolver", ex);
            }
            finally {
                JDBCConnection.closeQuietly((JDBCConnection)conn);
            }
        }
        return this.srssolver;
    }

    public Geometry getGeometryFromColumn(ResultSet rs, int index) throws DataException {
        try {
            byte[] bytes;
            if (this.getGeometrySupportType() == GeometryExpressionBuilderHelper.GeometrySupportType.NATIVE && GeopackageUtils.isGeopackageGeometry(bytes = rs.getBytes(index))) {
                if (this.geometryParser == null) {
                    this.geometryParser = GeopackageUtils.createGeometryParser();
                } else {
                    this.geometryParser.clean();
                }
                Geometry geom = this.geometryParser.parseToGeometry(null, bytes);
                return geom;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't process native geometry", (Throwable)ex);
        }
        return super.getGeometryFromColumn(rs, index);
    }

    public JDBCServerExplorer createServerExplorer(JDBCServerExplorerParameters parameters, DataServerExplorerProviderServices providerServices) throws InitializeException {
        SQLiteExplorer explorer = new SQLiteExplorer(parameters, providerServices, (JDBCHelper)this);
        this.initialize((ResourceConsumer)explorer, (JDBCConnectionParameters)parameters, null);
        return explorer;
    }

    public String getConnectionProviderKey(JDBCConnectionParameters connectionParameters) {
        return super.getConnectionProviderKey(connectionParameters);
    }

    public static class ConnectionProviderImpl
    extends AbstractConnectionProvider
    implements ConnectionProvider {
        private static boolean needRegisterDriver = true;
        private SQLiteConnectionParameters connectionParameters;

        public ConnectionProviderImpl(SQLiteConnectionParameters connectionParameters) {
            this.connectionParameters = connectionParameters;
        }

        public synchronized Connection getConnection() throws SQLException {
            File f;
            if (!this.isRegistered()) {
                this.registerDriver();
            }
            boolean newdb = (f = SQLiteUtils.getLocalFile(this.connectionParameters)) != null && !f.exists();
            SQLiteConfig config = new SQLiteConfig();
            config.setSharedCache(true);
            config.enableLoadExtension(true);
            config.setJournalMode(SQLiteConfig.JournalMode.WAL);
            config.setTransactionMode(SQLiteConfig.TransactionMode.DEFERRED);
            config.setSynchronous(SQLiteConfig.SynchronousMode.OFF);
            config.setOpenMode(SQLiteOpenMode.FULLMUTEX);
            config.setPragma(SQLiteConfig.Pragma.CASE_SENSITIVE_LIKE, "true");
            SQLiteConnection conn = JDBC.createConnection((String)this.connectionParameters.getUrl(), (Properties)config.toProperties());
            Functions.register_all(conn);
            if (newdb) {
                String[] sqls2;
                for (String sql : sqls2 = new String[]{"CREATE TABLE IF NOT EXISTS \"GVSIGD_RESOURCES\"(\"name\" VARCHAR(150) NOT NULL, \"resource\" BLOB DEFAULT NULL , PRIMARY KEY(\"name\"))", "CREATE TABLE IF NOT EXISTS \"GVSIGD_CONFIG\"(\"name\" VARCHAR(200) NOT NULL, \"value\" CLOB DEFAULT NULL, PRIMARY KEY(\"name\"))"}) {
                    try {
                        conn.createStatement().execute(sql);
                    }
                    catch (SQLException ex) {
                        LOGGER.debug("Can't configure gvsig tables.", (Throwable)ex);
                        LOGGER.warn("Can't configure gvsig tables. " + sql);
                    }
                }
            }
            return conn;
        }

        private boolean isRegistered() {
            return needRegisterDriver;
        }

        public void registerDriver() throws SQLException {
            String className = this.connectionParameters.getJDBCDriverClassName();
            if (className == null) {
                return;
            }
            try {
                Class<?> theClass = Class.forName(className);
                if (theClass == null) {
                    throw new JDBCDriverClassNotFoundException("SQLite", className);
                }
            }
            catch (Exception e) {
                throw new SQLException("Can't register JDBC driver '" + className + "'.", e);
            }
            needRegisterDriver = false;
        }

        public void dispose() {
            if (!DisposeUtils.release((Disposable)this)) {
                return;
            }
            this.connectionParameters = null;
        }

        public boolean isDisposed() {
            return this.connectionParameters == null;
        }
    }
}

