/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.functions;

import java.sql.SQLException;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.sqlite.dal.functions.Functions;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryBuilder;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.sqlite.SQLiteConnection;

public class ST_GeomFromText
extends Functions.AbstractFunction {
    public ST_GeomFromText(SQLiteConnection conn) {
        super("ST_GeomFromText", conn);
    }

    protected void xFunc() throws SQLException {
        try {
            SQLiteConnection conn = this.getConnection();
            String wkt = this.value_text(0);
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            Geometry r = geomManager.createFrom(wkt);
            if (this.args() == 2) {
                int code = this.value_int(1);
                IProjection proj = CRSFactory.getCRS((String)("EPSG:" + code));
                r.setProjection(proj);
            }
            GeopackageGeometryBuilder builder = GeopackageUtils.createGeometryBuilder();
            builder.setGeometry(conn, r);
            byte[] bytes = builder.build();
            if (bytes == null) {
                this.result();
            } else {
                this.result(bytes);
            }
        }
        catch (Throwable ex) {
            throw new SQLException("Can't build geometry from the text", ex);
        }
    }
}

