/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sqlite.dal.operations;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.PerformChangesOperation;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.sqlite.dal.geopackage.GeopackageGeometryParser;
import org.gvsig.sqlite.dal.geopackage.GeopackageUtils;
import org.gvsig.tools.util.Bitmask;
import org.sqlite.SQLiteConnection;

public class SQLitePerfomChangesOperation
extends PerformChangesOperation {
    public SQLitePerfomChangesOperation(JDBCHelper helper) {
        super(helper);
    }

    public SQLitePerfomChangesOperation(JDBCHelper helper, OperationsFactory.TableReference table, FeatureType featureType, Iterator<FeatureReferenceProviderServices> deleteds, Iterator<FeatureProvider> inserteds, Iterator<FeatureProvider> updateds, Iterator<FeatureType.FeatureTypeChanged> featureTypesChanged, FeatureStoreProviderServices storeServices) {
        super(helper, table, featureType, deleteds, inserteds, updateds, featureTypesChanged, storeServices);
    }

    public void performUpdateTable(JDBCConnection conn) throws DataException {
        Map changes;
        FeatureType currentFeatureTypeDB = this.getCurrentFeatureTypeDB();
        List sqls = this.getUpdateTableSQLs(currentFeatureTypeDB, changes = this.getUpdateTableChanges(currentFeatureTypeDB));
        if (!CollectionUtils.isEmpty((Collection)sqls)) {
            Statement st = null;
            String currentsql = null;
            try {
                st = conn.createStatement();
                Iterator iterator = sqls.iterator();
                while (iterator.hasNext()) {
                    String sql;
                    currentsql = sql = (String)iterator.next();
                    if (StringUtils.isBlank((CharSequence)sql)) continue;
                    JDBCUtils.execute((Statement)st, (String)sql);
                }
            }
            catch (SQLException e) {
                throw new JDBCSQLException((Exception)e, currentsql);
            }
            finally {
                JDBCUtils.closeQuietly((Statement)st);
            }
        }
        for (FeatureAttributeDescriptor attrTarget : this.featureTypeTarget) {
            if (attrTarget.isComputed()) continue;
            Bitmask changesAttr = (Bitmask)changes.get(attrTarget.getName());
            if (attrTarget.getType() != 66 || !changesAttr.isSetBit(8)) continue;
            this.populateSpatialIndex(attrTarget.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSpatialIndex(String name) {
        PreparedStatement insertStmt = null;
        Statement selectStmt = null;
        ResultSet rs = null;
        try {
            String insertSql = String.format("INSERT OR REPLACE INTO \"rtree_%s_%s\" VALUES (?,?,?,?,?)", this.table.getTable(), name);
            insertStmt = this.getConnection().prepareStatement(insertSql);
            FeatureAttributeDescriptor attrId = this.featureTypeTarget.getPrimaryKey()[0];
            String selectSql = String.format("SELECT \"%s\", \"%s\" FROM \"%s\"", attrId.getName(), name, this.table.getTable());
            selectStmt = this.getConnection().createStatement(selectSql);
            rs = selectStmt.executeQuery(selectSql);
            SQLiteConnection sqlConn = (SQLiteConnection)this.getConnection().get();
            while (rs.next()) {
                String id = rs.getString(1);
                byte[] geomBytes = rs.getBytes(2);
                GeopackageGeometryParser parser = GeopackageUtils.createGeometryParser();
                Geometry geom1 = parser.parseToGeometry(sqlConn, geomBytes);
                if (geom1 == null) continue;
                Envelope envelope = geom1.getEnvelope();
                insertStmt.setString(1, id);
                insertStmt.setDouble(2, envelope.getMinimum(0));
                insertStmt.setDouble(3, envelope.getMaximum(0));
                insertStmt.setDouble(4, envelope.getMinimum(1));
                insertStmt.setDouble(5, envelope.getMaximum(1));
                insertStmt.execute();
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't populate index for column '" + name + "' table '" + this.table.getTable() + "'.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(insertStmt);
                JDBCUtils.closeQuietly(rs);
                JDBCUtils.closeQuietly(selectStmt);
                throw throwable;
            }
            JDBCUtils.closeQuietly((Statement)insertStmt);
            JDBCUtils.closeQuietly(rs);
            JDBCUtils.closeQuietly(selectStmt);
        }
        JDBCUtils.closeQuietly((Statement)insertStmt);
        JDBCUtils.closeQuietly((ResultSet)rs);
        JDBCUtils.closeQuietly((Statement)selectStmt);
    }
}

