/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.lib.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyReportLine;
import org.gvsig.topology.lib.api.TopologyReportLineSet;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.impl.AbstractTopologyReportLineSet;
import org.gvsig.topology.lib.impl.DefaultTopologyReportLine;
import org.gvsig.topology.lib.impl.TopologyReportLineSymbolTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTopologyReport
extends AbstractTopologyReportLineSet
implements TopologyReport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTopologyReport.class);
    private final TopologyPlan plan;
    private int status;

    public DefaultTopologyReport(TopologyPlan plan) {
        this.plan = plan;
    }

    public TopologyReportLine addLine(TopologyRule rule, TopologyDataSet dataSet1, TopologyDataSet dataSet2, Geometry geometry, Geometry error, FeatureReference feature1, FeatureReference feature2, boolean exception, String description) {
        DefaultTopologyReportLine line = new DefaultTopologyReportLine(this, rule, dataSet1, dataSet2, geometry, error, feature1, feature2, -1, -1, exception, description, null);
        this.lines.add(line);
        this.fireChangeEvent();
        return line;
    }

    public TopologyReportLine addLine(TopologyRule rule, TopologyDataSet dataSet1, TopologyDataSet dataSet2, Geometry geometry, Geometry error, FeatureReference feature1, FeatureReference feature2, int primitive1, int primitive2, boolean exception, String description, String data) {
        DefaultTopologyReportLine line = new DefaultTopologyReportLine(this, rule, dataSet1, dataSet2, geometry, error, feature1, feature2, primitive1, primitive2, exception, description, data);
        this.lines.add(line);
        this.fireChangeEvent();
        return line;
    }

    public void removeAllLines() {
        this.lines.clear();
        this.fireChangeEvent();
    }

    public TopologyReportLineSet getLineSet(final String filter) {
        final DefaultTopologyReportLineSet set = new DefaultTopologyReportLineSet();
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                set.polulate(DefaultTopologyReport.this.lines, filter);
            }
        });
        th.start();
        return set;
    }

    public List<TopologyReportLine> getLines(String filter) {
        if (filter == null) {
            return Collections.unmodifiableList(this.lines);
        }
        ArrayList<TopologyReportLine> ll = new ArrayList<TopologyReportLine>();
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
        TopologyReportLineSymbolTable lineSymbolTable = new TopologyReportLineSymbolTable();
        MutableSymbolTable symbolTable = manager.createSymbolTable();
        symbolTable.addSymbolTable((SymbolTable)lineSymbolTable);
        Code code = manager.compile(filter);
        code = manager.optimize((SymbolTable)symbolTable, code);
        for (TopologyReportLine line : this.lines) {
            lineSymbolTable.setLine(line);
            Object value = manager.evaluate((SymbolTable)symbolTable, code);
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            ll.add(line);
        }
        return Collections.unmodifiableList(ll);
    }

    public int getStatus() {
        for (TopologyReportLine line : this.lines) {
            if (line.isException()) continue;
            return 1;
        }
        return 0;
    }

    public TopologyReportLine addCodeException(TopologyRule rule, TopologyDataSet dataSet1, Feature feature1, Throwable exception) {
        FeatureReference ref = null;
        if (feature1 != null) {
            ref = feature1.getReference();
        }
        String msg = null;
        if (exception != null) {
            msg = exception.getLocalizedMessage();
        }
        return this.addLine(rule, dataSet1, null, null, null, ref, null, false, msg);
    }

    private class DefaultTopologyReportLineSet
    extends AbstractTopologyReportLineSet {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void polulate(List<TopologyReportLine> allLines, String filter) {
            this.lines.clear();
            if (filter == null) {
                this.lines.addAll(allLines);
                this.completed = true;
                return;
            }
            SimpleTaskStatus theTaskStatus = DefaultTopologyReport.this.plan.getTaskStatus();
            try {
                theTaskStatus.push();
                theTaskStatus.restart();
                theTaskStatus.message("Preparing filter");
                theTaskStatus.setAutoremove(true);
                theTaskStatus.setIndeterminate();
                ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getManager();
                TopologyReportLineSymbolTable lineSymbolTable = new TopologyReportLineSymbolTable();
                MutableSymbolTable symbolTable = manager.createSymbolTable();
                symbolTable.addSymbolTable((SymbolTable)lineSymbolTable);
                Code code = manager.compile(filter);
                code = manager.optimize((SymbolTable)symbolTable, code);
                theTaskStatus.setRangeOfValues(0L, (long)allLines.size());
                theTaskStatus.setCurValue(0L);
                for (TopologyReportLine line : allLines) {
                    lineSymbolTable.setLine(line);
                    Object value = manager.evaluate((SymbolTable)symbolTable, code);
                    if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        this.lines.add(line);
                        this.changeListenerHelper.fireEvent();
                    }
                    theTaskStatus.incrementCurrentValue();
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Problems filtering.", (Throwable)ex);
                theTaskStatus.abort();
            }
            finally {
                if (theTaskStatus.isRunning()) {
                    theTaskStatus.terminate();
                }
                theTaskStatus.pop();
                this.completed = true;
            }
        }
    }
}

