/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.rule;

import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.topology.lib.api.ExecuteTopologyRuleActionException;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyReport;
import org.gvsig.topology.lib.api.TopologyReportLine;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleAction;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.lib.spi.AbstractTopologyRule;
import org.gvsig.topology.lib.spi.AbstractTopologyRuleAction;

public class PolygonMustNotOverlapWithPolygonRule
extends AbstractTopologyRule {
    private String geomName;
    private Expression expression = null;
    private GeometryExpressionBuilder expressionBuilder = null;

    public PolygonMustNotOverlapWithPolygonRule() {
    }

    public PolygonMustNotOverlapWithPolygonRule(TopologyRuleFactory factory, double tolerance, String dataSet1, String dataSet2) {
        super(factory, tolerance, dataSet1, dataSet2);
        this.addAction((TopologyRuleAction)new MergeAction());
        this.addAction((TopologyRuleAction)new SubtractAction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check(SimpleTaskStatus taskStatus, TopologyReport report, Feature feature1) throws Exception {
        try {
            Geometry polygon;
            if (this.expression == null) {
                this.expression = ExpressionUtils.createExpression();
                this.expressionBuilder = GeometryExpressionUtils.createExpressionBuilder();
                this.geomName = feature1.getType().getDefaultGeometryAttributeName();
            }
            if ((polygon = feature1.getDefaultGeometry()) == null) {
                return;
            }
            TopologyDataSet thisDataSet = this.getDataSet1();
            TopologyDataSet otherDataSet = this.getDataSet2();
            double theTolerance = this.getTolerance();
            if (otherDataSet.getSpatialIndex() != null) {
                for (FeatureReference otherReference : otherDataSet.query(polygon)) {
                    Feature otherFeature = otherReference.getFeature();
                    Geometry otherPolygon = otherFeature.getDefaultGeometry();
                    if (otherPolygon == null || !GeometryUtils.overlaps((Geometry)polygon, (Geometry)otherPolygon, (double)theTolerance)) continue;
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    Geometry error = polygon.intersection(otherPolygon);
                    if (error == null || (error instanceof Complex ? ((Aggregate)(error = ((Complex)error).createAggregate(22, g -> GeometryUtils.isSubtype((int)9, (int)g.getGeometryType().getType()) || GeometryUtils.isSubtype((int)3, (int)g.getGeometryType().getType())))).getPrimitivesNumber() == 0 : !GeometryUtils.isSubtype((int)9, (int)error.getGeometryType().getType()) && !GeometryUtils.isSubtype((int)3, (int)error.getGeometryType().getType()))) continue;
                    report.addLine((TopologyRule)this, thisDataSet, otherDataSet, polygon, error, feature1.getReference(), otherFeature.getReference(), false, i18n.getTranslation("_The_polygon_overlay_with_other"));
                }
            } else {
                this.expression.setPhrase(this.expressionBuilder.ifnull((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.constant((Object)false), (ExpressionBuilder.Value)this.expressionBuilder.ST_Overlaps((ExpressionBuilder.Value)this.expressionBuilder.column(this.geomName), (ExpressionBuilder.Value)this.expressionBuilder.geometry(polygon))).toString());
                FeatureSet otherFeatures = otherDataSet.getFeatureStore().getFeatureSet(this.expression);
                for (Feature otherFeature : otherFeatures) {
                    Geometry otherPolygon;
                    if (otherFeature == null || (otherPolygon = otherFeature.getDefaultGeometry()) == null || !GeometryUtils.overlaps((Geometry)polygon, (Geometry)otherPolygon, (double)theTolerance)) continue;
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    Geometry error = polygon.intersection(otherPolygon);
                    if (error == null || (error instanceof Complex ? ((Aggregate)(error = ((Complex)error).createAggregate(22, g -> GeometryUtils.isSubtype((int)9, (int)g.getGeometryType().getType()) || GeometryUtils.isSubtype((int)3, (int)g.getGeometryType().getType())))).getPrimitivesNumber() == 0 : !GeometryUtils.isSubtype((int)9, (int)error.getGeometryType().getType()) && !GeometryUtils.isSubtype((int)3, (int)error.getGeometryType().getType()))) continue;
                    report.addLine((TopologyRule)this, thisDataSet, otherDataSet, polygon, error, feature1.getReference(), otherFeature.getReference(), false, i18n.getTranslation("_The_polygon_overlay_with_other"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check feature.", (Throwable)ex);
            this.addCodeException(report, feature1, ex);
        }
    }

    private class MergeAction
    extends AbstractTopologyRuleAction {
        public MergeAction() {
            super("PolygonMustNotOverlapWithPolygon", "Merge", "Merge", "The Merge fix adds the portion of overlap from one feature and subtracts it from the others that are violating the rule. You need to pick the feature that receives the portion of overlap using the Merge dialog box. This fix can be applied to one Must Not Overlap With error only.");
        }

        public int execute(TopologyRule rule, TopologyReportLine line, DynObject parameters) {
            try {
                Geometry errorGeom = line.getError();
                FeatureReference featRef1 = line.getFeature1();
                Feature feat1 = featRef1.getFeature();
                Geometry geom1 = feat1.getDefaultGeometry();
                FeatureReference featRef2 = line.getFeature2();
                PolygonMustNotOverlapWithPolygonRule.this.substract(featRef2, geom1, rule.getDataSet2());
                return 0;
            }
            catch (Exception ex) {
                throw new ExecuteTopologyRuleActionException(ex);
            }
        }
    }

    private class SubtractAction
    extends AbstractTopologyRuleAction {
        public SubtractAction() {
            super("PolygonMustNotOverlapWithPolygon", "Subtract", "Subtract", "The Subtract fix removes the overlapping portion of each feature that is causing the error and leaves a gap or void in its place. This fix can be applied to one or more selected Must Not Overlap With errors.");
        }

        public int execute(TopologyRule rule, TopologyReportLine line, DynObject parameters) {
            try {
                Geometry errorGeom = line.getError();
                FeatureReference featRef1 = line.getFeature1();
                Feature feat1 = featRef1.getFeature();
                Geometry geom1 = feat1.getDefaultGeometry();
                FeatureReference featRef2 = line.getFeature2();
                Feature feat2 = featRef2.getFeature();
                Geometry geom2 = feat2.getDefaultGeometry();
                PolygonMustNotOverlapWithPolygonRule.this.substract(featRef1, geom2, rule.getDataSet1());
                PolygonMustNotOverlapWithPolygonRule.this.substract(featRef2, geom1, rule.getDataSet2());
                return 0;
            }
            catch (Exception ex) {
                throw new ExecuteTopologyRuleActionException(ex);
            }
        }
    }
}

