/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.swing.impl.reportserver.viewcapture;

import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.expressionevaluator.FeatureStoreElement;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportViewCapture;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewCaptureFilterController {
    private static final Logger LOG = LoggerFactory.getLogger(ViewCaptureFilterController.class);
    private ReportServer server;
    private final JComboBox cboDataSet;
    private final JTextField txtFilter;
    private final JButton btnFilter;
    private final ActionListenerSupport itemChangedSupport;
    private ExpressionPickerController pickerFilter;
    private FeatureStoreElement filterStoreElement;

    public ViewCaptureFilterController(JComboBox cboDataSet, JTextField txtFilter, JButton btnFilter) {
        this.cboDataSet = cboDataSet;
        this.txtFilter = txtFilter;
        this.btnFilter = btnFilter;
        this.itemChangedSupport = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
        this.initComponents();
    }

    public void addItemChangedListener(ActionListener itemChangedListener) {
        this.itemChangedSupport.addActionListener(itemChangedListener);
    }

    private void fillDataSetCombo() {
        DefaultComboBoxModel<ListElement> model1 = new DefaultComboBoxModel<ListElement>();
        ReportServerConfig config = this.getConfig();
        if (config != null && this.getConfig().getDatasets() != null) {
            for (ReportDataSet dataset : this.getConfig().getDatasets()) {
                model1.addElement(new ListElement(dataset.getName(), (Object)dataset));
            }
        }
        this.cboDataSet.setModel(model1);
    }

    private void initComponents() {
        this.cboDataSet.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ViewCaptureFilterController.this.doDatasetChanged();
            }
        });
        this.pickerFilter = ExpressionEvaluatorSwingLocator.getManager().createExpressionPickerController((JTextComponent)this.txtFilter, this.btnFilter);
        this.pickerFilter.getConfig().addSymbolTable(ReportLocator.getReportManager().createReportSymbolTable());
        this.filterStoreElement = DALSwingLocator.getSwingManager().createFeatureStoreElement();
        this.pickerFilter.getConfig().addElement((Element)this.filterStoreElement);
        this.pickerFilter.setEnabled(false);
        this.clear();
    }

    public ExpressionBuilderConfig getExpressionBuilderConfig() {
        return this.pickerFilter.getConfig();
    }

    private void doDatasetChanged() {
        String datasetName = (String)this.cboDataSet.getSelectedItem();
        if (datasetName == null) {
            this.pickerFilter.setEnabled(false);
            return;
        }
        ReportDataSet dataset = this.getConfig().getDataset(datasetName);
        if (dataset == null) {
            this.pickerFilter.setEnabled(false);
            return;
        }
        this.filterStoreElement.setFeatureStore(dataset.getStore());
        this.pickerFilter.setEnabled(true);
    }

    public void clear() {
        this.cboDataSet.setModel(new DefaultComboBoxModel());
        this.pickerFilter.set(null);
    }

    public void setEnabled(boolean enabled) {
        this.cboDataSet.setEnabled(enabled);
        if (this.cboDataSet.getSelectedIndex() < 0) {
            this.pickerFilter.setEnabled(false);
        } else {
            this.pickerFilter.setEnabled(enabled);
        }
    }

    public void setServer(ReportServer server) {
        this.clear();
        this.server = server;
        this.fillDataSetCombo();
    }

    public ReportServer getServer() {
        return this.server;
    }

    public ReportServerConfig getConfig() {
        if (this.server == null) {
            return null;
        }
        return this.server.getConfig();
    }

    public void set(ReportViewCapture.ReportViewCaptureFilter filter) {
        if (this.getConfig() == null) {
            throw new IllegalStateException("The config attribute can't be initialized.");
        }
        if (filter == null) {
            this.setEnabled(false);
            this.clear();
            return;
        }
        DefaultComboBoxModel<String> datasetsModel = new DefaultComboBoxModel<String>();
        datasetsModel.addElement(" ");
        if (this.getConfig().getDatasets() != null) {
            for (ReportDataSet dataset : this.getConfig().getDatasets()) {
                datasetsModel.addElement(dataset.getName());
            }
        }
        this.cboDataSet.setModel(datasetsModel);
        this.cboDataSet.setSelectedItem(filter.getDataSet());
        this.pickerFilter.set((Object)filter.getExpression());
        this.setEnabled(true);
    }

    public void fetch(ReportViewCapture.ReportViewCaptureFilter filter) {
        String datasetName = (String)this.cboDataSet.getSelectedItem();
        filter.setDataSet(datasetName);
        filter.setExpression(this.pickerFilter.get());
    }
}

