/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.metadata.lib.basic.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gvsig.metadata.Metadata;
import org.gvsig.metadata.MetadataContainer;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.AddMetadataDefinitionException;
import org.gvsig.metadata.exceptions.DuplicateMetadataDefinitionException;
import org.gvsig.metadata.exceptions.InvalidMetadataNamespaceException;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.impl.DefaultDynClassName;
import org.gvsig.tools.persistence.impl.exception.CantFindDefinitionInStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractMetadataManager
implements MetadataManager {
    private final Logger LOG = LoggerFactory.getLogger(AbstractMetadataManager.class);
    private Map metadataItems;
    protected DynObjectManager dynManager = ToolsLocator.getDynObjectManager();
    protected File metadataHomeFile = null;
    private boolean doSavingValidation;
    private boolean doExportingValidation;

    protected void initDefinitions() {
        this.metadataItems = new HashMap();
        Iterator definitionsIter = ToolsLocator.getDynObjectManager().iterator("metadata");
        while (definitionsIter.hasNext()) {
            DynStruct definition = (DynStruct)definitionsIter.next();
            if (this.getMetadataItems().containsKey(definition)) continue;
            Metadata metadata = this.createMetadata(definition);
            this.getMetadataItems().put(definition, metadata);
        }
    }

    public DynStruct addDefinition(String name, String description) throws MetadataException {
        DynClass definition = this.dynManager.createDynClass("metadata", name, description);
        this.addDefinition(definition);
        return definition;
    }

    public DynStruct addDefinition(String metadataDefinitionName, InputStream stream, ClassLoader loader) throws MetadataException {
        Map x;
        try {
            x = this.dynManager.importDynClassDefinitions(stream, loader, "metadata");
        }
        catch (XmlPullParserException e) {
            throw new AddMetadataDefinitionException((Throwable)e, metadataDefinitionName);
        }
        catch (IOException e) {
            throw new AddMetadataDefinitionException((Throwable)e, metadataDefinitionName);
        }
        DynClass definition = (DynClass)x.get(metadataDefinitionName);
        if (definition == null) {
            throw new CantFindDefinitionInStreamException(metadataDefinitionName, this.getKeys(x));
        }
        this.addDefinition(definition);
        return definition;
    }

    private String getKeys(Map theMap) {
        return new ArrayList(theMap.keySet()).toString();
    }

    public DynStruct getDefinition(Metadata metadata) throws MetadataException {
        return this.dynManager.get("metadata", metadata.getMetadataName());
    }

    public DynStruct getDefinition(String metadataName) {
        if (metadataName == null) {
            return null;
        }
        if (metadataName.contains(":")) {
            int index = metadataName.lastIndexOf(":");
            return this.dynManager.get(metadataName.substring(0, index), metadataName.substring(index + 1, metadataName.length()));
        }
        return this.dynManager.get("metadata", metadataName);
    }

    public void addDefinition(DynClass definition) throws MetadataException {
        if (definition == null) {
            return;
        }
        if (definition.getNamespace() == null || definition.getNamespace().equals("")) {
            definition.setNamespace("metadata");
        }
        if (!"metadata".equalsIgnoreCase(definition.getNamespace())) {
            throw new InvalidMetadataNamespaceException(definition.getName(), definition.getNamespace());
        }
        if (this.dynManager.get(definition.getNamespace(), definition.getName()) != null) {
            throw new DuplicateMetadataDefinitionException(definition.getName());
        }
        this.dynManager.add(definition);
        this.LOG.trace("Registered metadata definition {}.", (Object)definition.getFullName());
    }

    public void removeDefinition(DynStruct dynStruct) {
        if (dynStruct == null) {
            return;
        }
        this.metadataItems.remove(dynStruct);
        this.dynManager.remove(dynStruct);
    }

    public MetadataContainer createMetadataContainer(String name) {
        DynClass dynClass = this.dynManager.get("metadata", name);
        if (dynClass == null) {
            throw new IllegalArgumentException("Can't locate class '" + new DefaultDynClassName("metadata", name).getFullName() + "'.");
        }
        return this.createMetadataContainer(dynClass);
    }

    protected abstract MetadataContainer createMetadataContainer(DynClass var1);

    public void storeMetadata(Metadata metadata) throws MetadataException {
    }

    public void loadMetadata(Metadata metadata) throws MetadataException {
    }

    private Map getMetadataItems() {
        if (this.metadataItems == null) {
            this.initDefinitions();
        }
        return this.metadataItems;
    }

    public Metadata getMetadata(DynStruct definition) throws InvalidMetadataNamespaceException {
        if (this.getMetadataItems().containsKey(definition)) {
            return (Metadata)this.getMetadataItems().get(definition);
        }
        if (definition == null) {
            return null;
        }
        if (definition.getNamespace() == null || !definition.getNamespace().equals("metadata")) {
            throw new InvalidMetadataNamespaceException(definition);
        }
        Metadata metadata = this.createMetadata(definition);
        this.getMetadataItems().put(definition, metadata);
        this.LOG.trace("Registered metadata definition {}.", (Object)definition.getFullName());
        return metadata;
    }

    protected abstract Metadata createMetadata(DynStruct var1);

    public File getMetadataHomeRepository() {
        if (this.metadataHomeFile == null) {
            String path = System.getProperty("user.home");
            path = path + File.separator + ".org.gvsig.metadata";
            this.metadataHomeFile = new File(path);
        }
        if (!this.metadataHomeFile.exists()) {
            this.metadataHomeFile.mkdirs();
        }
        return this.metadataHomeFile;
    }

    public File getRepositoryFile(String relativePath) {
        if (relativePath == null || relativePath.equals("")) {
            return this.metadataHomeFile;
        }
        return new File(this.getMetadataHomeRepository().toString() + File.separator + relativePath);
    }

    public void storeDefinitions() {
        Iterator it = ToolsLocator.getDynObjectManager().iterator("metadata");
    }

    public Iterator getDefinitions() {
        return this.getMetadataItems().values().iterator();
    }

    public void setMetadataHomeRepository(File metadataHomeFile) {
        if (metadataHomeFile == null) {
            return;
        }
        this.metadataHomeFile = metadataHomeFile;
        if (!this.metadataHomeFile.exists()) {
            this.metadataHomeFile.mkdirs();
        }
    }

    public Metadata getMetadata(String metadataID) throws InvalidMetadataNamespaceException {
        return this.getMetadata(this.getDefinition(metadataID));
    }

    public void setValidationBeforeSaving(boolean doValidation) {
        this.doSavingValidation = doValidation;
    }

    public boolean getValidationBeforeSaving() {
        return this.doSavingValidation;
    }

    public void setValidationBeforeExporting(boolean doValidation) {
        this.doExportingValidation = doValidation;
    }

    public boolean getValidationBeforeExporting() {
        return this.doExportingValidation;
    }
}

