/*
 * Decompiled with CFR 0.152.
 */
package org.cts.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cts.registry.Registry;
import org.cts.registry.RegistryManagerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistryManager {
    static final Logger LOGGER = LoggerFactory.getLogger(RegistryManager.class);
    private final Map<String, Registry> registries = new HashMap<String, Registry>();
    private final List<RegistryManagerListener> listeners = new ArrayList<RegistryManagerListener>();

    public void addRegistryManagerListener(RegistryManagerListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeRegistryManagerListener(RegistryManagerListener listener) {
        return this.listeners.remove(listener);
    }

    public void addRegistry(Registry registryClass) {
        this.addRegistry(registryClass, false);
    }

    public void addRegistry(Registry registry, boolean replace) {
        LOGGER.trace("Adding a new registry " + registry.getRegistryName());
        String registryName = registry.getRegistryName().toLowerCase();
        if (!replace && this.registries.containsKey(registryName)) {
            throw new IllegalArgumentException("Registry " + registryName + " already exists");
        }
        this.registries.put(registryName, registry);
        this.fireRegistryAdded(registryName);
    }

    private void fireRegistryAdded(String functionName) {
        for (RegistryManagerListener listener : this.listeners) {
            listener.registryAdded(functionName);
        }
    }

    public boolean contains(String name) {
        return this.registries.containsKey(name);
    }

    public String[] getRegistryNames() {
        LOGGER.trace("Getting all function names");
        Set<String> k = this.registries.keySet();
        return k.toArray(new String[k.size()]);
    }

    public Registry getRegistry(String registryName) {
        LOGGER.trace("Getting the registry " + registryName);
        Registry registry = this.registries.get(registryName.toLowerCase());
        if (registry == null) {
            return null;
        }
        return registry;
    }
}

