/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.fmap.dal.store.dwg;

import java.io.File;
import org.gvsig.dwg.fmap.dal.store.dwg.DWGOpenStoreParameters;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.FileNotFoundException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.impl.AbstractFilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderServices;

public class DWGFilesystemServerProvider
extends AbstractFilesystemServerExplorerProvider
implements FilesystemServerExplorerProvider,
ResourceConsumer {
    public String getDataStoreProviderName() {
        return "DWG";
    }

    public int getMode() {
        return 3;
    }

    public boolean accept(File pathname) {
        return pathname.getName().toLowerCase().endsWith(".dwg");
    }

    public String getDescription() {
        return "DWG file";
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        DWGOpenStoreParameters params = (DWGOpenStoreParameters)manager.createStoreParameters(this.getDataStoreProviderName());
        params.setFileName(file.getPath());
        return params;
    }

    public boolean canCreate() {
        return true;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        if (!(parameters instanceof DWGOpenStoreParameters)) {
            throw new IllegalArgumentException();
        }
        DWGOpenStoreParameters dwgParams = (DWGOpenStoreParameters)parameters;
        File file = new File(dwgParams.getFileName());
        if (dwgParams.getCRS() == null) {
            return false;
        }
        if (file.exists()) {
            return file.canWrite();
        }
        return file.getParentFile().canWrite();
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        throw new UnsupportedOperationException();
    }

    public NewDataStoreParameters getCreateParameters() throws DataException {
        return (NewFeatureStoreParameters)DALLocator.getDataManager().createStoreParameters(this.getDataStoreProviderName());
    }

    public void initialize(FilesystemServerExplorerProviderServices serverExplorer) {
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        File file = new File(((DWGOpenStoreParameters)parameters).getFileName());
        if (!file.exists()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new FileNotFoundException(file));
        }
        if (!file.delete()) {
            // empty if block
        }
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void resourceChanged(ResourceProvider resource) {
    }
}

