/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Map;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.handler.Handler;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;

public interface Geometry
extends Shape,
Serializable,
Comparable,
Cloneable {
    public static final int JOIN_STYLE_ROUND = 1;
    public static final int JOIN_STYLE_MITRE = 2;
    public static final int JOIN_STYLE_BEVEL = 3;
    public static final int EXTENDED_GEOMTYPE_OFFSET = 17;
    public static final int EXTENDED_GEOMSUBTYPE_OFFSET = 6;
    public static final int BEST = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int E = 3;
    public static final int SE = 4;
    public static final int S = 5;
    public static final int SW = 6;
    public static final int W = 7;
    public static final int NW = 8;
    public static final int SELECTHANDLER = 0;
    public static final int STRETCHINGHANDLER = 1;

    public int getType();

    public Geometry cloneGeometry();

    public Geometry clone() throws CloneNotSupportedException;

    @Override
    public boolean intersects(Rectangle2D var1);

    public boolean fastIntersects(double var1, double var3, double var5, double var7);

    public Envelope getEnvelope();

    public void reProject(ICoordTrans var1);

    public void transform(AffineTransform var1);

    public int getDimension();

    public boolean isSimple();

    public boolean isCCW() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Object invokeOperation(int var1, GeometryOperationContext var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Object invokeOperation(String var1, GeometryOperationContext var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public GeometryType getGeometryType();

    public Object convertTo(String var1, Object ... var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public String convertToGeoJson(Map<String, Object> var1, boolean var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public byte[] convertToWKB() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public String convertToHexEWKB() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public String convertToHexWKB() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public byte[] convertToWKBQuietly();

    public String convertToHexWKBQuietly();

    public String convertToHexEWKBQuietly();

    public byte[] convertToWKB(int var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public byte[] convertToWKBForcingType(int var1, int var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public byte[] convertToEWKB() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public byte[] convertToEWKB(int var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public byte[] convertToEWKBForcingType(int var1, int var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public String convertToWKT() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public String convertToWKTQuietly();

    public Geometry buffer(double var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry buffer(double var1, int var3, boolean var4) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry offset(double var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry offset(int var1, double var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean contains(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public double distance(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry[] closestPoints(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean isWithinDistance(Geometry var1, double var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean overlaps(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry convexHull() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean coveredBy(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean covers(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean crosses(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry difference(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean disjoint(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry intersection(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean intersects(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry snapTo(Geometry var1, double var2) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean touches(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry union(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean within(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Point centroid() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Point getInteriorPoint() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public double area() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public double perimeter() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public void rotate(double var1, double var3, double var5);

    public void move(double var1, double var3);

    public void scale(Point var1, double var2, double var4);

    public boolean isValid();

    public ValidationStatus getValidationStatus();

    public Geometry makeValid();

    public Shape getShape(AffineTransform var1);

    public Shape getShape();

    @Override
    public Rectangle2D getBounds2D();

    @Override
    public PathIterator getPathIterator(AffineTransform var1);

    public Handler[] getHandlers(int var1);

    @Override
    public PathIterator getPathIterator(AffineTransform var1, double var2);

    public Shape getInternalShape();

    public GeneralPathX getGeneralPath();

    public MultiPoint toPoints() throws GeometryException;

    public MultiLine toLines() throws GeometryException;

    public MultiPolygon toPolygons() throws GeometryException;

    public void flip() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean ensureOrientation(boolean var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean out(Geometry var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry force2D() throws GeometryOperationNotSupportedException, GeometryOperationException;

    public Geometry forceSubtype(int var1) throws GeometryOperationNotSupportedException, GeometryOperationException;

    public boolean canBeTransformed(AffineTransform var1);

    public boolean canBeReprojected(ICoordTrans var1);

    public void setProjection(String var1);

    public void setProjection(IProjection var1);

    public void setProjectionIffNull(IProjection var1);

    public IProjection getProjection();

    public Geometry boundary();

    public boolean equals(Object var1);

    public Geometry fix();

    public boolean isEmpty();

    public static interface ValidationStatus {
        public static final int VALID = 0;
        public static final int CURRUPTED = 1;
        public static final int UNKNOW = 2;
        public static final int DISCONNECTED_INTERIOR = 10;
        public static final int DUPLICATE_RINGS = 11;
        public static final int HOLE_OUTSIDE_SHELL = 12;
        public static final int INVALID_COORDINATE = 13;
        public static final int NESTED_HOLES = 14;
        public static final int NESTED_SHELLS = 15;
        public static final int RING_NOT_CLOSED = 17;
        public static final int RING_SELF_INTERSECTION = 18;
        public static final int SELF_INTERSECTION = 19;
        public static final int TOO_FEW_POINTS = 20;

        public boolean isValid();

        public int getStatusCode();

        public Point getProblemLocation();

        public String getMessage();
    }

    public static interface OPERATIONS {
        public static final String CONVERTTOWKT = "toWKT";
        public static final String CONVERTTOWKB = "toWKB";
        public static final String BUFFER = "buffer";
        public static final String DISTANCE = "Distance";
        public static final String CONTAINS = "Contains";
        public static final String OVERLAPS = "OVERLAPS";
        public static final String CONVEXHULL = "ConvexHull";
        public static final String COVERS = "Covers";
        public static final String CROSSES = "Crosses";
        public static final String DIFFERENCE = "Difference";
        public static final String DISJOIN = "Disjoin";
        public static final String INTERSECTION = "Intersaction";
        public static final String INTERSECTS = "Intersects";
        public static final String TOUCHES = "Touches";
        public static final String UNION = "Union";
        public static final String WITHIN = "Within";
        public static final String COVEREDBY = "CoveredBy";
        public static final String BOUNDARY = "Boundary";
    }

    public static interface SUBTYPES {
        public static final int GEOM2D = 0;
        public static final int GEOM3D = 1;
        public static final int GEOM2DM = 2;
        public static final int GEOM3DM = 3;
        public static final int UNKNOWN = 4;
    }

    public static interface DIMENSIONS {
        public static final int X = 0;
        public static final int Y = 1;
        public static final int Z = 2;
    }

    public static interface TYPES {
        public static final int UNKNOWN = -1;
        public static final int GEOMETRY = 0;
        public static final int POINT = 1;
        public static final int CURVE = 2;
        public static final int SURFACE = 3;
        public static final int SOLID = 4;
        public static final int AGGREGATE = 6;
        public static final int MULTIPOINT = 7;
        public static final int MULTICURVE = 8;
        public static final int MULTISURFACE = 9;
        public static final int MULTISOLID = 10;
        public static final int CIRCLE = 11;
        public static final int ARC = 12;
        public static final int ELLIPSE = 13;
        public static final int SPLINE = 14;
        public static final int ELLIPTICARC = 15;
        @Deprecated
        public static final int NULL = 16;
        public static final int COMPLEX = 17;
        public static final int LINE = 18;
        public static final int POLYGON = 19;
        public static final int RING = 20;
        public static final int MULTILINE = 21;
        public static final int MULTIPOLYGON = 22;
        public static final int CIRCUMFERENCE = 23;
        public static final int PERIELLIPSE = 24;
        public static final int FILLEDSPLINE = 25;
    }
}

