/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.type;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.operation.GeometryOperation;
import org.gvsig.fmap.geom.type.GeometryType;

public abstract class AbstractGeometryType
implements GeometryType {
    private final List<GeometryOperation> GEOMETRY_OPERATIONS = new ArrayList<GeometryOperation>();

    @Override
    public boolean isTypeOf(GeometryType geometryType) {
        return this.isTypeOf(geometryType.getType());
    }

    @Override
    public boolean isSubTypeOf(GeometryType geometryType) {
        return this.isSubTypeOf(geometryType.getSubType());
    }

    @Override
    public void setGeometryOperation(int index, GeometryOperation geomOp) {
        while (index > this.GEOMETRY_OPERATIONS.size()) {
            this.GEOMETRY_OPERATIONS.add(null);
        }
        if (index == this.GEOMETRY_OPERATIONS.size()) {
            this.GEOMETRY_OPERATIONS.add(geomOp);
        } else {
            this.GEOMETRY_OPERATIONS.set(index, geomOp);
        }
    }

    @Override
    public GeometryOperation getGeometryOperation(int index) {
        return this.GEOMETRY_OPERATIONS.get(index);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeometryType) {
            GeometryType other = (GeometryType)obj;
            return this.getType() == other.getType() && this.getSubType() == other.getSubType();
        }
        return false;
    }

    protected List getGeometryOperations() {
        return this.GEOMETRY_OPERATIONS;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.getName()).append(",[").append(this.getGeometryOperations().toString()).append("]");
        return sb.toString();
    }

    @Override
    public boolean hasZ() {
        int subtype = this.getSubType();
        return subtype == 1 || subtype == 3;
    }

    @Override
    public boolean hasM() {
        int subtype = this.getSubType();
        return subtype == 2 || subtype == 3;
    }
}

