/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.tile.impl.provider;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.TileCacheLocator;
import org.gvsig.raster.cache.tile.disk.ITileFileSystemStrategy;
import org.gvsig.raster.cache.tile.exception.TileBuildException;
import org.gvsig.raster.cache.tile.impl.TileImpl;
import org.gvsig.raster.cache.tile.impl.provider.TileMatrix;
import org.gvsig.raster.cache.tile.impl.provider.TileMatrixLimits;
import org.gvsig.raster.cache.tile.impl.provider.TileMatrixSet;
import org.gvsig.raster.cache.tile.provider.CacheStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheStruct
implements CacheStruct {
    private TileMatrixSet tileMatrixSet = null;
    private ArrayList<TileMatrixLimits> limits = null;
    private String layerName = null;
    private String uri = null;
    private Rectangle2D worldExtent = null;
    private String fileSuffix = null;
    private String epsg = null;
    private long fileSize = 0L;
    private double realPixelSize = 0.0;
    private Rectangle2D layerExtent = null;

    public DefaultCacheStruct(int typeOfCoords, int levels, Rectangle2D layerExtent, double pixelSize, int tilePxWidth, int tilePxHeight, String uri, String layerName, ITileFileSystemStrategy strategy, String baseDir, String fileSuffix, String epsg, long size) {
        this.uri = uri;
        this.layerName = layerName;
        this.fileSuffix = fileSuffix;
        this.fileSize = size;
        this.realPixelSize = pixelSize;
        this.layerExtent = layerExtent;
        if (epsg != null && epsg.startsWith("EPSG:")) {
            this.epsg = epsg;
        }
        if (typeOfCoords == 0) {
            this.worldExtent = new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
        }
        if (typeOfCoords == 1) {
            this.worldExtent = new Rectangle2D.Double(-2.0037508E7, -2.0037508E7, 4.0075016E7, 4.0075016E7);
        }
        double[] pixelSizeList = this.buildWorldMatrix(typeOfCoords, levels, tilePxWidth, tilePxHeight, this.worldExtent);
        this.buildLayerMatrix(levels, tilePxWidth, tilePxHeight, this.worldExtent, layerExtent, pixelSizeList, pixelSize);
    }

    private void buildLayerMatrix(int levels, int tilePxWidth, int tilePxHeight, Rectangle2D worldExtent, Rectangle2D layerExtent, double[] pixelSizeList, double maxPixelSize) {
        this.limits = new ArrayList();
        for (int i = 0; i < levels; ++i) {
            int minTileCol = (int)(Math.abs(layerExtent.getMinX() - worldExtent.getMinX()) / pixelSizeList[i]) / tilePxWidth;
            int minTileRow = (int)(Math.abs(layerExtent.getMaxY() - worldExtent.getMaxY()) / pixelSizeList[i]) / tilePxHeight;
            int maxTileCol = (int)(Math.abs(layerExtent.getMaxX() - worldExtent.getMinX()) / pixelSizeList[i]) / tilePxWidth;
            int maxTileRow = (int)(Math.abs(layerExtent.getMinY() - worldExtent.getMaxY()) / pixelSizeList[i]) / tilePxHeight;
            TileMatrixLimits limit = new TileMatrixLimits();
            limit.setMinTileRow(minTileRow);
            limit.setMinTileCol(minTileCol);
            limit.setMaxTileRow(maxTileRow);
            limit.setMaxTileCol(maxTileCol);
            double ulx = worldExtent.getMinX() + (double)(minTileCol * tilePxWidth) * pixelSizeList[i];
            double uly = worldExtent.getMaxY() - (double)(minTileRow * tilePxHeight) * pixelSizeList[i];
            limit.getTileMatrix().setTopLeftCorner(new double[]{ulx, uly});
            limit.getTileMatrix().setScaleDenominator(pixelSizeList[i]);
            limit.getTileMatrix().setTileWidth(tilePxWidth);
            limit.getTileMatrix().setTileHeight(tilePxHeight);
            this.limits.add(limit);
            if (i == levels - 1 || maxPixelSize != Double.POSITIVE_INFINITY && maxPixelSize != Double.NEGATIVE_INFINITY && pixelSizeList[i] < maxPixelSize) break;
        }
    }

    private double[] buildWorldMatrix(int typeOfCoords, int levels, int tilePxWidth, int tilePxHeight, Rectangle2D worldExtent) {
        double[] pixelSizeList = new double[levels];
        this.limits = new ArrayList();
        this.tileMatrixSet = new TileMatrixSet();
        this.tileMatrixSet.setBbox(worldExtent);
        int nTilesWidth = 0;
        int nTilesHeight = 0;
        for (int i = 0; i < levels; ++i) {
            TileMatrix tm = new TileMatrix();
            tm.setTileWidth(tilePxWidth);
            tm.setTileHeight(tilePxHeight);
            if (i == 0) {
                nTilesWidth = typeOfCoords == 1 ? 1 : 2;
                nTilesHeight = 1;
            } else {
                nTilesWidth *= 2;
                nTilesHeight *= 2;
            }
            tm.setMatrixWidth(nTilesWidth);
            tm.setMatrixHeight(nTilesHeight);
            pixelSizeList[i] = tilePxWidth > 0 && nTilesWidth > 0 ? worldExtent.getWidth() / (double)((long)tilePxWidth * (long)nTilesWidth) : 0.0;
            tm.setScaleDenominator(pixelSizeList[i]);
            this.tileMatrixSet.getTileMatrix().add(tm);
        }
        return pixelSizeList;
    }

    public Rectangle2D getWorldExtent() {
        return this.worldExtent;
    }

    public int getNumberOfLevels() {
        return this.tileMatrixSet.getTileMatrix().size();
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getServerURL() {
        return this.uri;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public int[] getTileSizeByLevel(int level) {
        return new int[]{this.tileMatrixSet.getTileMatrix().get(level).getTileWidth(), this.tileMatrixSet.getTileMatrix().get(level).getTileHeight()};
    }

    public double[] getTileSizeInRealCoordsByLevel(int level) {
        return new double[]{this.getPixelSizeByLevel(level) * (double)this.tileMatrixSet.getTileMatrix().get(level).getTileWidth(), this.getPixelSizeByLevel(level) * (double)this.tileMatrixSet.getTileMatrix().get(level).getTileHeight()};
    }

    public int getLayerWidthOfTileMatrixByLevel(int level) {
        if (level < this.limits.size()) {
            TileMatrixLimits l = this.limits.get(level);
            return l.getMaxTileRow() - l.getMinTileRow() + 1;
        }
        return 0;
    }

    public int getLayerHeightOfTileMatrixByLevel(int level) {
        if (level < this.limits.size()) {
            TileMatrixLimits l = this.limits.get(level);
            return l.getMaxTileCol() - l.getMinTileCol() + 1;
        }
        return 0;
    }

    public int getLayerInitXTilePositionByLevel(int level) {
        TileMatrixLimits l = this.limits.get(level);
        return l.getMinTileCol();
    }

    public int getLayerInitYTilePositionByLevel(int level) {
        TileMatrixLimits l = this.limits.get(level);
        return l.getMinTileRow();
    }

    public long getWorldHeightOfTileMatrixByLevel(int level) {
        return this.tileMatrixSet.getTileMatrix().get(level).getMatrixWidth();
    }

    public long getWorldWidthOfTileMatrixByLevel(int level) {
        return this.tileMatrixSet.getTileMatrix().get(level).getMatrixHeight();
    }

    public double getPixelSizeByLevel(int level) {
        if (level < 0) {
            return this.realPixelSize;
        }
        return this.tileMatrixSet.getTileMatrix().get(level).getScaleDenominator();
    }

    public Point2D[] getTileExtent(Tile tile) {
        return this.limits.get(tile.getLevel()).getTileExtent(tile.getRow(), tile.getCol());
    }

    public Point2D[] getTileExtent(int level, int col, int row) {
        return this.limits.get(level).getTileExtent(row, col);
    }

    public Tile getTileStructure(int level, int tileCol, int tileRow, Point2D ul, Point2D lr) throws TileBuildException {
        int[] size = this.getTileSizeByLevel(level);
        Tile tile = TileCacheLocator.getManager().createTile(level, tileRow, tileCol);
        tile.setUl(ul);
        tile.setLr(lr);
        tile.setWidthPx(size[0]);
        tile.setHeightPx(size[1]);
        return tile;
    }

    public List<Tile> getTileList(Rectangle2D r) {
        int tilePxWidth = this.tileMatrixSet.getTileMatrix().get(0).getTileWidth();
        int tilePxHeight = this.tileMatrixSet.getTileMatrix().get(0).getTileHeight();
        int minTileCol = (int)(r.getX() / (double)tilePxWidth);
        int minTileRow = (int)(r.getY() / (double)tilePxHeight);
        int maxTileCol = (int)((r.getX() + r.getWidth()) / (double)tilePxWidth);
        int maxTileRow = (int)((r.getY() + r.getHeight()) / (double)tilePxHeight);
        double tileWCWidth = (double)tilePxWidth * this.realPixelSize;
        double tileWCHeight = (double)tilePxHeight * this.realPixelSize;
        ArrayList<Tile> tileList = new ArrayList<Tile>();
        for (int i = minTileRow; i <= maxTileRow; ++i) {
            for (int j = minTileCol; j <= maxTileCol; ++j) {
                Point2D.Double ulTile = new Point2D.Double(this.layerExtent.getMinX() + tileWCWidth * (double)j, this.layerExtent.getMaxY() - tileWCHeight * (double)i);
                Point2D.Double lrTile = new Point2D.Double(((Point2D)ulTile).getX() + tileWCWidth, ((Point2D)ulTile).getY() - tileWCHeight);
                TileImpl t = new TileImpl(tilePxWidth, tilePxHeight, i, j, ulTile, lrTile);
                t.setLevel(-1);
                int initTileX = tilePxWidth * j;
                int initTileY = tilePxHeight * i;
                Rectangle2D.Double rTile = new Rectangle2D.Double(initTileX, initTileY, tilePxWidth, tilePxHeight);
                t.setCoordsPx(rTile);
                tileList.add(t);
            }
        }
        return tileList;
    }

    public List<Tile> getTileList(Point2D ul, Point2D lr, double mtsPixelRequest) {
        return this.getTileList(ul, lr, mtsPixelRequest, false);
    }

    public List<Tile> getTileList(Point2D ul, Point2D lr, double mtsPixelRequest, boolean increaseResolution) {
        int tilePxWidth = 0;
        int tilePxHeight = 0;
        double tileWCWidth = 0.0;
        double tileWCHeight = 0.0;
        int level = 0;
        double mtsPixelLevel = 0.0;
        boolean levelAssigned = false;
        for (int i = 0; i < this.tileMatrixSet.getTileMatrix().size(); ++i) {
            mtsPixelLevel = this.tileMatrixSet.getTileMatrix().get(i).getScaleDenominator();
            if (!(this.clipDecimals(mtsPixelRequest, 6) >= this.clipDecimals(mtsPixelLevel, 6)) && (levelAssigned || i != this.tileMatrixSet.getTileMatrix().size() - 1)) continue;
            level = Math.max(i, 0);
            if (increaseResolution) {
                ++level;
            }
            if (level > this.limits.size() - 1) {
                level = this.limits.size() - 1;
            }
            mtsPixelLevel = this.tileMatrixSet.getTileMatrix().get(level).getScaleDenominator();
            tilePxWidth = this.tileMatrixSet.getTileMatrix().get(level).getTileWidth();
            tilePxHeight = this.tileMatrixSet.getTileMatrix().get(level).getTileHeight();
            tileWCWidth = (double)tilePxWidth * mtsPixelLevel;
            tileWCHeight = (double)tilePxHeight * mtsPixelLevel;
            levelAssigned = true;
            break;
        }
        int minTileCol = (int)(Math.abs(ul.getX() - this.worldExtent.getMinX()) / mtsPixelLevel / (double)tilePxWidth);
        int minTileRow = (int)(Math.abs(ul.getY() - this.worldExtent.getMaxY()) / mtsPixelLevel / (double)tilePxHeight);
        double maxTC = Math.abs(lr.getX() - this.worldExtent.getMinX()) / mtsPixelLevel / (double)tilePxWidth;
        double maxTR = Math.abs(lr.getY() - this.worldExtent.getMaxY()) / mtsPixelLevel / (double)tilePxHeight;
        int maxTileCol = maxTC - (double)((int)maxTC) == 0.0 ? (int)(maxTC - 1.0) : (int)maxTC;
        int maxTileRow = maxTR - (double)((int)maxTR) == 0.0 ? (int)(maxTR - 1.0) : (int)maxTR;
        ArrayList<Tile> tileList = new ArrayList<Tile>();
        for (int i = minTileRow; i <= maxTileRow; ++i) {
            for (int j = minTileCol; j <= maxTileCol; ++j) {
                Point2D.Double ulTile = new Point2D.Double(this.worldExtent.getMinX() + tileWCWidth * (double)j, this.worldExtent.getMaxY() - tileWCHeight * (double)i);
                Point2D.Double lrTile = new Point2D.Double(((Point2D)ulTile).getX() + tileWCWidth, ((Point2D)ulTile).getY() - tileWCHeight);
                TileImpl t = new TileImpl(tilePxWidth, tilePxHeight, i, j, ulTile, lrTile);
                t.setLevel(level);
                tileList.add(t);
            }
        }
        return tileList;
    }

    public boolean compare(CacheStruct struct) {
        if (struct.getNumberOfLevels() == this.getNumberOfLevels()) {
            for (int i = 0; i < this.getNumberOfLevels(); ++i) {
                if (struct.getTileSizeByLevel(i)[0] != this.getTileSizeByLevel(i)[0] || struct.getTileSizeByLevel(i)[1] != this.getTileSizeByLevel(i)[1] || struct.getWorldHeightOfTileMatrixByLevel(i) != this.getWorldHeightOfTileMatrixByLevel(i) || struct.getWorldWidthOfTileMatrixByLevel(i) != this.getWorldWidthOfTileMatrixByLevel(i) || this.clipDecimals(struct.getPixelSizeByLevel(i), 2) != this.clipDecimals(this.getPixelSizeByLevel(i), 2) || !this.compareExtents(struct.getTileExtent(i, 0, 0), this.getTileExtent(i, 0, 0))) continue;
                return true;
            }
        }
        return false;
    }

    public String getEPSG() {
        return this.epsg;
    }

    public String getFileSize() {
        return this.fileSize + "";
    }

    private boolean compareExtents(Point2D[] p, Point2D[] p1) {
        return p[0].getX() == p1[0].getX() && p[0].getY() == p1[0].getY() && p[1].getX() == p1[1].getX() && p[1].getY() == p1[1].getY();
    }

    public double clipDecimals(double num, int n) {
        long m = (long)Math.pow(10.0, n);
        long aux = Math.round(num * (double)m);
        return (double)aux / (double)m;
    }
}

